/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.npc;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zawamod.configuration.ZAWAConfig;
import org.zawamod.entity.ai.EntityAIAttackRangedRifle;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.npc.EntityZAWANPC;
import org.zawamod.entity.projectile.EntityRifleBullet;
import org.zawamod.init.ZAWAItems;
import org.zawamod.util.ZAWASounds;

public class EntityPoacher
extends EntityZAWANPC
implements IRangedAttackMob {
    public static final EntityVillager.PriceInfo PRICE = new EntityVillager.PriceInfo(6, 8);
    public static final EntityVillager.PriceInfo AMT = new EntityVillager.PriceInfo(1, 2);
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityPoacher.class, (DataSerializer)DataSerializers.field_187198_h);
    private final EntityAIAttackRangedRifle<EntityPoacher> aiArrowAttack = new EntityAIAttackRangedRifle<EntityPoacher>(this, 1.0, 20, 15.0f);
    private static final EntityZAWANPC.Trade[] ATRADES = new EntityZAWANPC.Trade[]{new EntityZAWANPC.MoneyTrade(ZAWAItems.BIRD_MEAT, PRICE, AMT), new EntityZAWANPC.MoneyTrade(ZAWAItems.LARGE_MEAT_RAW, PRICE, AMT), new EntityZAWANPC.MoneyTrade(ZAWAItems.RAW_CICHLID, PRICE, AMT), new EntityZAWANPC.MoneyTrade(ZAWAItems.RAW_FROG_LEG, PRICE, AMT), new EntityZAWANPC.MoneyTrade(ZAWAItems.RAW_CRAB_LEG, PRICE, AMT), new EntityZAWANPC.MoneyTrade(ZAWAItems.LARGE_MEAT_RAW, PRICE, AMT), new EntityZAWANPC.MoneyTrade(ZAWAItems.BUSH_MEAT_RAW, PRICE, AMT), new EntityZAWANPC.MoneyTrade(ZAWAItems.REPTILE_MEAT_RAW, PRICE, AMT), new EntityZAWANPC.MoneyTrade(ZAWAItems.CARNIVORE_MEAT_RAW, PRICE, AMT), new EntityZAWANPC.MoneyTrade(ZAWAItems.CETACEAN_MEAT_RAW, PRICE, AMT), new EntityZAWANPC.MoneyTrade(ZAWAItems.RAT_RAW, PRICE, AMT), new EntityZAWANPC.MoneyTrade(ZAWAItems.FUR, PRICE, AMT), new EntityZAWANPC.MoneyTrade(ZAWAItems.THICK_FUR, PRICE, AMT), new EntityZAWANPC.MoneyTrade(ZAWAItems.POLAR_BEAR_HIDE, PRICE, AMT), new EntityZAWANPC.MoneyTrade(ZAWAItems.REPTILE_HIDE, PRICE, AMT)};
    private int nextAttack;
    private boolean canAttack;

    public EntityPoacher(World worldIn) {
        super(worldIn);
        this.TRADES = ATRADES;
        this.func_70105_a(0.8f, 1.9f);
        this.setCombatTask();
    }

    public EntityPoacher(World world, EntityZAWANPC.Trade[] trades) {
        super(world, ATRADES);
    }

    @Override
    public void func_70636_d() {
        if (this.func_70638_az() != null && this.func_70638_az().func_110143_aJ() <= 0.0f) {
            this.canAttack = false;
            this.func_70661_as().func_75492_a(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 1.2);
        }
        super.func_70636_d();
        if (this.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL) && this.func_70638_az() != null) {
            this.func_70624_b(null);
        }
        if (!this.canAttack || this.func_70638_az() instanceof AbstractZawaLand && ((AbstractZawaLand)this.func_70638_az()).func_70909_n()) {
            this.func_70624_b(null);
        }
        if (!this.canAttack) {
            ++this.nextAttack;
            if (this.nextAttack >= 200) {
                this.nextAttack = 0;
                this.canAttack = true;
            }
        }
    }

    public void func_70624_b(@Nullable EntityLivingBase ent) {
        super.func_70624_b(ent);
        if (ent instanceof AbstractZawaLand && ((AbstractZawaLand)ent).canFleeFrom((Entity)this)) {
            AbstractZawaLand e = (AbstractZawaLand)ent;
            e.setPredator((Entity)this);
        }
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a(this.aiArrowAttack);
            int i = 25;
            if (this.field_70170_p.func_175659_aa() != EnumDifficulty.HARD) {
                i = 45;
            }
            this.aiArrowAttack.setAttackCooldown(i);
            this.field_70714_bg.func_75776_a(4, this.aiArrowAttack);
        }
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ZAWAItems.RIFLE));
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setCombatTask();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        if (ZAWAConfig.serverOptions.poacherAttacking && !this.field_70170_p.field_72995_K) {
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 10, true, false, o -> this.canAttack && !o.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL)));
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, AbstractZawaLand.class, 10, true, false, o -> this.canAttack && o.isNotTamed() && !o.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL)));
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean a = super.func_70097_a(source, amount);
        if (!this.field_70170_p.field_72995_K && this.func_110143_aJ() <= 0.0f && !this.field_70128_L && source.func_76346_g() instanceof EntityPlayer) {
            MerchantRecipeList b = this.func_70934_b((EntityPlayer)source.func_76346_g());
            for (MerchantRecipe merchantRecipe : b) {
                this.func_145779_a(merchantRecipe.func_77397_d().func_77973_b(), merchantRecipe.func_77397_d().func_190916_E());
            }
            this.func_70106_y();
        }
        return a;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        EntityRifleBullet bullet = new EntityRifleBullet(this.field_70170_p, (EntityLivingBase)this);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - bullet.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        bullet.func_70186_c(d0, d1 + d3 * 0.10000000298023223, d2, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
        this.func_184185_a(ZAWASounds.GUN_SHOT, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)bullet);
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K && slotIn == EntityEquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_180481_a(difficulty);
        this.setCombatTask();
        return livingdata;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(SWINGING_ARMS);
    }

    public void func_184724_a(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }
}

