/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.npc;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zawamod.entity.ai.EntityAILookAtTradePlayerNPC;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.init.ZAWAItems;

public class EntityZAWANPC
extends EntityAgeable
implements INpc,
IMerchant {
    public static final int VARIANTS = 6;
    public Trade[] TRADES = new Trade[1];
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityZAWANPC.class, (DataSerializer)DataSerializers.field_187192_b);
    private EntityPlayer customer;
    private MerchantRecipeList buyingList;
    private int timeUntilReset;
    private boolean needsInitialization;
    private int wealth;
    private final InventoryBasic inv;
    private boolean careToken;
    private int careTimer;
    private Trade[] variantTrades;
    private int careerLevel;

    public void activateToken(int i) {
        if (i == 0) {
            this.careToken = true;
        }
    }

    public EntityZAWANPC(World worldIn) {
        super(worldIn);
        this.func_70930_a(new MerchantRecipeList());
        this.inv = new InventoryBasic("Items", false, 8);
        this.func_70105_a(0.8f, 1.9f);
    }

    public EntityZAWANPC(World world, Trade[] trades) {
        this(world);
        this.TRADES = trades;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new AIInteract());
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, AbstractZawaLand.class, 10.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILookAtTradePlayerNPC(this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        int variant = this.field_70146_Z.nextInt(Math.round(50.0f / (difficulty.func_180168_b() + 1.0f))) == 0 ? 5 : this.field_70146_Z.nextInt(5);
        Trade[] trades = this.TRADES;
        int currentIndex = trades.length;
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setVariant(variant);
        while (currentIndex != 0) {
            int randomIndex = this.field_70146_Z.nextInt(currentIndex);
            if (--currentIndex >= trades.length - 1) continue;
            Trade temporaryValue = trades[currentIndex];
            trades[currentIndex] = trades[randomIndex];
            trades[randomIndex] = temporaryValue;
        }
        this.variantTrades = trades;
        this.populateBuyingList();
        return livingdata;
    }

    private void populateBuyingList() {
        this.careerLevel = this.careerLevel != 0 ? ++this.careerLevel : 3;
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        int j = this.careerLevel - 1;
        if (this.variantTrades != null) {
            for (int i = 0; i < j; ++i) {
                if (this.variantTrades.length - 1 < i) continue;
                this.variantTrades[i].func_190888_a(this, this.buyingList, this.field_70146_Z);
            }
        }
    }

    @Nullable
    public EntityAgeable func_90011_a(@Nonnull EntityAgeable ageable) {
        return null;
    }

    public void func_70932_a_(@Nullable EntityPlayer player) {
        this.customer = player;
    }

    @Nullable
    public EntityPlayer func_70931_l_() {
        return this.customer;
    }

    @Nullable
    public MerchantRecipeList func_70934_b(@Nonnull EntityPlayer player) {
        if (this.buyingList == null) {
            this.populateBuyingList();
        }
        return this.buyingList;
    }

    public void func_70930_a(@Nullable MerchantRecipeList recipeList) {
        this.buyingList = recipeList;
    }

    public void func_70933_a(@Nonnull MerchantRecipe recipe) {
        recipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        int i = 3 + this.field_70146_Z.nextInt(4);
        if (recipe.func_180321_e() == 1 || this.field_70146_Z.nextInt(5) == 0) {
            this.timeUntilReset = 40;
            this.needsInitialization = true;
            i += 5;
        }
        if (recipe.func_77394_a().func_77973_b() == ZAWAItems.COIN) {
            this.wealth += recipe.func_77394_a().func_190916_E();
        }
        if (recipe.func_180322_j()) {
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playEffect(EnumParticleTypes particleType) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    public void func_110297_a_(@Nonnull ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
        }
    }

    @Nonnull
    public World func_190670_t_() {
        return this.field_70170_p;
    }

    @Nonnull
    public BlockPos func_190671_u_() {
        return this.func_180425_c();
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    private void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    private boolean hasEnoughItems(boolean multiple) {
        for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
            ItemStack stack = this.inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != ZAWAItems.COIN || stack.func_190916_E() < (multiple ? 6 : 3)) continue;
            return true;
        }
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.18);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    public boolean func_184645_a(EntityPlayer player, @Nonnull EnumHand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = itemstack.func_77973_b() == Items.field_151057_cb;
        if (flag) {
            itemstack.func_111282_a(player, (EntityLivingBase)this, hand);
            return true;
        }
        if (!this.func_190669_a(itemstack, ((Object)((Object)this)).getClass()) && this.func_70089_S() && this.customer == null && !this.func_70631_g_() && !player.func_70093_af()) {
            if (hand == EnumHand.MAIN_HAND) {
                player.func_71029_a(StatList.field_188074_H);
            }
            if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null) {
                if (this.buyingList == null) {
                    this.populateBuyingList();
                }
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
            } else if (this.buyingList.isEmpty()) {
                return super.func_184645_a(player, hand);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Nullable
    protected Item func_146068_u() {
        return ZAWAItems.COIN;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("variant", this.getVariant());
        compound.func_74768_a("Riches", this.wealth);
        if (this.buyingList != null) {
            compound.func_74782_a("Offers", (NBTBase)this.buyingList.func_77202_a());
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
            ItemStack stack = this.inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            list.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74782_a("Inventory", (NBTBase)list);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("variant"));
        this.wealth = compound.func_74762_e("Riches");
        if (compound.func_150297_b("Offers", 10)) {
            NBTTagCompound nbttagcompound = compound.func_74775_l("Offers");
            this.buyingList = new MerchantRecipeList(nbttagcompound);
        }
        NBTTagList list = compound.func_150295_c("Inventory", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack stack = new ItemStack(list.func_150305_b(i));
            if (stack.func_190926_b()) continue;
            this.inv.func_174894_a(stack);
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return ZAWAItems.SPAWN_EGG_DATA.containsKey(((Object)((Object)this)).getClass()) ? ZAWAItems.SPAWN_EGG_DATA.get(((Object)((Object)this)).getClass()) : super.getPickedResult(target);
    }

    public static class MoneyTrade
    extends Trade {
        MoneyTrade(ItemStack buy, EntityVillager.PriceInfo price, EntityVillager.PriceInfo amount) {
            super(ZAWAItems.COIN, buy, price, amount);
        }

        MoneyTrade(Item buy, EntityVillager.PriceInfo price, EntityVillager.PriceInfo amount) {
            super(ZAWAItems.COIN, new ItemStack(buy), price, amount);
        }

        MoneyTrade(ItemStack buy, int price, int amount) {
            super(ZAWAItems.COIN, buy, price, amount);
        }
    }

    public static class Trade
    implements EntityVillager.ITradeList {
        Item sell;
        ItemStack buy;
        EntityVillager.PriceInfo price;
        EntityVillager.PriceInfo amount;

        Trade(Item sell, ItemStack buy, EntityVillager.PriceInfo price, EntityVillager.PriceInfo amount) {
            this.price = price;
            this.amount = amount;
            this.sell = sell;
            this.buy = buy;
        }

        Trade(Item sell, ItemStack buy, int price, int amount) {
            this(sell, buy, new EntityVillager.PriceInfo(price, price), new EntityVillager.PriceInfo(amount, amount));
            this.buy = buy;
        }

        public void func_190888_a(@Nonnull IMerchant merchant, @Nonnull MerchantRecipeList recipeList, @Nonnull Random random) {
            recipeList.add((Object)new MerchantRecipe(new ItemStack(this.sell, this.price.func_179412_a(random)), new ItemStack(this.buy.func_77973_b(), this.amount.func_179412_a(random))));
        }
    }

    public class AIInteract
    extends EntityAIWatchClosest2 {
        private int interactionDelay;
        private final EntityZAWANPC rabbitman;

        AIInteract() {
            super((EntityLiving)EntityZAWANPC.this, EntityZAWANPC.class, 3.0f, 0.02f);
            this.rabbitman = (EntityZAWANPC)this.field_75332_b;
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.interactionDelay = this.rabbitman.hasEnoughItems(true) && this.field_75334_a instanceof EntityVillager && ((EntityVillager)this.field_75334_a).func_175557_cr() ? 10 : 0;
        }

        public void func_75246_d() {
            super.func_75246_d();
            if (this.interactionDelay > 0) {
                --this.interactionDelay;
                if (this.interactionDelay == 0) {
                    InventoryBasic inventorybasic = this.rabbitman.inv;
                    for (int i = 0; i < inventorybasic.func_70302_i_(); ++i) {
                        Item item;
                        ItemStack stack = inventorybasic.func_70301_a(i);
                        ItemStack empty = ItemStack.field_190927_a;
                        if (!stack.func_190926_b()) {
                            item = stack.func_77973_b();
                            if (item == ZAWAItems.COIN && stack.func_190916_E() > 3) {
                                int l = stack.func_190916_E() / 2;
                                stack.func_190918_g(l);
                                empty = new ItemStack(item, l, stack.func_77960_j());
                            }
                            if (stack.func_190926_b()) {
                                inventorybasic.func_70299_a(i, ItemStack.field_190927_a);
                            }
                        }
                        if (empty.func_190926_b()) continue;
                        item = new EntityItem(this.rabbitman.field_70170_p, this.rabbitman.field_70165_t, this.rabbitman.field_70163_u - 0.3 + (double)this.rabbitman.func_70047_e(), this.rabbitman.field_70161_v, empty);
                        float head = this.rabbitman.field_70759_as;
                        float pitch = this.rabbitman.field_70125_A;
                        item.field_70159_w = Math.sin(-Math.toRadians(head)) * Math.toRadians(pitch) * (double)0.3f;
                        item.field_70179_y = Math.cos(Math.toRadians(head)) * Math.toRadians(pitch) * 0.3;
                        item.field_70181_x = Math.sin(-Math.toRadians(pitch)) * 0.3 + 0.1;
                        item.func_174869_p();
                        this.rabbitman.field_70170_p.func_72838_d((Entity)item);
                        break;
                    }
                }
            }
        }
    }
}

