/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.painting;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zawamod.entity.painting.Paint;

public abstract class EntityZAWAPainting
extends EntityHanging
implements IEntityAdditionalSpawnData {
    public Paint art;
    private int id;

    public EntityZAWAPainting(World worldIn) {
        super(worldIn);
    }

    public abstract Paint[] getPaintings();

    public abstract ItemStack getItem();

    public EntityZAWAPainting(World worldIn, BlockPos pos, EnumFacing side) {
        super(worldIn, pos);
        this.art = this.getPaintings()[this.field_70146_Z.nextInt(this.getPaintings().length)];
        this.func_174859_a(side);
    }

    public EntityZAWAPainting(World worldIn, BlockPos pos, EnumFacing side, Paint art) {
        this(worldIn, pos, side);
        this.art = art;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return this.getItem();
    }

    @SideOnly(value=Side.CLIENT)
    public EntityZAWAPainting(World worldIn, BlockPos pos, EnumFacing side, String name) {
        this(worldIn, pos, side);
        for (Paint p : this.getPaintings()) {
            if (!p.title.equals(name)) continue;
            this.art = p;
            break;
        }
        this.func_174859_a(side);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("Motive", this.art.title);
        super.func_70014_b(tagCompound);
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        String s = tagCompund.func_74779_i("Motive");
        for (Paint p : this.getPaintings()) {
            if (!p.title.equals(s)) continue;
            this.art = p;
            break;
        }
        if (this.art == null) {
            this.art = this.getPaintings()[0];
        }
        super.func_70037_a(tagCompund);
    }

    public int func_82329_d() {
        return this.art.x;
    }

    public int func_82330_g() {
        return this.art.y;
    }

    public void func_110128_b(Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            if (entityplayer.field_71075_bZ.field_75098_d) {
                return;
            }
        }
        this.func_70099_a(this.getItem(), 0.0f);
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
        this.func_70107_b(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        BlockPos blockpos = this.field_174861_a.func_177963_a(x - this.field_70165_t, y - this.field_70163_u, z - this.field_70161_v);
        this.func_70107_b(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (!this.getPaintings()[this.id].title.equals(this.art.title)) {
            for (int i = 0; i < this.getPaintings().length; ++i) {
                if (!this.getPaintings()[i].title.equals(this.art.title)) continue;
                this.id = i;
                break;
            }
        }
        buffer.writeInt(this.id);
        buffer.writeInt(this.field_174861_a.func_177958_n());
        buffer.writeInt(this.field_174861_a.func_177956_o());
        buffer.writeInt(this.field_174861_a.func_177952_p());
        buffer.writeByte(this.func_174811_aO().func_176745_a());
    }

    public void readSpawnData(ByteBuf buffer) {
        BlockPos pos;
        this.art = this.getPaintings()[buffer.readInt()];
        int x = buffer.readInt();
        int y = buffer.readInt();
        int z = buffer.readInt();
        this.field_174861_a = pos = new BlockPos(x, y, z);
        this.func_174859_a(EnumFacing.func_82600_a((int)buffer.readByte()));
    }

    public void func_184523_o() {
    }
}

