/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.gui;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.util.book.data.BookContent;

public class GuiDataBook
extends GuiScreen {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final int ImageHeight = 201;
    private static final int ImageWidth = 318;
    private static final ResourceLocation GUITextures = new ResourceLocation("zawa:textures/gui/data.png");
    private static final ResourceLocation FRAME = new ResourceLocation("zawa:textures/gui/icon/frame.png");
    public static Object viewedObject = null;
    public static BookContent<?> viewedContent = null;
    public static String zooKeeper = I18n.func_135052_a((String)"zawa.gui.zookeeper", (Object[])new Object[0]);
    public static String tamedOn = I18n.func_135052_a((String)"zawa.gui.tamed_on", (Object[])new Object[0]);
    public static String male = I18n.func_135052_a((String)"zawa.gui.male", (Object[])new Object[0]);
    public static String female = I18n.func_135052_a((String)"zawa.gui.female", (Object[])new Object[0]);
    public static String sex = I18n.func_135052_a((String)"zawa.gui.sex", (Object[])new Object[0]);
    public static String variant = I18n.func_135052_a((String)"zawa.gui.variant", (Object[])new Object[0]);
    public static String trait = I18n.func_135052_a((String)"zawa.gui.trait", (Object[])new Object[0]);
    public static String tamedWith = I18n.func_135052_a((String)"zawa.gui.tamed_with", (Object[])new Object[0]);
    public static String bredWith = I18n.func_135052_a((String)"zawa.gui.bred_with", (Object[])new Object[0]);
    public static String diet = I18n.func_135052_a((String)"zawa.gui.diet", (Object[])new Object[0]);
    public static String enrichment = I18n.func_135052_a((String)"zawa.gui.enrichment", (Object[])new Object[0]);
    public static String scientific = I18n.func_135052_a((String)"zawa.gui.science", (Object[])new Object[0]);
    public static String conservation = I18n.func_135052_a((String)"zawa.gui.conservation", (Object[])new Object[0]);
    public static String regionStr = I18n.func_135052_a((String)"zawa.gui.region", (Object[])new Object[0]);
    String pageStr = I18n.func_135052_a((String)"zawa.gui.page", (Object[])new Object[0]);
    public float mousePosX;
    public float mousePosY;
    private int page = 0;
    private int totalPages = 1;
    private PageButton buttonNext;
    private PageButton buttonBack;
    public boolean hasDebug;
    public static final int SECONDARY_TEXT_COLOR = 0x787777;

    public GuiDataBook() {
        this.hasDebug = GuiDataBook.mc.field_71474_y.field_74330_P;
    }

    public void func_73866_w_() {
        int offLeft = (this.field_146294_l - 318) / 2 - 40;
        int offTop = -75;
        this.field_146292_n.clear();
        viewedContent.onInitGUI(this, offLeft, offTop);
        this.totalPages = viewedContent.getTotalPages();
        if (this.totalPages > 0) {
            this.buttonNext = new PageButton(0, offLeft + 339 - 20, 254 + offTop, true);
            this.field_146292_n.add(this.buttonNext);
            this.buttonBack = new PageButton(1, offLeft + -100 + 157, 254 + offTop, false);
            this.field_146292_n.add(this.buttonBack);
        }
    }

    public void func_73876_c() {
        viewedContent.updateScreen(this);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (viewedContent != null) {
            viewedContent.handleMouseInput(this);
        }
    }

    public int getPage() {
        return this.page;
    }

    public void func_73863_a(int parWidth, int parHeight, float partial) {
        GlStateManager.func_179094_E();
        this.mousePosX = parWidth;
        this.mousePosY = parHeight;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179142_g();
        int offLeft = (int)((float)(this.field_146294_l - 318) / 2.0f);
        int offTop = 5;
        mc.func_110434_K().func_110577_a(GUITextures);
        GuiDataBook.func_146110_a((int)(offLeft - 10), (int)offTop, (float)0.0f, (float)0.0f, (int)338, (int)201, (float)338.0f, (float)259.0f);
        viewedContent.drawScreen(this, this.field_146289_q, offLeft, offTop, parWidth, parHeight, partial);
        if (this.page == 0) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)40.0f);
            viewedContent.renderObject(this, offLeft, offTop, this.mousePosX, this.mousePosY, this.field_146294_l, this.field_146295_m, 318.0f, 201.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
            if (this.hasDebug) {
                int j = this.field_146289_q.field_78288_b;
                int i1 = (int)(2.0f + (float)j * 18.0f);
                GuiDataBook.func_73734_a((int)1, (int)(i1 - 1), (int)122, (int)(this.field_146295_m - 5), (int)-1873784752);
                viewedContent.debugRender(this, this.field_146289_q, parWidth, parHeight, partial);
            }
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179142_g();
        super.func_73863_a(parWidth, parHeight, partial);
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
        GlStateManager.func_179091_B();
        GlStateManager.func_179121_F();
        if (this.totalPages != 0) {
            this.field_146289_q.func_78276_b(this.pageStr + ": " + (this.page + 1) + "/" + (this.totalPages + 1), offLeft + 210, offTop + 175, 0);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1 || keyCode == GuiDataBook.mc.field_71474_y.field_151445_Q.func_151463_i()) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        }
    }

    protected void func_146273_a(int parMouseX, int parMouseY, int parLastButtonClicked, long parTimeSinceMouseClick) {
    }

    protected void func_146284_a(GuiButton button) {
        viewedContent.actionPerformed(this, button);
        if (button == this.buttonNext) {
            if (this.page < this.totalPages) {
                ++this.page;
                viewedContent.onPageChange(this);
            }
        } else if (button == this.buttonBack && this.page > 0) {
            --this.page;
            viewedContent.onPageChange(this);
        }
    }

    public RenderItem getItemRenderer() {
        return this.field_146296_j;
    }

    public void func_146281_b() {
        viewedContent.onGUIClose(this);
        viewedObject = null;
        viewedContent = null;
    }

    public boolean func_73868_f() {
        return false;
    }

    public List<GuiButton> getButtonList() {
        return this.field_146292_n;
    }

    @SideOnly(value=Side.CLIENT)
    static class PageButton
    extends GuiButton {
        private final boolean isForward;

        public PageButton(int buttonId, int x, int y, boolean isForwardIn) {
            super(buttonId, x, y, 23, 13, "");
            this.isForward = isForwardIn;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(GUITextures);
                int i = 0;
                int j = 192;
                if (flag) {
                    i += 23;
                }
                if (!this.isForward) {
                    j += 13;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, i, j + 8, 23, 13);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class IconButton
    extends GuiButton {
        private final ResourceLocation texture;
        private final GuiScreen gui;
        private Function<AbstractZawaLand, String> function;
        private final AbstractZawaLand animal;

        public IconButton(AbstractZawaLand animal, int id, int x, int y, int width, int height, String text, GuiScreen gui, ResourceLocation texture) {
            super(id, x, y, width, height, text);
            this.texture = texture;
            this.gui = gui;
            this.animal = animal;
        }

        public IconButton(AbstractZawaLand animal, int id, int x, int y, int width, int height, Function<AbstractZawaLand, String> text, GuiScreen gui, ResourceLocation texture) {
            this(animal, id, x, y, width, height, "", gui, texture);
            this.function = text;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            GlStateManager.func_179094_E();
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(FRAME);
                Gui.func_146110_a((int)(this.field_146128_h - 2), (int)(this.field_146129_i - 2), (float)0.0f, (float)0.0f, (int)20, (int)20, (float)20.0f, (float)20.0f);
                if (flag) {
                    GlStateManager.func_179131_c((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
                }
                mc.func_110434_K().func_110577_a(this.texture);
                Gui.func_146110_a((int)this.field_146128_h, (int)this.field_146129_i, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (flag) {
                    this.gui.func_146279_a(this.function == null ? this.field_146126_j : this.function.apply(this.animal), mouseX, mouseY);
                    GlStateManager.func_179101_C();
                    RenderHelper.func_74518_a();
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179097_i();
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class GenericButton
    extends GuiButton {
        public GenericButton(int id, int x, int y, int width, int height, String text) {
            super(id, x, y, width, height, text);
        }
    }
}

