/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zawamod.ZAWAMain;

@SideOnly(value=Side.CLIENT)
public class BookLoader
implements ISelectiveResourceReloadListener {
    private final String modID;

    public BookLoader(String modID) {
        this.modID = modID;
    }

    public static void run(Side side) {
        if (side.isClient() && Minecraft.func_71410_x().func_110442_L() instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)new BookLoader("zawa"));
        }
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        ResourceLocation resource;
        if (this.modID.equals("zawa")) {
            ZAWAMain.BOOK_INFO.clear();
        }
        try {
            ResourceLocation a = new ResourceLocation(this.modID, "data/book/" + Minecraft.func_71410_x().field_71474_y.field_74363_ab + "_data.json");
            new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(a).func_110527_b());
            resource = a;
            System.out.println("data/" + Minecraft.func_71410_x().field_71474_y.field_74363_ab + "_data.json");
        }
        catch (IOException e) {
            e.printStackTrace();
            resource = new ResourceLocation(this.modID, "data/book/en_us_data.json");
        }
        try {
            JsonObject jo = (JsonObject)new JsonParser().parse((Reader)new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(resource).func_110527_b()));
            JsonArray array = jo.getAsJsonArray("data");
            for (int i = 0; i < array.size(); ++i) {
                JsonObject o = array.get(i).getAsJsonObject();
                BookInfo info = new BookInfo();
                if (o.has("e")) {
                    info.clazz = o.get("e").getAsString();
                }
                if (o.has("pg")) {
                    info.page = o.get("pg").getAsString();
                }
                if (o.has("pg2")) {
                    info.page2 = o.get("pg2").getAsString();
                }
                if (o.has("cv")) {
                    info.cv = o.get("cv").getAsString();
                }
                if (o.has("sci")) {
                    info.sci = o.get("sci").getAsString();
                }
                if (o.has("rg")) {
                    info.region = o.get("rg").getAsString();
                }
                if (o.has("v")) {
                    info.variant = o.get("v").getAsInt();
                }
                if (!ZAWAMain.BOOK_INFO.containsKey(info.clazz)) {
                    ZAWAMain.BOOK_INFO.put(info.clazz, info);
                    continue;
                }
                ZAWAMain.BOOK_INFO.get((Object)info.clazz).variations.put(info.variant, info);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class BookInfo {
        public String clazz;
        public String page;
        public String page2;
        public String cv;
        public String sci;
        public String region;
        public int variant = -1;
        public Map<Integer, BookInfo> variations = new HashMap<Integer, BookInfo>();

        public BookInfo(String clazz, String page) {
            this.clazz = clazz;
            this.page = page;
        }

        public BookInfo() {
        }
    }
}

