/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.util;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.soggymustache.bookworm.common.entity.data.Gender;
import org.zawamod.entity.core.AnimalData;

public class ZAWAUtils {
    @Nullable
    public static Item getItem(String string) {
        if (Loader.isModLoaded((String)string.split(":")[0])) {
            for (Item item : ForgeRegistries.ITEMS.getValuesCollection()) {
                if (!item.getRegistryName().toString().equals(string)) continue;
                return item;
            }
            for (Item item : ForgeRegistries.BLOCKS.getValuesCollection()) {
                if (!item.getRegistryName().toString().equals(string)) continue;
                return Item.func_150898_a((Block)item);
            }
        }
        return null;
    }

    public static boolean entityWithinArea(Entity e, BlockPos starting, int bounds) {
        for (int i = -bounds; i < bounds; ++i) {
            for (int j = -bounds; j < bounds; ++j) {
                if ((int)e.field_70165_t != starting.func_177982_a(i, 0, j).func_177958_n() || (int)e.field_70161_v != starting.func_177982_a(i, 0, j).func_177952_p()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean movingUp(Entity entity) {
        return entity.field_70163_u > entity.field_70167_r;
    }

    public static boolean movingDown(Entity entity) {
        return entity.field_70163_u < entity.field_70167_r;
    }

    public static Gender getGenderFromValue(byte i) {
        return Gender.values()[i];
    }

    public static String splitCamelCase(String s) {
        return s.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
    }

    public static boolean isEntityMoving(Entity e) {
        return e.field_70165_t != e.field_70169_q && e.field_70161_v != e.field_70166_s;
    }

    public static String getTraitName(int traitID) {
        return AnimalData.Traits.values()[traitID].name().substring(0, 1) + AnimalData.Traits.values()[traitID].name().substring(1).toLowerCase();
    }

    public static AnimalData.Traits getTraitFromValue(int traitID) {
        if (traitID < 0 || traitID > AnimalData.Traits.values().length) {
            return AnimalData.Traits.NONE;
        }
        return AnimalData.Traits.values()[traitID];
    }

    public static boolean blockAtPos(World worldObj, Block block, double posX, double posY, double posZ) {
        return worldObj.func_180495_p(new BlockPos((int)posX, (int)posY, (int)posZ)).func_177230_c() == block;
    }

    public static Entity getClosestEntityToEntity(Class<? extends Entity> target, Entity e, double distance) {
        return ZAWAUtils.getClosestEntity2(target, e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, distance);
    }

    public static Entity getClosestEntityToPlayer(EntityPlayer entityIn, double distance) {
        return ZAWAUtils.getClosestEntity(entityIn.field_70170_p, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, distance);
    }

    public static Entity getClosestEntity2(Class search, World world, double x, double y, double z, double distance) {
        double initial = -1.0;
        Entity entityFound = null;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity currE = (Entity)world.field_72996_f.get(i);
            if (currE.getClass() != search) continue;
            double distSqr = currE.func_70092_e(x, y, z);
            if (!(distance < 0.0) && !(distSqr < distance * distance) || initial != -1.0 && !(distSqr < initial)) continue;
            initial = distSqr;
            entityFound = currE;
        }
        return entityFound;
    }

    public static Entity getClosestEntity(World world, double x, double y, double z, double distance) {
        double initial = -1.0;
        Entity entityFound = null;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity currE = (Entity)world.field_72996_f.get(i);
            if (currE instanceof EntityPlayer) continue;
            double distSqr = currE.func_70092_e(x, y, z);
            if (!(distance < 0.0) && !(distSqr < distance * distance) || initial != -1.0 && !(distSqr < initial)) continue;
            initial = distSqr;
            entityFound = currE;
        }
        return entityFound;
    }
}

