/*
 * Decompiled with CFR 0.152.
 */
package net.soggymustache.bookworm.client.model;

import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public class CMFRig {
    private Map<BookwormModelRenderer, String> mapping = new HashMap<BookwormModelRenderer, String>();
    private final ModelCMF model;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMFRig(ModelCMF model, ResourceLocation resource) {
        this.model = model;
        try {
            InputStream stream = Minecraft.func_71410_x().func_110442_L().func_110536_a(resource).func_110527_b();
            byte[] buffer = new byte[1024];
            String information = "";
            try (ZipArchiveInputStream zip2 = new ZipArchiveInputStream(stream);){
                ZipArchiveEntry entry = zip2.getNextZipEntry();
                while (entry != null) {
                    int len;
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    while ((len = zip2.read(buffer)) > 0) {
                        outputStream.write(buffer, 0, len);
                    }
                    information = outputStream.toString("" + Charsets.UTF_8);
                    entry = zip2.getNextZipEntry();
                    outputStream.close();
                }
            }
            Scanner in = new Scanner(information);
            while (in.hasNextLine()) {
                String line = in.nextLine();
                if (!line.startsWith("r")) continue;
                line = line.substring(2);
                String part = line.split(";")[0];
                String name = line.split(";")[1];
                this.mapping.put(model.getPartByName(part), name);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Map<BookwormModelRenderer, String> getPartMap() {
        return this.mapping;
    }

    public BookwormModelRenderer getPartByRig(String name) {
        for (Map.Entry<BookwormModelRenderer, String> e : this.mapping.entrySet()) {
            if (!e.getValue().equals(name)) continue;
            return e.getKey();
        }
        return this.model.getPartByNoRigName(name);
    }
}

