/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.IPasswordConvertible;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.KeypadChestTileEntity;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class KeypadChestBlock
extends ChestBlock
implements IPasswordConvertible {
    public KeypadChestBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200948_a(-1.0f, 6000000.0f), () -> SCContent.teTypeKeypadChest);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof KeypadChestTileEntity && !KeypadChestBlock.isBlocked(world, pos)) {
            if (ModuleUtils.checkForModule(world, pos, player, ModuleType.BLACKLIST)) {
                return ActionResultType.FAIL;
            }
            if (ModuleUtils.checkForModule(world, pos, player, ModuleType.WHITELIST)) {
                KeypadChestBlock.activate(world, pos, player);
            } else if (!PlayerUtils.isHoldingItem(player, SCContent.CODEBREAKER)) {
                ((KeypadChestTileEntity)world.func_175625_s(pos)).openPasswordGUI(player);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public static void activate(World world, BlockPos pos, PlayerEntity player) {
        BlockState state;
        ChestBlock block;
        INamedContainerProvider inamedcontainerprovider;
        if (!world.field_72995_K && (inamedcontainerprovider = (block = (ChestBlock)(state = world.func_180495_p(pos)).func_177230_c()).func_220052_b(state, world, pos)) != null) {
            player.func_213829_a(inamedcontainerprovider);
            player.func_71029_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188063_ac));
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        if (entity instanceof PlayerEntity) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (PlayerEntity)entity));
        }
        if (world.func_175625_s(pos.func_177974_f()) instanceof KeypadChestTileEntity) {
            ((KeypadChestTileEntity)world.func_175625_s(pos)).setPassword(((KeypadChestTileEntity)world.func_175625_s(pos.func_177974_f())).getPassword());
        } else if (world.func_175625_s(pos.func_177976_e()) instanceof KeypadChestTileEntity) {
            ((KeypadChestTileEntity)world.func_175625_s(pos)).setPassword(((KeypadChestTileEntity)world.func_175625_s(pos.func_177976_e())).getPassword());
        } else if (world.func_175625_s(pos.func_177968_d()) instanceof KeypadChestTileEntity) {
            ((KeypadChestTileEntity)world.func_175625_s(pos)).setPassword(((KeypadChestTileEntity)world.func_175625_s(pos.func_177968_d())).getPassword());
        } else if (world.func_175625_s(pos.func_177978_c()) instanceof KeypadChestTileEntity) {
            ((KeypadChestTileEntity)world.func_175625_s(pos)).setPassword(((KeypadChestTileEntity)world.func_175625_s(pos.func_177978_c())).getPassword());
        }
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
        KeypadChestTileEntity ChestTileEntity2 = (KeypadChestTileEntity)world.func_175625_s(pos);
        if (ChestTileEntity2 != null) {
            ChestTileEntity2.func_145836_u();
        }
    }

    public TileEntity func_196283_a_(IBlockReader reader) {
        return new KeypadChestTileEntity();
    }

    public static boolean isBlocked(World world, BlockPos pos) {
        return KeypadChestBlock.isBelowSolidBlock(world, pos);
    }

    private static boolean isBelowSolidBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177984_a()).func_215686_e((IBlockReader)world, pos.func_177984_a());
    }

    @Override
    public Block getOriginalBlock() {
        return Blocks.field_150486_ae;
    }

    @Override
    public boolean convert(PlayerEntity player, World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Direction facing = (Direction)state.func_177229_b((Property)field_176459_a);
        ChestType type = (ChestType)state.func_177229_b((Property)field_196314_b);
        this.convertChest(player, world, pos, facing, type);
        if (type != ChestType.SINGLE) {
            BlockPos newPos = pos.func_177972_a(KeypadChestBlock.func_196311_i((BlockState)state));
            BlockState newState = world.func_180495_p(newPos);
            Direction newFacing = (Direction)newState.func_177229_b((Property)field_176459_a);
            ChestType newType = (ChestType)newState.func_177229_b((Property)field_196314_b);
            this.convertChest(player, world, newPos, newFacing, newType);
        }
        return true;
    }

    private void convertChest(PlayerEntity player, World world, BlockPos pos, Direction facing, ChestType type) {
        ChestTileEntity chest = (ChestTileEntity)world.func_175625_s(pos);
        CompoundNBT tag = chest.func_189515_b(new CompoundNBT());
        chest.func_174888_l();
        world.func_175656_a(pos, (BlockState)((BlockState)((Block)SCContent.KEYPAD_CHEST.get()).func_176223_P().func_206870_a((Property)field_176459_a, (Comparable)facing)).func_206870_a((Property)field_196314_b, (Comparable)type));
        ((IOwnable)world.func_175625_s(pos)).getOwner().set(player.func_110124_au().toString(), player.func_200200_C_().getString());
        ((ChestTileEntity)world.func_175625_s(pos)).func_230337_a_(world.func_180495_p(pos), tag);
    }
}

