/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.PortableRadarTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class PortableRadarBlock
extends OwnableBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    private static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0);

    public PortableRadarBlock(Material material) {
        super(AbstractBlock.Properties.func_200945_a((Material)material).func_200948_a(-1.0f, 6000000.0f));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return BlockUtils.isSideSolid(world, pos.func_177977_b(), Direction.UP);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean flag) {
        if (world.func_180495_p(pos.func_177977_b()).func_185904_a() != Material.field_151579_a) {
            return;
        }
        world.func_175655_b(pos, true);
    }

    public static void togglePowerOutput(World world, BlockPos pos, boolean par5) {
        if (par5 && !((Boolean)world.func_180495_p(pos).func_177229_b((Property)POWERED)).booleanValue()) {
            BlockUtils.setBlockProperty(world, pos, POWERED, true, true);
            BlockUtils.updateAndNotify(world, pos, BlockUtils.getBlock((IBlockReader)world, pos), 1, false);
        } else if (!par5 && ((Boolean)world.func_180495_p(pos).func_177229_b((Property)POWERED)).booleanValue()) {
            BlockUtils.setBlockProperty(world, pos, POWERED, false, true);
            BlockUtils.updateAndNotify(world, pos, BlockUtils.getBlock((IBlockReader)world, pos), 1, false);
        }
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState blockState, IBlockReader world, BlockPos pos, Direction side) {
        if (((Boolean)blockState.func_177229_b((Property)POWERED)).booleanValue() && ((IModuleInventory)world.func_175625_s(pos)).hasModule(ModuleType.REDSTONE)) {
            return 15;
        }
        return 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWERED});
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PortableRadarTileEntity().attacks(PlayerEntity.class, (Double)ConfigHandler.CONFIG.portableRadarSearchRadius.get(), (Integer)ConfigHandler.CONFIG.portableRadarDelay.get()).nameable();
    }
}

