/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import java.util.stream.Stream;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.tileentity.ProjectorTileEntity;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class ProjectorBlock
extends DisguisableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    private static final VoxelShape NORTH = Stream.of(Block.func_208617_a((double)3.0, (double)5.0, (double)0.9, (double)6.0, (double)8.0, (double)1.9), Block.func_208617_a((double)0.0, (double)3.0, (double)1.0, (double)16.0, (double)10.0, (double)16.0), Block.func_208617_a((double)2.0, (double)8.0, (double)0.5, (double)7.0, (double)9.0, (double)1.0), Block.func_208617_a((double)2.0, (double)4.0, (double)0.5, (double)7.0, (double)5.0, (double)1.0), Block.func_208617_a((double)6.0, (double)5.0, (double)0.5, (double)7.0, (double)8.0, (double)1.0), Block.func_208617_a((double)2.0, (double)5.0, (double)0.5, (double)3.0, (double)8.0, (double)1.0), Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)2.0, (double)3.0, (double)3.0), Block.func_208617_a((double)14.0, (double)0.0, (double)1.0, (double)16.0, (double)3.0, (double)3.0), Block.func_208617_a((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)3.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).orElse(VoxelShapes.func_197868_b());
    private static final VoxelShape SOUTH = Stream.of(Block.func_208617_a((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)10.0, (double)15.0), Block.func_208617_a((double)10.0, (double)5.0, (double)14.1, (double)13.0, (double)8.0, (double)15.100000000000001), Block.func_208617_a((double)9.0, (double)8.0, (double)15.0, (double)14.0, (double)9.0, (double)15.5), Block.func_208617_a((double)9.0, (double)4.0, (double)15.0, (double)14.0, (double)5.0, (double)15.5), Block.func_208617_a((double)9.0, (double)5.0, (double)15.0, (double)10.0, (double)8.0, (double)15.5), Block.func_208617_a((double)13.0, (double)5.0, (double)15.0, (double)14.0, (double)8.0, (double)15.5), Block.func_208617_a((double)14.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)2.0, (double)3.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)3.0, (double)2.0), Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).orElse(VoxelShapes.func_197868_b());
    private static final VoxelShape WEST = Stream.of(Block.func_208617_a((double)0.5, (double)5.0, (double)13.0, (double)1.0, (double)8.0, (double)14.0), Block.func_208617_a((double)0.5, (double)5.0, (double)9.0, (double)1.0, (double)8.0, (double)10.0), Block.func_208617_a((double)0.5, (double)4.0, (double)9.0, (double)1.0, (double)5.0, (double)14.0), Block.func_208617_a((double)0.5, (double)8.0, (double)9.0, (double)1.0, (double)9.0, (double)14.0), Block.func_208617_a((double)0.75, (double)5.0, (double)10.0, (double)1.75, (double)8.0, (double)13.0), Block.func_208617_a((double)1.0, (double)0.0, (double)14.0, (double)3.0, (double)3.0, (double)16.0), Block.func_208617_a((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0), Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0), Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)2.0), Block.func_208617_a((double)1.0, (double)3.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).orElse(VoxelShapes.func_197868_b());
    private static final VoxelShape EAST = Stream.of(Block.func_208617_a((double)15.0, (double)5.0, (double)2.0, (double)15.5, (double)8.0, (double)3.0), Block.func_208617_a((double)15.0, (double)5.0, (double)6.0, (double)15.5, (double)8.0, (double)7.0), Block.func_208617_a((double)15.0, (double)4.0, (double)2.0, (double)15.5, (double)5.0, (double)7.0), Block.func_208617_a((double)15.0, (double)8.0, (double)2.0, (double)15.5, (double)9.0, (double)7.0), Block.func_208617_a((double)14.25, (double)5.0, (double)3.0, (double)15.25, (double)8.0, (double)6.0), Block.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)15.0, (double)3.0, (double)2.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)3.0, (double)2.0), Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)3.0, (double)16.0), Block.func_208617_a((double)13.0, (double)0.0, (double)14.0, (double)15.0, (double)3.0, (double)16.0), Block.func_208617_a((double)0.0, (double)3.0, (double)0.0, (double)15.0, (double)10.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).orElse(VoxelShapes.func_197868_b());

    public ProjectorBlock(AbstractBlock.Properties properties) {
        super(SoundType.field_185852_e, properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, world, pos);
        if (disguisedState.func_177230_c() != this) {
            return disguisedState.func_215700_a(world, pos, ctx);
        }
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return SOUTH;
            }
            case EAST: {
                return WEST;
            }
            case SOUTH: {
                return NORTH;
            }
            case WEST: {
                return EAST;
            }
        }
        return VoxelShapes.func_197868_b();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof ProjectorTileEntity)) {
            return ActionResultType.FAIL;
        }
        boolean isOwner = ((IOwnable)te).getOwner().isOwner(player);
        if (!world.field_72995_K && isOwner) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te), (BlockPos)pos);
        }
        return isOwner ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof ProjectorTileEntity) {
            ItemEntity item = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ((ProjectorTileEntity)world.func_175625_s(pos)).func_70301_a(9));
            WorldUtils.addScheduledTask((IWorld)world, () -> world.func_217376_c((Entity)item));
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof ProjectorTileEntity && ((ProjectorTileEntity)world.func_175625_s(pos)).isActivatedByRedstone()) {
            ((ProjectorTileEntity)world.func_175625_s(pos)).setActive(world.func_175640_z(pos));
            ((ProjectorTileEntity)world.func_175625_s(pos)).sync();
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (!world.func_175640_z(pos) && world.func_175625_s(pos) instanceof ProjectorTileEntity && ((ProjectorTileEntity)world.func_175625_s(pos)).isActivatedByRedstone()) {
            ((ProjectorTileEntity)world.func_175625_s(pos)).setActive(false);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b, ctx.func_221532_j().field_72449_c, ctx.func_195999_j());
    }

    public BlockState getStateForPlacement(World world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, PlayerEntity placer) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ProjectorTileEntity();
    }
}

