/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.ReinforcedHopperTileEntity;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HopperBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ReinforcedHopperBlock
extends HopperBlock
implements IReinforcedBlock {
    public ReinforcedHopperBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(-1.0f, 6.0E7f).func_200947_a(SoundType.field_185852_e).func_226896_b_());
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity te;
        if (placer instanceof PlayerEntity) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (PlayerEntity)placer));
        }
        if (stack.func_82837_s() && (te = world.func_175625_s(pos)) instanceof ReinforcedHopperTileEntity) {
            ((ReinforcedHopperTileEntity)te).func_213903_a(stack.func_200301_q());
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof ReinforcedHopperTileEntity) {
            player.func_213829_a((INamedContainerProvider)((ReinforcedHopperTileEntity)te));
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof ReinforcedHopperTileEntity) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((ReinforcedHopperTileEntity)te));
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ReinforcedHopperTileEntity) {
            ((ReinforcedHopperTileEntity)te).onEntityCollision(entity);
        }
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new ReinforcedHopperTileEntity();
    }

    @Override
    public Block getVanillaBlock() {
        return Blocks.field_150438_bZ;
    }

    @Override
    public BlockState getConvertedState(BlockState vanillaState) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_176429_b, vanillaState.func_177229_b((Property)field_176429_b))).func_206870_a((Property)field_176430_a, vanillaState.func_177229_b((Property)field_176430_a));
    }

    public static boolean canExtract(IOwnable te, World world, BlockPos hopperPos) {
        ReinforcedHopperTileEntity hopperTe = (ReinforcedHopperTileEntity)world.func_175625_s(hopperPos);
        if (!te.getOwner().owns(hopperTe)) {
            IModuleInventory inv;
            return te instanceof IModuleInventory && (inv = (IModuleInventory)((Object)te)).hasModule(ModuleType.WHITELIST) && ModuleUtils.getPlayersFromModule(inv.getModule(ModuleType.WHITELIST)).contains(hopperTe.getOwner().getName().toLowerCase());
        }
        return true;
    }
}

