/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.List;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.WhitelistOnlyTileEntity;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ReinforcedPressurePlateBlock
extends PressurePlateBlock
implements IReinforcedBlock {
    public static final AbstractBlock.Properties STONE_PROPERTIES = AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200942_a().func_200948_a(-1.0f, 6000000.0f);
    public static final AbstractBlock.Properties WOOD_PROPERTIES = AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200942_a().func_200948_a(-1.0f, 6000000.0f).func_200947_a(SoundType.field_185848_a);
    private final Block vanillaBlock;

    public ReinforcedPressurePlateBlock(PressurePlateBlock.Sensitivity sensitivity, AbstractBlock.Properties properties, Block vanillaBlock) {
        super(sensitivity, properties);
        this.vanillaBlock = vanillaBlock;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        TileEntity tileEntity;
        int redstoneStrength = this.func_176576_e(state);
        if (!world.field_72995_K && redstoneStrength == 0 && entity instanceof PlayerEntity && (tileEntity = world.func_175625_s(pos)) instanceof WhitelistOnlyTileEntity && this.isAllowedToPress(world, pos, (WhitelistOnlyTileEntity)tileEntity, (PlayerEntity)entity)) {
            this.func_180666_a(world, pos, state, redstoneStrength);
        }
    }

    protected int func_180669_e(World world, BlockPos pos) {
        TileEntity tileEntity;
        AxisAlignedBB aabb = field_185511_c.func_186670_a(pos);
        List list = world.func_72839_b(null, aabb);
        if (!list.isEmpty() && (tileEntity = world.func_175625_s(pos)) instanceof WhitelistOnlyTileEntity) {
            for (Entity entity : list) {
                if (!(entity instanceof PlayerEntity) || !this.isAllowedToPress(world, pos, (WhitelistOnlyTileEntity)tileEntity, (PlayerEntity)entity)) continue;
                return 15;
            }
        }
        return 0;
    }

    public boolean isAllowedToPress(World world, BlockPos pos, WhitelistOnlyTileEntity te, PlayerEntity entity) {
        return te.getOwner().isOwner(entity) || ModuleUtils.getPlayersFromModule(world, pos, ModuleType.WHITELIST).contains(entity.func_200200_C_().func_150261_e().toLowerCase());
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof PlayerEntity) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (PlayerEntity)placer));
        }
    }

    @Override
    public Block getVanillaBlock() {
        return this.vanillaBlock;
    }

    @Override
    public BlockState getConvertedState(BlockState vanillaState) {
        return this.func_176223_P();
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack((IItemProvider)this)});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new WhitelistOnlyTileEntity();
    }
}

