/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableTileEntity;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.api.OwnableTileEntity;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.CageTrapBlock;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.blocks.ScannerDoorBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedDoorBlock;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.tileentity.DisguisableTileEntity;
import net.geforcemods.securitycraft.tileentity.InventoryScannerTileEntity;
import net.geforcemods.securitycraft.tileentity.KeypadChestTileEntity;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.apache.logging.log4j.util.TriConsumer;

public class UniversalBlockRemoverItem
extends Item {
    public UniversalBlockRemoverItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext ctx) {
        if (ctx.func_195991_k().field_72995_K) {
            return ActionResultType.FAIL;
        }
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        TileEntity tileEntity = world.func_175625_s(pos);
        PlayerEntity player = ctx.func_195999_j();
        if (tileEntity != null && UniversalBlockRemoverItem.isOwnableBlock(block, tileEntity)) {
            if (!((IOwnable)tileEntity).getOwner().isOwner(player)) {
                if (!(block instanceof IBlockMine || tileEntity instanceof DisguisableTileEntity && !(((BlockItem)((DisguisableBlock)((DisguisableTileEntity)tileEntity).func_195044_w().func_177230_c()).getDisguisedStack((IBlockReader)world, pos).func_77973_b()).func_179223_d() instanceof DisguisableBlock))) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Item)SCContent.UNIVERSAL_BLOCK_REMOVER.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:notOwned", ((IOwnable)tileEntity).getOwner().getName()), TextFormatting.RED);
                }
                return ActionResultType.FAIL;
            }
            if (tileEntity instanceof IModuleInventory) {
                boolean isChest = tileEntity instanceof KeypadChestTileEntity;
                for (ItemStack module : ((IModuleInventory)tileEntity).getInventory()) {
                    if (isChest) {
                        ((KeypadChestTileEntity)tileEntity).addOrRemoveModuleFromAttached(module, true);
                    }
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)module);
                }
            }
            if (block == SCContent.LASER_BLOCK.get()) {
                CustomizableTileEntity te = (CustomizableTileEntity)world.func_175625_s(pos);
                for (ItemStack module : te.getInventory()) {
                    if (module.func_190926_b()) continue;
                    te.createLinkedBlockAction(LinkedAction.MODULE_REMOVED, new Object[]{module, ((ModuleItem)module.func_77973_b()).getModule()}, te);
                }
                world.func_175655_b(pos, true);
                LaserBlock.destroyAdjacentLasers((IWorld)world, pos);
                player.field_71071_by.func_70448_g().func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(ctx.func_221531_n()));
            } else if (block == SCContent.CAGE_TRAP.get() && ((Boolean)world.func_180495_p(pos).func_177229_b((Property)CageTrapBlock.DEACTIVATED)).booleanValue()) {
                BlockPos originalPos = pos;
                BlockPos middlePos = originalPos.func_177981_b(4);
                new CageTrapBlock.BlockModifier(world, new BlockPos.Mutable().func_189533_g((Vector3i)originalPos), ((IOwnable)tileEntity).getOwner()).loop((TriConsumer<World, BlockPos.Mutable, Owner>)((TriConsumer)(w, p, o) -> {
                    Block b;
                    TileEntity te = w.func_175625_s((BlockPos)p);
                    if (te instanceof IOwnable && ((IOwnable)te).getOwner().equals(o) && ((b = w.func_180495_p((BlockPos)p).func_177230_c()) == SCContent.REINFORCED_IRON_BARS.get() || p.equals((Object)middlePos) && b == SCContent.HORIZONTAL_REINFORCED_IRON_BARS.get())) {
                        w.func_175655_b((BlockPos)p, false);
                    }
                }));
                world.func_175655_b(originalPos, false);
            } else {
                InventoryScannerTileEntity te;
                if ((block instanceof ReinforcedDoorBlock || block instanceof ScannerDoorBlock) && state.func_177229_b((Property)BlockStateProperties.field_208163_P) == DoubleBlockHalf.UPPER) {
                    pos = pos.func_177977_b();
                }
                if (block == SCContent.INVENTORY_SCANNER.get() && (te = InventoryScannerBlock.getConnectedInventoryScanner(world, pos)) != null) {
                    te.getInventory().clear();
                }
                world.func_175655_b(pos, true);
                world.func_175713_t(pos);
                player.field_71071_by.func_70448_g().func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(ctx.func_221531_n()));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private static boolean isOwnableBlock(Block block, TileEntity te) {
        return te instanceof OwnableTileEntity || te instanceof IOwnable || block instanceof OwnableBlock;
    }
}

