/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.DisguisableTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class RefreshDisguisableModel {
    private BlockPos pos;
    private boolean insert;
    private ItemStack stack;

    public RefreshDisguisableModel() {
    }

    public RefreshDisguisableModel(BlockPos pos, boolean insert, ItemStack stack) {
        this.pos = pos;
        this.insert = insert;
        this.stack = stack;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeBoolean(this.insert);
        buf.func_150788_a(this.stack);
    }

    public void fromBytes(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.insert = buf.readBoolean();
        this.stack = buf.func_150791_c();
    }

    public static void encode(RefreshDisguisableModel message, PacketBuffer packet) {
        message.toBytes(packet);
    }

    public static RefreshDisguisableModel decode(PacketBuffer packet) {
        RefreshDisguisableModel message = new RefreshDisguisableModel();
        message.fromBytes(packet);
        return message;
    }

    public static void onMessage(RefreshDisguisableModel message, Supplier<NetworkEvent.Context> ctx) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RefreshDisguisableModel.lambda$null$0(message, (Supplier)ctx));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleMessage(RefreshDisguisableModel message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            DisguisableTileEntity te = (DisguisableTileEntity)Minecraft.func_71410_x().field_71441_e.func_175625_s(message.pos);
            if (te != null) {
                if (message.insert) {
                    te.insertModule(message.stack);
                } else {
                    te.removeModule(ModuleType.DISGUISE);
                }
                te.refreshModel();
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$null$0(RefreshDisguisableModel message, Supplier ctx) {
        RefreshDisguisableModel.handleMessage(message, ctx);
    }
}

