/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.tileentity.ProjectorTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.BlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncProjector {
    private int x;
    private int y;
    private int z;
    private int width;
    private int range;
    private int offset;

    public SyncProjector() {
    }

    public SyncProjector(int x, int y, int z, int width, int range, int offset) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.width = width;
        this.range = range;
        this.offset = offset;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.width);
        buf.writeInt(this.range);
        buf.writeInt(this.offset);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.width = buf.readInt();
        this.range = buf.readInt();
        this.offset = buf.readInt();
    }

    public static void encode(SyncProjector message, PacketBuffer packet) {
        message.toBytes((ByteBuf)packet);
    }

    public static SyncProjector decode(PacketBuffer packet) {
        SyncProjector message = new SyncProjector();
        message.fromBytes((ByteBuf)packet);
        return message;
    }

    public static void onMessage(SyncProjector message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockPos pos = BlockUtils.toPos(message.x, message.y, message.z);
            World world = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p;
            TileEntity te = world.func_175625_s(pos);
            if (world.func_175667_e(pos) && te instanceof ProjectorTileEntity) {
                ProjectorTileEntity projector = (ProjectorTileEntity)te;
                BlockState state = world.func_180495_p(pos);
                projector.setProjectionWidth(message.width);
                projector.setProjectionRange(message.range);
                projector.setProjectionOffset(message.offset);
                world.func_184138_a(pos, state, state, 2);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

