/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.containers.ProjectorContainer;
import net.geforcemods.securitycraft.network.server.SyncProjector;
import net.geforcemods.securitycraft.screen.components.HoverChecker;
import net.geforcemods.securitycraft.screen.components.NamedSlider;
import net.geforcemods.securitycraft.tileentity.ProjectorTileEntity;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ProjectorScreen
extends ContainerScreen<ProjectorContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/projector.png");
    private ProjectorTileEntity tileEntity;
    private TranslationTextComponent blockName;
    private HoverChecker[] hoverCheckers = new HoverChecker[3];
    private NamedSlider projectionWidth;
    private NamedSlider projectionRange;
    private NamedSlider projectionOffset;
    private int sliderWidth = 120;

    public ProjectorScreen(ProjectorContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.tileEntity = container.te;
        this.blockName = ClientUtils.localize(this.tileEntity.func_195044_w().func_177230_c().func_149739_a(), new Object[0]);
        this.field_147000_g = 225;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.projectionWidth = new NamedSlider((ITextComponent)ClientUtils.localize("gui.securitycraft:projector.width", this.tileEntity.getProjectionWidth()), (ITextComponent)this.blockName, 0, this.field_147003_i + (this.field_146999_f - this.sliderWidth) / 2, this.field_147009_r + 50, this.sliderWidth, 20, (ITextComponent)ClientUtils.localize("gui.securitycraft:projector.width", ""), "", 1, 10, this.tileEntity.getProjectionWidth(), false, true, null, this::sliderReleased);
        this.projectionWidth.setFGColor(0xE0E0E0);
        this.projectionRange = new NamedSlider((ITextComponent)ClientUtils.localize("gui.securitycraft:projector.range", this.tileEntity.getProjectionRange()), (ITextComponent)this.blockName, 1, this.field_147003_i + (this.field_146999_f - this.sliderWidth) / 2, this.field_147009_r + 80, this.sliderWidth, 20, (ITextComponent)ClientUtils.localize("gui.securitycraft:projector.range", ""), "", 1, 30, this.tileEntity.getProjectionRange(), false, true, null, this::sliderReleased);
        this.projectionRange.setFGColor(0xE0E0E0);
        this.projectionOffset = new NamedSlider((ITextComponent)ClientUtils.localize("gui.securitycraft:projector.offset", this.tileEntity.getProjectionOffset()), (ITextComponent)this.blockName, 2, this.field_147003_i + (this.field_146999_f - this.sliderWidth) / 2, this.field_147009_r + 110, this.sliderWidth, 20, (ITextComponent)ClientUtils.localize("gui.securitycraft:projector.offset", ""), "", -10, 10, this.tileEntity.getProjectionOffset(), false, true, null, this::sliderReleased);
        this.projectionOffset.setFGColor(0xE0E0E0);
        this.func_230480_a_((Widget)this.projectionWidth);
        this.func_230480_a_((Widget)this.projectionRange);
        this.func_230480_a_((Widget)this.projectionOffset);
        this.hoverCheckers[0] = new HoverChecker((Widget)this.projectionWidth);
        this.hoverCheckers[1] = new HoverChecker((Widget)this.projectionRange);
        this.hoverCheckers[2] = new HoverChecker((Widget)this.projectionOffset);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrix, mouseX, mouseY);
        if (this.hoverCheckers[0] != null && this.hoverCheckers[0].checkHover(mouseX, mouseY)) {
            this.func_238654_b_(matrix, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)ClientUtils.localize("gui.securitycraft:projector.width.description", new Object[0]), 150), mouseX, mouseY);
        }
        if (this.hoverCheckers[1] != null && this.hoverCheckers[1].checkHover(mouseX, mouseY)) {
            this.func_238654_b_(matrix, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)ClientUtils.localize("gui.securitycraft:projector.range.description", new Object[0]), 150), mouseX, mouseY);
        }
        if (this.hoverCheckers[2] != null && this.hoverCheckers[2].checkHover(mouseX, mouseY)) {
            this.func_238654_b_(matrix, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)ClientUtils.localize("gui.securitycraft:projector.offset.description", new Object[0]), 150), mouseX, mouseY);
        }
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)this.blockName, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.blockName) / 2), 6.0f, 0x404040);
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrix);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int startY = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrix, startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void sliderReleased(NamedSlider slider) {
        if (slider.id == 0) {
            this.tileEntity.setProjectionWidth(slider.getValueInt());
        } else if (slider.id == 1) {
            this.tileEntity.setProjectionRange(slider.getValueInt());
        } else if (slider.id == 2) {
            this.tileEntity.setProjectionOffset(slider.getValueInt());
        }
        SecurityCraft.channel.sendToServer((Object)new SyncProjector(this.tileEntity.func_174877_v().func_177958_n(), this.tileEntity.func_174877_v().func_177956_o(), this.tileEntity.func_174877_v().func_177952_p(), this.projectionWidth.getValueInt(), this.projectionRange.getValueInt(), this.projectionOffset.getValueInt()));
    }
}

