/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.entity.SentryEntity;
import net.geforcemods.securitycraft.network.server.SetSentryMode;
import net.geforcemods.securitycraft.network.server.UpdateNBTTagOnServer;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.screen.components.PictureButton;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SentryRemoteAccessToolScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/srat.png");
    private static final ResourceLocation SENTRY_ICONS = new ResourceLocation("securitycraft", "textures/gui/container/sentry_icons.png");
    private final TranslationTextComponent modifyAll = ClientUtils.localize("gui.securitycraft:srat.modifyAll", new Object[0]);
    private ItemStack srat;
    private ClickButton[][] guibuttons = new ClickButton[12][4];
    private ITextComponent[] names = new ITextComponent[12];
    private ClickButton[][] guibuttonsGlobal = new ClickButton[1][3];
    private static final int AGGRESSIVE = 0;
    private static final int CAMOUFLAGE = 1;
    private static final int IDLE = 2;
    private static final int UNBIND = 3;
    private int xSize = 440;
    private int ySize = 215;
    private static final int SENTRY_TRACKING_RANGE = 256;
    private int viewDistance;
    private List<TextHoverChecker> hoverCheckers = new ArrayList<TextHoverChecker>();

    public SentryRemoteAccessToolScreen(ItemStack item, int viewDistance) {
        super((ITextComponent)new TranslationTextComponent(item.func_77977_a()));
        this.srat = item;
        this.viewDistance = viewDistance;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        int startX = (this.field_230708_k_ - this.xSize) / 2;
        int startY = (this.field_230709_l_ - this.ySize) / 2;
        int paddingX = 22;
        int paddingY = 25;
        int[] coords = null;
        int id = 0;
        boolean foundSentry = false;
        this.hoverCheckers.clear();
        for (int i = 0; i < 12; ++i) {
            int x = i / 6 * this.xSize / 2;
            int y = (i % 6 + 1) * 30 + paddingY;
            coords = this.getSentryCoordinates(i);
            for (int j = 0; j < 4; ++j) {
                int btnX = startX + j * paddingX + 127 + x;
                int btnY = startY + y - 48;
                switch (j) {
                    case 0: {
                        this.guibuttons[i][j] = new PictureButton(id++, btnX, btnY, 20, 20, SENTRY_ICONS, -2, -1, 18, 18, this::actionPerformed);
                        this.guibuttons[i][j].field_230693_o_ = false;
                        break;
                    }
                    case 1: {
                        this.guibuttons[i][j] = new PictureButton(id++, btnX, btnY, 20, 20, SENTRY_ICONS, 40, -1, 18, 18, this::actionPerformed);
                        this.guibuttons[i][j].field_230693_o_ = false;
                        break;
                    }
                    case 2: {
                        this.guibuttons[i][j] = new PictureButton(id++, btnX, btnY, 20, 20, SENTRY_ICONS, 19, -1, 18, 17, this::actionPerformed);
                        this.guibuttons[i][j].field_230693_o_ = false;
                        break;
                    }
                    case 3: {
                        this.guibuttons[i][j] = new ClickButton(id++, btnX, btnY, 20, 20, "X", this::actionPerformed);
                        this.guibuttons[i][j].field_230693_o_ = false;
                    }
                }
                this.func_230480_a_((Widget)this.guibuttons[i][j]);
            }
            BlockPos sentryPos = new BlockPos(coords[0], coords[1], coords[2]);
            if (coords[0] == 0 && coords[1] == 0 && coords[2] == 0) continue;
            this.guibuttons[i][3].field_230693_o_ = true;
            if (Minecraft.func_71410_x().field_71439_g.field_70170_p.func_195588_v(sentryPos) && this.isSentryVisibleToPlayer(sentryPos)) {
                List sentries = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_217357_a(SentryEntity.class, new AxisAlignedBB(sentryPos));
                if (!sentries.isEmpty()) {
                    boolean idleMode;
                    SentryEntity sentry = (SentryEntity)((Object)sentries.get(0));
                    boolean aggressiveMode = sentry.getMode() == SentryEntity.SentryMode.AGGRESSIVE;
                    boolean camouflageMode = sentry.getMode() == SentryEntity.SentryMode.CAMOUFLAGE;
                    boolean bl = idleMode = sentry.getMode() == SentryEntity.SentryMode.IDLE;
                    if (sentry.func_145818_k_()) {
                        this.names[i] = sentry.func_200201_e();
                    }
                    this.guibuttons[i][0].field_230693_o_ = !aggressiveMode;
                    this.guibuttons[i][1].field_230693_o_ = !camouflageMode;
                    this.guibuttons[i][2].field_230693_o_ = !idleMode;
                    this.hoverCheckers.add(new TextHoverChecker((Button)this.guibuttons[i][0], (ITextComponent)ClientUtils.localize("gui.securitycraft:srat.mode1", new Object[0])));
                    this.hoverCheckers.add(new TextHoverChecker((Button)this.guibuttons[i][1], (ITextComponent)ClientUtils.localize("gui.securitycraft:srat.mode2", new Object[0])));
                    this.hoverCheckers.add(new TextHoverChecker((Button)this.guibuttons[i][2], (ITextComponent)ClientUtils.localize("gui.securitycraft:srat.mode3", new Object[0])));
                    this.hoverCheckers.add(new TextHoverChecker((Button)this.guibuttons[i][3], (ITextComponent)ClientUtils.localize("gui.securitycraft:srat.unbind", new Object[0])));
                    foundSentry = true;
                    continue;
                }
                this.removeTagFromToolAndUpdate(this.srat, coords[0], coords[1], coords[2]);
                for (int j = 0; j < 4; ++j) {
                    this.guibuttons[i][j].field_230693_o_ = false;
                }
                continue;
            }
            for (int j = 0; j < 3; ++j) {
                this.hoverCheckers.add(new TextHoverChecker((Button)this.guibuttons[i][j], (ITextComponent)ClientUtils.localize("gui.securitycraft:srat.outOfRange", new Object[0])));
            }
            this.hoverCheckers.add(new TextHoverChecker((Button)this.guibuttons[i][3], (ITextComponent)ClientUtils.localize("gui.securitycraft:srat.unbind", new Object[0])));
        }
        this.guibuttonsGlobal[0][0] = new PictureButton(1000, startX + 260, startY + 188, 20, 20, SENTRY_ICONS, -2, -1, 18, 18, this::actionPerformed);
        this.guibuttonsGlobal[0][1] = new PictureButton(1001, startX + 22 + 260, startY + 188, 20, 20, SENTRY_ICONS, 40, -1, 18, 18, this::actionPerformed);
        this.guibuttonsGlobal[0][2] = new PictureButton(1002, startX + 44 + 260, startY + 188, 20, 20, SENTRY_ICONS, 19, -1, 18, 17, this::actionPerformed);
        for (int j = 0; j < 3; ++j) {
            this.guibuttonsGlobal[0][j].field_230693_o_ = foundSentry;
            this.func_230480_a_((Widget)this.guibuttonsGlobal[0][j]);
            this.hoverCheckers.add(new TextHoverChecker((Button)this.guibuttonsGlobal[0][0], (ITextComponent)ClientUtils.localize("gui.securitycraft:srat.mode1", new Object[0])));
            this.hoverCheckers.add(new TextHoverChecker((Button)this.guibuttonsGlobal[0][1], (ITextComponent)ClientUtils.localize("gui.securitycraft:srat.mode2", new Object[0])));
            this.hoverCheckers.add(new TextHoverChecker((Button)this.guibuttonsGlobal[0][2], (ITextComponent)ClientUtils.localize("gui.securitycraft:srat.mode3", new Object[0])));
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        int startX = (this.field_230708_k_ - this.xSize) / 2;
        int startY = (this.field_230709_l_ - this.ySize) / 2;
        this.func_230446_a_(matrix);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        SentryRemoteAccessToolScreen.func_238463_a_((MatrixStack)matrix, (int)startX, (int)startY, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (int)512, (int)256);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)ClientUtils.localize(((Item)SCContent.REMOTE_ACCESS_SENTRY.get()).func_77658_a(), new Object[0]), (float)(startX + 5), (float)(startY - 25 + 13), 0xFF0000);
        for (int i = 0; i < 12; ++i) {
            int[] coords = this.getSentryCoordinates(i);
            Object line = coords[0] == 0 && coords[1] == 0 && coords[2] == 0 ? ClientUtils.localize("gui.securitycraft:srat.notBound", new Object[0]) : (this.names[i] != null ? new StringTextComponent(this.names[i].getString()) : new StringTextComponent(Utils.getFormattedCoordinates(new BlockPos(coords[0], coords[1], coords[2]))));
            this.field_230712_o_.func_243248_b(matrix, (ITextComponent)line, (float)(startX + this.xSize / 4 - this.field_230712_o_.func_238414_a_((ITextProperties)line) + 15 + i / 6 * this.xSize / 2), (float)(startY + i % 6 * 30 + 13), 0x404040);
            this.field_230712_o_.func_243248_b(matrix, (ITextComponent)this.modifyAll, (float)(startX + this.xSize / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.modifyAll) + 25), (float)(startY + 194), 0x404040);
        }
        for (TextHoverChecker chc : this.hoverCheckers) {
            if (chc == null || !chc.checkHover(mouseX, mouseY) || chc.getName() == null) continue;
            this.func_243308_b(matrix, chc.getLines(), mouseX, mouseY);
        }
    }

    protected void performSingleAction(int sentry, int mode, boolean sendMessage) {
        int[] coords = this.getSentryCoordinates(sentry);
        List sentries = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_217357_a(SentryEntity.class, new AxisAlignedBB(new BlockPos(coords[0], coords[1], coords[2])));
        if (!sentries.isEmpty()) {
            switch (mode) {
                case 0: {
                    ((SentryEntity)((Object)sentries.get(0))).toggleMode((PlayerEntity)Minecraft.func_71410_x().field_71439_g, 0, sendMessage);
                    SecurityCraft.channel.sendToServer((Object)new SetSentryMode(((SentryEntity)((Object)sentries.get(0))).func_233580_cy_(), mode, sendMessage));
                    this.guibuttons[sentry][0].field_230693_o_ = false;
                    this.guibuttons[sentry][1].field_230693_o_ = true;
                    this.guibuttons[sentry][2].field_230693_o_ = true;
                    break;
                }
                case 1: {
                    ((SentryEntity)((Object)sentries.get(0))).toggleMode((PlayerEntity)Minecraft.func_71410_x().field_71439_g, 1, sendMessage);
                    SecurityCraft.channel.sendToServer((Object)new SetSentryMode(((SentryEntity)((Object)sentries.get(0))).func_233580_cy_(), mode, sendMessage));
                    this.guibuttons[sentry][0].field_230693_o_ = true;
                    this.guibuttons[sentry][1].field_230693_o_ = false;
                    this.guibuttons[sentry][2].field_230693_o_ = true;
                    break;
                }
                case 2: {
                    ((SentryEntity)((Object)sentries.get(0))).toggleMode((PlayerEntity)Minecraft.func_71410_x().field_71439_g, 2, sendMessage);
                    SecurityCraft.channel.sendToServer((Object)new SetSentryMode(((SentryEntity)((Object)sentries.get(0))).func_233580_cy_(), mode, sendMessage));
                    this.guibuttons[sentry][0].field_230693_o_ = true;
                    this.guibuttons[sentry][1].field_230693_o_ = true;
                    this.guibuttons[sentry][2].field_230693_o_ = false;
                }
            }
        }
        if (mode == 3) {
            int i;
            this.removeTagFromToolAndUpdate(this.srat, coords[0], coords[1], coords[2]);
            for (i = 0; i < 4; ++i) {
                this.guibuttons[sentry][i].field_230693_o_ = false;
            }
            for (i = 0; i < this.guibuttons.length; ++i) {
                if (!this.guibuttons[i][3].field_230693_o_) continue;
                return;
            }
            for (i = 0; i < 3; ++i) {
                this.guibuttonsGlobal[0][i].field_230693_o_ = false;
            }
        }
    }

    protected void forceMode(ClickButton button, int mode, boolean sendMessage) {
        int sentry = button.id / 4;
        this.performSingleAction(sentry, mode, sendMessage);
    }

    protected void actionPerformed(ClickButton button) {
        int sentry = button.id / 4;
        int mode = button.id % 4;
        boolean messageSent = false;
        if (sentry > 100) {
            for (int i = 0; i < this.field_230710_m_.size() / 4; ++i) {
                Widget widget = (Widget)this.field_230710_m_.get(i * 4);
                if (!(widget instanceof ClickButton) || this.getSentryCoordinates(i)[1] == 0) continue;
                this.forceMode((ClickButton)((Object)this.field_230710_m_.get(i * 4)), mode, !messageSent);
                messageSent = true;
            }
            return;
        }
        this.performSingleAction(sentry, mode, true);
    }

    private int[] getSentryCoordinates(int sentry) {
        if (this.srat.func_77973_b() != null && this.srat.func_77973_b() == SCContent.REMOTE_ACCESS_SENTRY.get() && this.srat.func_77978_p() != null && this.srat.func_77978_p().func_74759_k("sentry" + ++sentry) != null && this.srat.func_77978_p().func_74759_k("sentry" + sentry).length > 0) {
            return this.srat.func_77978_p().func_74759_k("sentry" + sentry);
        }
        return new int[]{0, 0, 0};
    }

    private void removeTagFromToolAndUpdate(ItemStack stack, int x, int y, int z) {
        if (stack.func_77978_p() == null) {
            return;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] coords;
            if (stack.func_77978_p().func_74759_k("sentry" + i).length <= 0 || (coords = stack.func_77978_p().func_74759_k("sentry" + i))[0] != x || coords[1] != y || coords[2] != z) continue;
            stack.func_77978_p().func_74783_a("sentry" + i, new int[]{0, 0, 0});
            SecurityCraft.channel.sendToServer((Object)new UpdateNBTTagOnServer(stack));
            return;
        }
    }

    private boolean isSentryVisibleToPlayer(BlockPos sentryPos) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        double d0 = player.func_226277_ct_() - (double)sentryPos.func_177958_n();
        double d1 = player.func_226281_cx_() - (double)sentryPos.func_177952_p();
        int i = Math.min(256, this.viewDistance) - 1;
        return d0 >= (double)(-i) && d0 <= (double)i && d1 >= (double)(-i) && d1 <= (double)i;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_))) {
            this.func_231164_f_();
            return true;
        }
        return super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }
}

