/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableTileEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.AlarmBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;

public class AlarmTileEntity
extends CustomizableTileEntity {
    private IntConfigOption range = new IntConfigOption(this, "range", 17, 0, 1, true);
    private int cooldown = 0;
    private boolean isPowered = false;

    public AlarmTileEntity() {
        super(SCContent.teTypeAlarm);
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.isPowered && this.cooldown == 0) {
                AlarmTileEntity te = (AlarmTileEntity)this.field_145850_b.func_175625_s(this.field_174879_c);
                for (ServerPlayerEntity player : ((ServerWorld)this.field_145850_b).func_217490_a(p -> p.func_233580_cy_().func_177951_i((Vector3i)this.field_174879_c) <= Math.pow(((Integer)this.range.get()).intValue(), 2.0))) {
                    player.func_213823_a(SCSounds.ALARM.event, SoundCategory.BLOCKS, ((Double)ConfigHandler.CONFIG.alarmSoundVolume.get()).floatValue(), 1.0f);
                }
                te.setCooldown((Integer)ConfigHandler.CONFIG.alarmTickDelay.get() * 20);
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)AlarmBlock.FACING, this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)AlarmBlock.FACING)), 2);
                this.field_145850_b.func_175690_a(this.field_174879_c, (TileEntity)te);
            }
        }
        this.requestModelDataUpdate();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("cooldown", this.cooldown);
        tag.func_74757_a("isPowered", this.isPowered);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        if (tag.func_74764_b("cooldown")) {
            this.cooldown = tag.func_74762_e("cooldown");
        }
        if (tag.func_74764_b("isPowered")) {
            this.isPowered = tag.func_74767_n("isPowered");
        }
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public void setPowered(boolean isPowered) {
        this.isPowered = isPowered;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[0];
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.range};
    }

    private static class IntConfigOption
    extends Option.IntOption {
        public IntConfigOption(CustomizableTileEntity te, String optionName, Integer value, Integer min, Integer increment, boolean s) {
            super(te, optionName, value, min, 0, increment, s);
        }

        @Override
        public Integer getMax() {
            return (Integer)ConfigHandler.CONFIG.maxAlarmRange.get();
        }
    }
}

