/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableTileEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.MotionActivatedLightBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.IBlockReader;

public class MotionActivatedLightTileEntity
extends CustomizableTileEntity {
    private Option.DoubleOption searchRadiusOption;

    public MotionActivatedLightTileEntity() {
        super(SCContent.teTypeMotionLight);
        this.searchRadiusOption = new Option.DoubleOption("searchRadius", (Double)ConfigHandler.CONFIG.motionActivatedLightSearchRadius.get(), 5.0, 20.0, 5.0);
    }

    @Override
    public boolean attackEntity(Entity entity) {
        if (entity instanceof PlayerEntity && PlayerUtils.isPlayerMountedOnCamera((LivingEntity)((PlayerEntity)entity))) {
            MotionActivatedLightBlock.toggleLight(this.field_145850_b, this.field_174879_c, this.getOwner(), false);
        } else if (entity instanceof LivingEntity && BlockUtils.getBlock((IBlockReader)this.func_145831_w(), this.field_174879_c) == SCContent.MOTION_ACTIVATED_LIGHT.get()) {
            MotionActivatedLightBlock.toggleLight(this.field_145850_b, this.field_174879_c, this.getOwner(), !EntityUtils.isInvisible((LivingEntity)entity));
        }
        return false;
    }

    @Override
    public void attackFailed() {
        if (BlockUtils.getBlock((IBlockReader)this.func_145831_w(), this.field_174879_c) == SCContent.MOTION_ACTIVATED_LIGHT.get() && ((Boolean)BlockUtils.getBlockProperty(this.func_145831_w(), this.func_174877_v(), MotionActivatedLightBlock.LIT)).booleanValue()) {
            MotionActivatedLightBlock.toggleLight(this.field_145850_b, this.field_174879_c, this.getOwner(), false);
        }
    }

    @Override
    public boolean canAttack() {
        return true;
    }

    @Override
    public boolean shouldSyncToClient() {
        return false;
    }

    @Override
    public double getAttackRange() {
        return (Double)this.searchRadiusOption.get();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[0];
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.searchRadiusOption};
    }
}

