/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableTileEntity;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.InventoryScannerTileEntity;
import net.geforcemods.securitycraft.tileentity.KeycardReaderTileEntity;
import net.geforcemods.securitycraft.tileentity.KeypadChestTileEntity;
import net.geforcemods.securitycraft.tileentity.KeypadFurnaceTileEntity;
import net.geforcemods.securitycraft.tileentity.KeypadTileEntity;
import net.geforcemods.securitycraft.tileentity.RetinalScannerTileEntity;
import net.geforcemods.securitycraft.tileentity.SecurityCameraTileEntity;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ModuleUtils {
    public static List<String> getPlayersFromModule(World world, BlockPos pos, ModuleType module) {
        IModuleInventory te = (IModuleInventory)world.func_175625_s(pos);
        if (te.hasModule(module)) {
            return ModuleUtils.getPlayersFromModule(te.getModule(module));
        }
        return new ArrayList<String>();
    }

    public static List<String> getPlayersFromModule(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        if (stack.func_77973_b() instanceof ModuleItem) {
            for (int i = 1; i <= 50; ++i) {
                if (stack.func_77978_p() == null || stack.func_77978_p().func_74779_i("Player" + i) == null || stack.func_77978_p().func_74779_i("Player" + i).isEmpty()) continue;
                list.add(stack.func_77978_p().func_74779_i("Player" + i).toLowerCase());
            }
        }
        return list;
    }

    public static boolean checkForModule(World world, BlockPos pos, PlayerEntity player, ModuleType module) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof IModuleInventory)) {
            return false;
        }
        if (te instanceof KeypadTileEntity) {
            KeypadTileEntity keypad = (KeypadTileEntity)te;
            if (module == ModuleType.WHITELIST && keypad.hasModule(ModuleType.WHITELIST) && ModuleUtils.getPlayersFromModule(world, pos, ModuleType.WHITELIST).contains(player.func_200200_C_().getString().toLowerCase())) {
                if (keypad.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Block)SCContent.KEYPAD.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:module.whitelisted", new Object[0]), TextFormatting.GREEN);
                }
                return true;
            }
            if (module == ModuleType.BLACKLIST && keypad.hasModule(ModuleType.BLACKLIST) && ModuleUtils.getPlayersFromModule(world, pos, ModuleType.BLACKLIST).contains(player.func_200200_C_().getString().toLowerCase())) {
                if (keypad.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Block)SCContent.KEYPAD.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:module.blacklisted", new Object[0]), TextFormatting.RED);
                }
                return true;
            }
        } else if (te instanceof KeypadChestTileEntity) {
            KeypadChestTileEntity chest = (KeypadChestTileEntity)te;
            if (module == ModuleType.WHITELIST && ((IModuleInventory)te).hasModule(ModuleType.WHITELIST) && ModuleUtils.getPlayersFromModule(world, pos, ModuleType.WHITELIST).contains(player.func_200200_C_().getString().toLowerCase())) {
                if (chest.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Block)SCContent.KEYPAD_CHEST.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:module.whitelisted", new Object[0]), TextFormatting.GREEN);
                }
                return true;
            }
            if (module == ModuleType.BLACKLIST && ((IModuleInventory)te).hasModule(ModuleType.BLACKLIST) && ModuleUtils.getPlayersFromModule(world, pos, ModuleType.BLACKLIST).contains(player.func_200200_C_().getString().toLowerCase())) {
                if (chest.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Block)SCContent.KEYPAD_CHEST.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:module.blacklisted", new Object[0]), TextFormatting.RED);
                }
                return true;
            }
        } else if (te instanceof KeypadFurnaceTileEntity) {
            KeypadFurnaceTileEntity furnace = (KeypadFurnaceTileEntity)te;
            if (module == ModuleType.WHITELIST && ((IModuleInventory)te).hasModule(ModuleType.WHITELIST) && ModuleUtils.getPlayersFromModule(world, pos, ModuleType.WHITELIST).contains(player.func_200200_C_().getString().toLowerCase())) {
                if (furnace.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Block)SCContent.KEYPAD_FURNACE.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:module.whitelisted", new Object[0]), TextFormatting.GREEN);
                }
                return true;
            }
            if (module == ModuleType.BLACKLIST && ((IModuleInventory)te).hasModule(ModuleType.BLACKLIST) && ModuleUtils.getPlayersFromModule(world, pos, ModuleType.BLACKLIST).contains(player.func_200200_C_().getString().toLowerCase())) {
                if (furnace.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Block)SCContent.KEYPAD_FURNACE.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:module.blacklisted", new Object[0]), TextFormatting.RED);
                }
                return true;
            }
        } else if (te instanceof KeycardReaderTileEntity) {
            KeycardReaderTileEntity reader = (KeycardReaderTileEntity)te;
            if (module == ModuleType.WHITELIST && reader.hasModule(ModuleType.WHITELIST) && ModuleUtils.getPlayersFromModule(world, pos, ModuleType.WHITELIST).contains(player.func_200200_C_().getString().toLowerCase())) {
                if (reader.sendsMessages() && world.field_72995_K) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Block)SCContent.KEYCARD_READER.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:module.whitelisted", new Object[0]), TextFormatting.GREEN);
                }
                world.func_195593_d(pos, world.func_180495_p(pos).func_177230_c());
                return true;
            }
            if (module == ModuleType.BLACKLIST && reader.hasModule(ModuleType.BLACKLIST) && ModuleUtils.getPlayersFromModule(world, pos, ModuleType.BLACKLIST).contains(player.func_200200_C_().getString().toLowerCase())) {
                if (reader.sendsMessages() && world.field_72995_K) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Block)SCContent.KEYCARD_READER.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:module.blacklisted", new Object[0]), TextFormatting.RED);
                }
                return true;
            }
        } else if (te instanceof RetinalScannerTileEntity ? module == ModuleType.WHITELIST && ((CustomizableTileEntity)te).hasModule(ModuleType.WHITELIST) && ModuleUtils.getPlayersFromModule(world, pos, ModuleType.WHITELIST).contains(player.func_200200_C_().getString().toLowerCase()) : te instanceof InventoryScannerTileEntity && module == ModuleType.WHITELIST && ((CustomizableTileEntity)te).hasModule(ModuleType.WHITELIST) && ModuleUtils.getPlayersFromModule(world, pos, ModuleType.WHITELIST).contains(player.func_200200_C_().getString().toLowerCase())) {
            return true;
        }
        return false;
    }

    public static void createLinkedAction(LinkedAction action, ItemStack stack, CustomizableTileEntity te) {
        if (action == LinkedAction.MODULE_INSERTED) {
            te.createLinkedBlockAction(action, new Object[]{stack, (ModuleItem)stack.func_77973_b()}, te);
        } else if (action == LinkedAction.MODULE_REMOVED) {
            te.createLinkedBlockAction(action, new Object[]{stack, ((ModuleItem)stack.func_77973_b()).getModule()}, te);
        }
        if (te instanceof SecurityCameraTileEntity) {
            te.func_145831_w().func_195593_d(te.func_174877_v().func_177967_a((Direction)te.func_195044_w().func_177229_b((Property)SecurityCameraBlock.FACING), -1), te.func_195044_w().func_177230_c());
        }
    }
}

