/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.CommonCollect;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.units.UnitId;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;

public final class Biomes {
    public static final Registry<Biome> REGISTRY = WorldGenRegistries.field_243657_i;
    public static final String BIOMES_LIST_SYNTAX = "Biome is specified by its registry name (case-insensitive) or by its tag with '#' prefix.\nExamples: minecraft:forest, #snowy\nEach biome must be on a separate line without any delimiters.\nIf the whitelist is set, the blacklist will be ignored.";

    public static UnitConfig createConfigFor(ForgeMod mod, Biome biome, boolean enabled) {
        String biomeName = biome.toString();
        String fileName = UnitId.from(biomeName).toConfigName();
        UnitConfig config = UnitConfig.in(Biomes.getConfigsBaseDir(mod), fileName);
        Biomes.readBiomeName(config, biomeName);
        UnitConfig.readConfigEnabled(config, enabled);
        return config;
    }

    public static Path getConfigsBaseDir(ForgeMod mod) {
        return mod.getConfigsDir().resolve(Biomes.class.getSimpleName());
    }

    protected static String readBiomeName(UnitConfig config, String defaultName) {
        String name = UnitConfig.getStr(config, "Biome", "name", defaultName, "Biome registry name");
        return name;
    }

    public static Optional<Biome> readBiomeFrom(UnitConfig config) {
        String name = Biomes.readBiomeName(config, "");
        if (name.isEmpty()) {
            return Optional.empty();
        }
        return Biomes.findByName(name);
    }

    public static Optional<Biome> findByName(String biomeName) {
        try {
            Biome biome = (Biome)REGISTRY.func_82594_a(new ResourceLocation(biomeName));
            return Optional.ofNullable(biome);
        }
        catch (Exception e) {
            ForgeEndertech.getInstance().getLogger().error("Invalid biome name: '{}'", (Object)biomeName);
            return Optional.empty();
        }
    }

    public static Set<Biome> findByTag(String biomeTag) {
        String biomeName = biomeTag.startsWith("#") ? biomeTag.replaceFirst("#", "") : biomeTag;
        return Collections.emptySet();
    }

    public static boolean isConfigEnabled(UnitConfig config) {
        return UnitConfig.readConfigEnabled(config, false);
    }

    public static CommonCollect.BlackWhiteList<Biome> from(UnitConfig config, String category, String comment) {
        category = IHaveConfig.expandClassCategory(Biomes.class, category);
        if (config != null) {
            config.setCategoryComment(category, comment + "\n" + BIOMES_LIST_SYNTAX);
        }
        List<Biome> black = Biomes.readFrom(config, category, "blackList", "");
        List<Biome> white = Biomes.readFrom(config, category, "whiteList", "");
        return new CommonCollect.BlackWhiteList<Biome>(black, white);
    }

    public static List<Biome> readFrom(UnitConfig config, String category, String key, String comment) {
        if (config == null) {
            return Collections.emptyList();
        }
        String[] strArray = config.getStrArray(category, key, new String[0], comment);
        ArrayList<Biome> list = new ArrayList<Biome>();
        for (String str : strArray) {
            if ((str = str.trim()).isEmpty()) continue;
            if (str.startsWith("#")) {
                list.addAll(Biomes.findByTag(str));
                continue;
            }
            Biomes.findByName(str).ifPresent(biome -> list.add((Biome)biome));
        }
        return list;
    }
}

