/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.blocks.BlockStatesMap;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.GameMath;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.Biomes;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.forge.world.Wind;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.particles.IParticleData;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public final class GameWorld {
    public static boolean isWeather2Loaded = false;

    public static boolean isAirBlock(IWorldReader world, BlockPos pos) {
        return world.func_180495_p(pos).isAir((IBlockReader)world, pos);
    }

    public static boolean isWaterBlock(IWorldReader world, BlockPos pos) {
        return world.func_204610_c(pos).func_206886_c().func_207185_a((ITag)FluidTags.field_206959_a);
    }

    public static boolean isWaterSource(IWorldReader world, BlockPos pos) {
        FluidState state = world.func_204610_c(pos);
        return state.func_206889_d() && state.func_206886_c().func_207185_a((ITag)FluidTags.field_206959_a);
    }

    public static boolean isLavaBlock(IWorldReader world, BlockPos pos) {
        return world.func_204610_c(pos).func_206886_c().func_207185_a((ITag)FluidTags.field_206960_b);
    }

    public static boolean isLavaSource(IWorldReader world, BlockPos pos) {
        FluidState state = world.func_204610_c(pos);
        return state.func_206889_d() && state.func_206886_c().func_207185_a((ITag)FluidTags.field_206960_b);
    }

    public static boolean isOreBlock(IWorldReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return Tags.Blocks.ORES.func_230235_a_((Object)state.func_177230_c());
    }

    public static IWind getWindAt(World world, BlockPos pos) {
        WorldData data = GameWorld.getData((IWorld)world);
        Biome biome = world.func_226691_t_(pos);
        return data.getWind(biome);
    }

    public static void explodeBlock(World world, BlockPos pos, float explosionSize, boolean causesFire, Explosion.Mode mode, boolean dropBlock, @Nullable Entity exploder) {
        BlockState state = world.func_180495_p(pos);
        if (dropBlock) {
            TileEntity tileentity = state.hasTileEntity() ? world.func_175625_s(pos) : null;
            Block.func_220059_a((BlockState)state, (IWorld)world, (BlockPos)pos, (TileEntity)tileentity);
        }
        world.func_217398_a(exploder, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), explosionSize, causesFire, mode);
        world.func_217377_a(pos, false);
    }

    public static void scheduleBlockExplosion(World world, BlockPos pos, CommonTime.Interval delay, float size, boolean fire, Explosion.Mode mode, boolean dropAsItem, @Nullable Entity exploder) {
        WorldData data = GameWorld.getData((IWorld)world);
        ScheduledExplosion explosion = new ScheduledExplosion(world, pos, delay, size, fire, mode, dropAsItem, exploder);
        data.scheduledExplosions.put(pos, explosion);
    }

    public static boolean isServerSide(IWorldReader world) {
        return !world.func_201670_d();
    }

    public static boolean isClientSide(IWorldReader world) {
        return world.func_201670_d();
    }

    @Nullable
    public static Entity findEntity(World world, int id) {
        return world != null ? world.func_73045_a(id) : null;
    }

    public static Block getBlock(World world, BlockPos pos) {
        if (world != null && pos != null) {
            return world.func_180495_p(pos).func_177230_c();
        }
        return Blocks.field_150350_a;
    }

    public static Vect3d getBlockCenter(BlockPos pos) {
        return Vect3d.from(pos).add(GameMath.getBBCenter(ForgeBlock.FULL_BLOCK_AABB));
    }

    public static Chunk getChunk(World world, ChunkPos pos) {
        return world.func_212866_a_(pos.field_77276_a, pos.field_77275_b);
    }

    public static boolean isForgeBlock(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block instanceof ForgeBlock;
    }

    public static boolean setBlockState(IWorldWriter world, BlockPos pos, BlockState state) {
        return world.func_180501_a(pos, state, 3);
    }

    public static void spawnParticle(World world, Vect3d pos, Vect3d motion, IParticleData particleData) {
        world.func_195594_a(particleData, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
    }

    @Nullable
    public static BlockRayTraceResult rayTraceBlocks(World world, Vect3d start, Vect3d end, RayTraceContext.BlockMode blockMode, RayTraceContext.FluidMode fluidMode, Entity entity) {
        RayTraceContext context = new RayTraceContext(start.toVec3d(), end.toVec3d(), blockMode, fluidMode, entity);
        return world.func_217299_a(context);
    }

    @Nonnull
    public static WorldData getData(IWorld world) {
        WorldData data = WorldData.DATA_MAP.get(world);
        if (data == null) {
            data = new WorldData(world);
            WorldData.DATA_MAP.put(world, data);
        }
        return data;
    }

    public static class SmokeContainers<C extends ISmokeContainer> {
        public static ForgeConfigSpec.ConfigValue<Integer> maxVentPipeLength;
        public static ForgeConfigSpec.ConfigValue<Integer> ventInhaleDistance;
        protected final BlockStatesMap<C> map = new BlockStatesMap();
        protected final String name;

        public SmokeContainers(Class<C> containerClass) {
            this.name = containerClass.getSimpleName();
        }

        @Nullable
        public C find(World world, BlockPos pos) {
            BlockState state = world.func_180495_p(pos);
            return this.find(state);
        }

        @Nullable
        public C find(BlockState state) {
            ISmokeContainer container = (ISmokeContainer)this.map.get(state);
            return (C)container;
        }

        public void register(C container) {
            UnitId id = container.getRelatedId();
            this.map.put(id, container);
        }

        public static boolean isChimney(IWorldReader world, BlockPos pos) {
            Block block = world.func_180495_p(pos).func_177230_c();
            return block instanceof ISmokeContainer && ((ISmokeContainer)block).is(ISmokeContainer.Type.CHIMNEY);
        }

        public static boolean isVent(IWorldReader world, BlockPos pos) {
            Block block = world.func_180495_p(pos).func_177230_c();
            return block instanceof ISmokeContainer && ((ISmokeContainer)block).is(ISmokeContainer.Type.VENT);
        }

        public static boolean isPump(IWorldReader world, BlockPos pos) {
            Block block = world.func_180495_p(pos).func_177230_c();
            return block instanceof ISmokeContainer && ((ISmokeContainer)block).is(ISmokeContainer.Type.PUMP);
        }

        public static boolean isActive(IWorldReader world, BlockPos pos) {
            BlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            return block instanceof ISmokeContainer && ((ISmokeContainer)block).isActive((IBlockReader)world, pos);
        }

        public static boolean isActivePump(IWorldReader world, BlockPos pos) {
            return SmokeContainers.isPump(world, pos) && SmokeContainers.isActive(world, pos);
        }

        public static boolean isCoveredByChimney(IWorldReader world, BlockPos pos) {
            return SmokeContainers.isChimney(world, pos.func_177984_a());
        }

        public static BlockPos getTopmostChimney(IWorldReader world, BlockPos startPos) {
            return Positions.getLastInLine(world, startPos, SmokeContainers::isChimney, Direction.UP);
        }

        public static BlockPos getBottommostChimney(IWorldReader world, BlockPos startPos) {
            return Positions.getLastInLine(world, startPos, SmokeContainers::isChimney, Direction.DOWN);
        }

        public static List<BlockPos> getVentsAround(IWorldReader world, BlockPos centerPos) {
            ArrayList<BlockPos> vents = new ArrayList<BlockPos>();
            for (BlockPos pos : Positions.getAroundHoriz(centerPos, false, new BlockPos[0])) {
                if (!SmokeContainers.isVent(world, pos)) continue;
                vents.add(pos);
            }
            return vents;
        }
    }

    @Mod.EventBusSubscriber
    public static class WorldData {
        static final Map<IWorld, WorldData> DATA_MAP = new ConcurrentHashMap<IWorld, WorldData>();
        public int smokeParticlesCount = 0;
        protected final Map<Biome, Wind> biomeWindMap = new ConcurrentHashMap<Biome, Wind>();
        protected final Map<BlockPos, ScheduledExplosion> scheduledExplosions = new ConcurrentHashMap<BlockPos, ScheduledExplosion>();
        private final IWorld world;

        public WorldData(IWorld world) {
            this.world = world;
        }

        public IWorld getWorld() {
            return this.world;
        }

        @SubscribeEvent
        public static void onWorldLoad(WorldEvent.Load event) {
            IWorld world = event.getWorld();
            if (GameWorld.isServerSide((IWorldReader)world)) {
                WorldData data = GameWorld.getData(world);
                data.initBiomesWinds();
            }
        }

        @SubscribeEvent
        public static void onWorldUnload(WorldEvent.Unload event) {
            IWorld world = event.getWorld();
            DATA_MAP.remove(world);
        }

        @SubscribeEvent
        public static void onWorldTick(TickEvent.WorldTickEvent event) {
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            World world = event.world;
            WorldData data = GameWorld.getData((IWorld)world);
            Wind.defaultWind.update(world);
            for (Wind wind : data.biomeWindMap.values()) {
                wind.update(world);
            }
            if (GameWorld.isServerSide((IWorldReader)world)) {
                Iterator<ScheduledExplosion> iterator = data.scheduledExplosions.values().iterator();
                while (iterator.hasNext()) {
                    ScheduledExplosion explosion = iterator.next();
                    if (!explosion.timePast()) continue;
                    GameWorld.explodeBlock(world, explosion.pos, explosion.size, explosion.fire, explosion.mode, explosion.dropAsItem, explosion.exploder);
                    iterator.remove();
                    break;
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            PlayerEntity player = event.getPlayer();
            World world = player.func_130014_f_();
            if (GameWorld.isServerSide((IWorldReader)world) && player instanceof ServerPlayerEntity) {
                WorldData data = GameWorld.getData((IWorld)world);
                for (Wind wind : data.biomeWindMap.values()) {
                    Wind.WindMsg message = new Wind.WindMsg(wind);
                    ForgeEndertech.getInstance().getConnection().sendToPlayer(message, (ServerPlayerEntity)player);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            World world = event.player.func_130014_f_();
            if (GameWorld.isClientSide((IWorldReader)world)) {
                Wind.defaultWind.update(world);
                WorldData data = GameWorld.getData((IWorld)world);
                for (Wind wind : data.biomeWindMap.values()) {
                    wind.update(world);
                }
            }
        }

        protected void initBiomesWinds() {
            Iterator<Object> iterator = Biomes.REGISTRY.func_239659_c_().iterator();
            if (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Biome biome = (Biome)entry.getValue();
                UnitConfig config = Biomes.createConfigFor(ForgeEndertech.getInstance(), biome, false);
                Wind.from(config, biome);
            }
            for (Path path : UnitConfig.listCustomConfigs(Biomes.getConfigsBaseDir(ForgeEndertech.getInstance()), null)) {
                UnitConfig config = new UnitConfig(path.toFile());
                Optional<Biome> biome = Biomes.readBiomeFrom(config);
                boolean enabled = Biomes.isConfigEnabled(config);
                Wind wind = Wind.from(config, biome.orElse(null));
                if (!enabled || !biome.isPresent() || wind.equalsDefault()) continue;
                this.biomeWindMap.put(biome.get(), wind);
            }
        }

        @Nonnull
        public Wind getWind(Biome biome) {
            return this.biomeWindMap.getOrDefault(biome, Wind.defaultWind);
        }
    }

    public static class ScheduledExplosion {
        public final World world;
        public final BlockPos pos;
        public final CommonTime.Interval delay;
        public final float size;
        public final boolean fire;
        public final boolean dropAsItem;
        public final Explosion.Mode mode;
        @Nullable
        public final Entity exploder;
        protected final CommonTime.Stamp stamp = CommonTime.Stamp.now();

        public ScheduledExplosion(World world, BlockPos pos, CommonTime.Interval delay, float size, boolean fire, Explosion.Mode mode, boolean dropAsItem, Entity exploder) {
            this.world = world;
            this.pos = pos;
            this.delay = delay;
            this.size = size;
            this.fire = fire;
            this.dropAsItem = dropAsItem;
            this.exploder = exploder;
            this.mode = mode;
        }

        public boolean timePast() {
            return CommonTime.Interval.passedFrom(this.stamp).moreThan(this.delay);
        }
    }

    public static class Positions {
        public static List<BlockPos> getAroundHoriz(BlockPos centerPos, boolean includeCorners, BlockPos ... positions) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            blocks.add(centerPos.func_177976_e());
            blocks.add(centerPos.func_177974_f());
            blocks.add(centerPos.func_177978_c());
            blocks.add(centerPos.func_177968_d());
            if (includeCorners) {
                blocks.add(centerPos.func_177976_e().func_177978_c());
                blocks.add(centerPos.func_177976_e().func_177968_d());
                blocks.add(centerPos.func_177974_f().func_177978_c());
                blocks.add(centerPos.func_177974_f().func_177968_d());
            }
            for (BlockPos pos : positions) {
                blocks.add(pos);
            }
            return blocks;
        }

        public static List<ChunkPos> getAroundHoriz(ChunkPos centerPos, boolean includeCorners, ChunkPos ... positions) {
            List<BlockPos> blocks = Positions.getAroundHoriz(new BlockPos(centerPos.field_77276_a, 0, centerPos.field_77275_b), includeCorners, new BlockPos[0]);
            ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
            for (BlockPos pos : blocks) {
                chunks.add(new ChunkPos(pos.func_177958_n(), pos.func_177952_p()));
            }
            for (ChunkPos pos : positions) {
                chunks.add(pos);
            }
            return chunks;
        }

        public static List<BlockPos> getAroundHoriz(BlockPos centerPos, int radius, boolean includeCorners) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            if (radius > 0) {
                int diameter = radius * 2 + (!includeCorners ? 1 : 0);
                blocks.addAll(Positions.getLine(centerPos.func_177985_f(radius).func_177964_d(radius), Direction.EAST, diameter, !includeCorners));
                blocks.addAll(Positions.getLine(centerPos.func_177964_d(radius).func_177965_g(radius), Direction.SOUTH, diameter, !includeCorners));
                blocks.addAll(Positions.getLine(centerPos.func_177965_g(radius).func_177970_e(radius), Direction.WEST, diameter, !includeCorners));
                blocks.addAll(Positions.getLine(centerPos.func_177970_e(radius).func_177985_f(radius), Direction.NORTH, diameter, !includeCorners));
            } else {
                blocks.add(centerPos);
            }
            return blocks;
        }

        public static List<ChunkPos> getAroundHoriz(ChunkPos centerPos, int radius, boolean includeCorners) {
            ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
            List<BlockPos> blocks = Positions.getAroundHoriz(new BlockPos(centerPos.field_77276_a, 0, centerPos.field_77275_b), radius, includeCorners);
            for (BlockPos pos : blocks) {
                chunks.add(new ChunkPos(pos.func_177958_n(), pos.func_177952_p()));
            }
            return chunks;
        }

        public static List<BlockPos> getLine(BlockPos startPos, Direction direction, int length, boolean excludeEnds) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            for (int i = 0; i < length; ++i) {
                if (excludeEnds && (i == 0 || i == length - 1)) continue;
                BlockPos pos = startPos.func_177967_a(direction, i);
                blocks.add(pos);
            }
            return blocks;
        }

        public static List<BlockPos> getHorizPlane(BlockPos centerPos, int radius, boolean includeCorners) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            for (int r = radius; r >= 1; --r) {
                blocks.addAll(Positions.getAroundHoriz(centerPos, r, includeCorners));
            }
            blocks.add(centerPos);
            return blocks;
        }

        public static List<BlockPos> getAroundCube(BlockPos startPos) {
            return Positions.getAroundHoriz(startPos, false, startPos.func_177984_a(), startPos.func_177977_b());
        }

        public static List<BlockPos> getAroundCube(World world, BlockPos centerPos, BiPredicate<World, BlockPos> validPos) {
            ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
            for (BlockPos pos : Positions.getAroundCube(centerPos)) {
                if (!validPos.test(world, pos)) continue;
                validPositions.add(pos);
            }
            return validPositions;
        }

        public static List<BlockPos> getAroundCube(BlockPos centerPos, int radius, boolean includeEdges) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            for (int offset = -radius; offset <= radius; ++offset) {
                BlockPos pos = centerPos.func_177967_a(Direction.UP, offset);
                if (Math.abs(offset) == Math.abs(radius)) {
                    blocks.addAll(Positions.getHorizPlane(pos, radius, includeEdges));
                    continue;
                }
                blocks.addAll(Positions.getAroundHoriz(pos, radius, includeEdges));
            }
            return blocks;
        }

        public static double getDistance(BlockPos posA, BlockPos posB) {
            return Vect3d.distance(Vect3d.from(posA), Vect3d.from(posB));
        }

        public static BlockPos getLastInLine(IWorldReader world, BlockPos startPos, BiPredicate<IWorldReader, BlockPos> validation, Direction direction) {
            int offset = 1;
            while (validation.test(world, startPos.func_177967_a(direction, offset))) {
                ++offset;
            }
            return startPos.func_177967_a(direction, offset - 1);
        }

        public static BlockPos withY(BlockPos pos, int y) {
            return new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
        }

        public static BlockPos withY(BlockPos pos, double y) {
            return new BlockPos((double)pos.func_177958_n(), y, (double)pos.func_177952_p());
        }
    }

    public static class Directions {
        public static final Direction[] CLOCKWISE_HORIZONTALS = new Direction[]{Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.NORTH};
        private static final List<Direction> SHUFFLED_HORIZONTALS = Lists.newArrayList((Object[])CLOCKWISE_HORIZONTALS);
        private static final List<Direction> SHUFFLED_ALL = Lists.newArrayList((Object[])Direction.values());

        public static List<Direction> getShuffledAll() {
            Collections.shuffle(SHUFFLED_ALL);
            return Collections.unmodifiableList(SHUFFLED_ALL);
        }

        public static List<Direction> getShuffledHorizontals() {
            Collections.shuffle(SHUFFLED_HORIZONTALS);
            return Collections.unmodifiableList(SHUFFLED_HORIZONTALS);
        }
    }
}

