/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.init;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.units.EmittersInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import com.endertech.minecraft.mods.adchimneys.smoke.ISmokeEmitter;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;

public class Emitters
extends EmittersInit<Emitter, BuiltInEmitters> {
    public Emitters(ForgeMod mod) {
        super(mod, BuiltInEmitters.class);
    }

    public Emitter createCustomUnitFrom(UnitConfig config, String name) {
        UnitId id = UnitId.from((Path)config.getConfigFile().toPath());
        return new Emitter(config, (Emitter.Properties<?>)((Object)Emitter.Properties.withId(id.toString()).smoke(4, 1.0f)));
    }

    public Emitter createDefaultUnitFrom(UnitConfig config, BuiltInEmitters e) {
        return new Emitter(config, e.props);
    }

    @Nullable
    public Emitter findBy(IWorldReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof ISmokeEmitter) {
            return ((ISmokeEmitter)block).getEmitter(world, pos);
        }
        return (Emitter)super.findBy(world, pos);
    }

    static enum BuiltInEmitters implements IForgeEnum
    {
        brickfurnace$brick_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[lit=true]").smoke(2, 1.0f))).color(295063357))),
        brickfurnace$brick_blast_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[lit=true]").smoke(2, 1.5f))).color(290795557))),
        brickfurnace$brick_smoker((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[lit=true]").smoke(2, 0.5f))).color(295195714))),
        immersiveengineering$alloy_smelter((Emitter.Properties)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[active=true, multiblockslave=false]").smoke(3, 1.2f))).color(293159744).relatedBlocks(new String[]{"immersiveengineering:alloy_smelter:[multiblockslave=true]"})),
        immersiveengineering$coke_oven((Emitter.Properties)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[active=true, multiblockslave=false]").smoke(3, 1.5f))).color(0x11333333).relatedBlocks(new String[]{"immersiveengineering:coke_oven:[multiblockslave=true]"})),
        immersiveengineering$blast_furnace((Emitter.Properties)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[active=true, multiblockslave=false]").smoke(3, 1.5f))).color(291450657).relatedBlocks(new String[]{"immersiveengineering:blast_furnace:[multiblockslave=true]"})),
        immersiveengineering$advanced_blast_furnace((Emitter.Properties)((Emitter.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[active=true, multiblockslave=false]").smoke(3, 1.5f))).color(291450657))).notEmitAside().relatedBlocks(new String[]{"immersiveengineering:advanced_blast_furnace:[multiblockslave=true]"})),
        ironfurnaces$iron_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[lit=true]").smoke(2, 1.0f))).color(0x11727272))),
        ironfurnaces$silver_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[lit=true]").smoke(2, 1.5f))).color(0x11818D8D))),
        ironfurnaces$copper_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[lit=true]").smoke(2, 1.5f))).color(300061756))),
        ironfurnaces$gold_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[lit=true]").smoke(2, 1.5f))).color(301382435))),
        ironfurnaces$diamond_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[lit=true]").smoke(3, 2.0f))).color(289201634))),
        ironfurnaces$emerald_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[lit=true]").smoke(3, 2.0f))).color(287359535))),
        ironfurnaces$crystal_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[lit=true]").smoke(3, 2.5f))).color(287553270))),
        ironfurnaces$obsidian_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[lit=true]").smoke(3, 2.0f))).color(287512370))),
        mekanism$fuelwood_heater((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[active=true]").smoke(2, 1.5f))).color(293232211))),
        minecraft$campfire((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[lit=true]").smoke(1, 0.1f))).color(587163136))).maxGapLength(2))),
        minecraft$soul_campfire((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[lit=true]").smoke(1, 0.1f))).color(578614005))).maxGapLength(2))),
        minecraft$furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[lit=true]").smoke(2, 1.0f))).color(0x11808080))),
        minecraft$blast_furnace((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[lit=true]").smoke(2, 1.5f))).color(289291585))),
        minecraft$smoker((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[lit=true]").smoke(2, 0.5f))).color(291851819))),
        silents_mechanisms$coal_generator((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[lit=true]").smoke(3, 1.5f))).color(0x11707070))),
        silents_mechanisms$lava_generator((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[lit=true]").smoke(2, 0.5f))).color(585140798))),
        silents_mechanisms$diesel_generator((Emitter.Properties<?>)((Object)((Emitter.Properties)((Object)Emitter.Properties.withEnumId("[lit=true]").smoke(2, 1.5f))).color(299558467)));

        final Emitter.Properties<?> props;

        private BuiltInEmitters(Emitter.Properties<?> props) {
            this.props = (Emitter.Properties)props.ifEmptySetIdFrom(this);
        }
    }
}

