/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp;

import com.yogpc.qp.NonNullList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ReflectionHelper {
    public static List<Method> getMethods(Class<?> t, Class<? extends Annotation> a) {
        ArrayList<Method> ms = new ArrayList<Method>();
        for (Class<?> c = t; c != null && c != Object.class; c = c.getSuperclass()) {
            for (Method m : c.getDeclaredMethods()) {
                if (!m.isAnnotationPresent(a)) continue;
                m.setAccessible(true);
                ms.add(m);
            }
        }
        return ms;
    }

    public static Method getMethod(Class<?> t, String[] sv, Class<?>[] ... av) {
        ArrayList<Exception> ec = new ArrayList<Exception>();
        for (Class<?> c = t; c != null && c != Object.class; c = c.getSuperclass()) {
            for (String element : sv) {
                for (Class<?>[] element2 : av) {
                    try {
                        Method tmp = c.getDeclaredMethod(element, element2);
                        tmp.setAccessible(true);
                        return tmp;
                    }
                    catch (Exception e) {
                        ec.add(e);
                    }
                }
            }
        }
        for (Exception e : ec) {
            e.printStackTrace();
        }
        return null;
    }

    public static Field getField(Class<?> t, String ... sv) {
        ArrayList<Exception> ec = new ArrayList<Exception>();
        for (Class<?> c = t; c != null && c != Object.class; c = c.getSuperclass()) {
            for (String s : sv) {
                try {
                    Field tmp = c.getDeclaredField(s);
                    tmp.setAccessible(true);
                    return tmp;
                }
                catch (Exception e) {
                    ec.add(e);
                }
            }
        }
        for (Exception e : ec) {
            e.printStackTrace();
        }
        return null;
    }

    public static Class<?> getClass(String ... sv) {
        ArrayList<Exception> ec = new ArrayList<Exception>();
        for (String s : sv) {
            try {
                return Class.forName(s, false, ReflectionHelper.class.getClassLoader());
            }
            catch (Exception e) {
                ec.add(e);
            }
        }
        for (Exception e : ec) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object invoke(Method m, Object obj, Object ... args) {
        try {
            return m.invoke(obj, args);
        }
        catch (Error | Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void checkGetDrops(World world, BlockPos pos, IBlockState state, Block block, int fortuneLevel, NonNullList<ItemStack> list) {
    }
}

