/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.block;

import com.yogpc.qp.block.ADismCBlock;
import com.yogpc.qp.item.ItemBlockEnchantable;
import com.yogpc.qp.tile.IEnchantableTile;
import com.yogpc.qp.tile.TileLaser;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLaser
extends ADismCBlock {
    private static final AxisAlignedBB NORTH_BASE = new AxisAlignedBB(0.0, 0.0, 0.75, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB NORTH_LANCHER = new AxisAlignedBB(0.3125, 0.3125, 0.1875, 0.6875, 0.6875, 0.75);
    private static final AxisAlignedBB SOUTH_BASE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.25);
    private static final AxisAlignedBB SOUTH_LANCHER = new AxisAlignedBB(0.3125, 0.3125, 0.25, 0.6875, 0.6875, 0.8125);
    private static final AxisAlignedBB EAST_BASE = new AxisAlignedBB(0.0, 0.0, 0.0, 0.25, 1.0, 1.0);
    private static final AxisAlignedBB EAST_LANCHER = new AxisAlignedBB(0.25, 0.3125, 0.3125, 0.8125, 0.6875, 0.6875);
    private static final AxisAlignedBB WEST_BASE = new AxisAlignedBB(0.75, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB WEST_LANCHER = new AxisAlignedBB(0.1875, 0.3125, 0.3125, 0.75, 0.6875, 0.6875);
    private static final AxisAlignedBB UP_BASE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    private static final AxisAlignedBB UP_LANCHER = new AxisAlignedBB(0.3125, 0.25, 0.3125, 0.6875, 0.8125, 0.6875);
    private static final AxisAlignedBB DOWN_BASE = new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB DOWN_LANCHER = new AxisAlignedBB(0.3125, 0.1875, 0.3125, 0.6875, 0.75, 0.6875);
    private final ArrayList<ItemStack> drop = new ArrayList();

    public BlockLaser() {
        super(Material.field_151573_f, "laserplus", ItemBlockEnchantable::new);
        this.func_149711_c(10.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
        EnumFacing value = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (value) {
            case DOWN: {
                BlockLaser.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)DOWN_BASE);
                BlockLaser.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)DOWN_LANCHER);
                break;
            }
            case UP: {
                BlockLaser.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)UP_BASE);
                BlockLaser.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)UP_LANCHER);
                break;
            }
            case NORTH: {
                BlockLaser.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_BASE);
                BlockLaser.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_LANCHER);
                break;
            }
            case SOUTH: {
                BlockLaser.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_BASE);
                BlockLaser.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_LANCHER);
                break;
            }
            case WEST: {
                BlockLaser.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_BASE);
                BlockLaser.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_LANCHER);
                break;
            }
            case EAST: {
                BlockLaser.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_BASE);
                BlockLaser.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_LANCHER);
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case DOWN: {
                return DOWN_BASE.func_111270_a(DOWN_LANCHER);
            }
            case UP: {
                return UP_BASE.func_111270_a(UP_LANCHER);
            }
            case NORTH: {
                return NORTH_BASE.func_111270_a(NORTH_LANCHER);
            }
            case SOUTH: {
                return SOUTH_BASE.func_111270_a(SOUTH_LANCHER);
            }
            case WEST: {
                return WEST_BASE.func_111270_a(WEST_LANCHER);
            }
            case EAST: {
                return EAST_BASE.func_111270_a(EAST_LANCHER);
            }
        }
        return super.func_185496_a(state, source, pos);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return facing.func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public TileLaser createNewTileEntity(World w, int m) {
        return new TileLaser();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        Optional<TileLaser> tileEntity = Optional.ofNullable((TileLaser)worldIn.func_175625_s(pos));
        this.drop.clear();
        tileEntity.ifPresent(tile -> {
            int count = this.quantityDropped(state, 0, worldIn.field_73012_v);
            Item it = this.func_180660_a(state, worldIn.field_73012_v, 0);
            for (int i = 0; i < count; ++i) {
                ItemStack is = new ItemStack(it, 1, this.func_180651_a(state));
                IEnchantableTile.Util.enchantmentToIS(tile, is);
                this.drop.add(is);
            }
        });
        super.func_180663_b(worldIn, pos, state);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return this.drop;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        Optional.ofNullable((IEnchantableTile)worldIn.func_175625_s(pos)).ifPresent(t -> IEnchantableTile.Util.init(t, stack.func_77986_q()));
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
    }

    @Override
    protected boolean canRotate() {
        return false;
    }
}

