/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.block;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.block.ADismCBlock;
import com.yogpc.qp.compat.BuildcraftHelper;
import com.yogpc.qp.item.ItemBlockPump;
import com.yogpc.qp.item.ItemTool;
import com.yogpc.qp.tile.IEnchantableTile;
import com.yogpc.qp.tile.TilePump;
import com.yogpc.qp.version.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPump
extends ADismCBlock {
    public static final PropertyBool CONNECTED = PropertyBool.func_177716_a((String)"connected");
    private final ArrayList<ItemStack> drop = new ArrayList();

    public BlockPump() {
        super(Material.field_151573_f, "pumpplus", ItemBlockPump::new);
        this.func_149711_c(5.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)ACTING, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTING, CONNECTED});
    }

    public TilePump createNewTileEntity(World w, int m) {
        return new TilePump();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        this.drop.clear();
        Optional.ofNullable((TilePump)worldIn.func_175625_s(pos)).ifPresent(tile -> {
            int count = this.quantityDropped(state, 0, worldIn.field_73012_v);
            Item it = this.func_180660_a(state, worldIn.field_73012_v, 0);
            for (int i = 0; i < count; ++i) {
                ItemStack is = new ItemStack(it, 1, this.func_180651_a(state));
                IEnchantableTile.Util.enchantmentToIS(tile, is);
                this.drop.add(is);
            }
        });
        super.func_180663_b(worldIn, pos, state);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return this.drop;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity entity = worldIn.func_175625_s(pos);
        if (entity != null) {
            IEnchantableTile.Util.init((IEnchantableTile)entity, stack.func_77986_q());
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        super.func_189540_a(state, worldIn, pos, blockIn);
        Optional.ofNullable((TilePump)worldIn.func_175625_s(pos)).ifPresent(TilePump::G_reinit);
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (BuildcraftHelper.isWrench(playerIn, hand, stack, new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), facing, pos))) {
            Optional.ofNullable((TilePump)worldIn.func_175625_s(pos)).ifPresent(pump2 -> pump2.S_changeRange(playerIn));
            return true;
        }
        if (stack != null && stack.func_77973_b() == QuarryPlusI.itemTool()) {
            TilePump pump3;
            if (!worldIn.field_72995_K && stack.func_77952_i() == ItemTool.meta_statuschecker()) {
                TilePump pump4 = (TilePump)worldIn.func_175625_s(pos);
                if (pump4 != null) {
                    pump4.sendEnchantMassage(playerIn);
                    pump4.C_getNames().forEach(c -> VersionUtil.sendMessage(playerIn, c));
                }
            } else if (stack.func_77952_i() == ItemTool.meta_liquidselector() && (pump3 = (TilePump)worldIn.func_175625_s(pos)) != null) {
                QuarryPlus.proxy.openPumpGui(worldIn, playerIn, facing, pump3);
            }
            return true;
        }
        return super.onBlockActivated(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public int func_176201_c(IBlockState state) {
        boolean work = (Boolean)state.func_177229_b((IProperty)ACTING);
        boolean connected = (Boolean)state.func_177229_b((IProperty)CONNECTED);
        return (work ? 1 : 0) | (connected ? 2 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ACTING, (Comparable)Boolean.valueOf((meta & 1) == 1)).func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf((meta & 2) == 2));
    }

    @Override
    protected boolean canRotate() {
        return false;
    }
}

