/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.compat;

import com.yogpc.qp.compat.IInjector;
import com.yogpc.qp.version.VersionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import scala.Option;

public class InvUtils {
    private static final List<IInjector> INJECTORS;
    @GameRegistry.ObjectHolder(value="ic2:meter")
    public static final Item ic2_meter;
    @GameRegistry.ObjectHolder(value="ic2:wrench")
    public static final Item ic2_wrench;
    @GameRegistry.ObjectHolder(value="ic2:electric_wrench")
    public static final Item ic2_electric_wrench;
    @GameRegistry.ObjectHolder(value="quarryplus:quarrydebug")
    public static final Item quarrydebug;
    @GameRegistry.ObjectHolder(value="cofhcore:smelting")
    public static final Enchantment cofh_smelting;
    @GameRegistry.ObjectHolder(value="endercore:autosmelt")
    public static final Enchantment endercore_smelting;

    public static ItemStack injectToNearTile(World w, BlockPos pos, ItemStack is) {
        List injectors = Stream.of(EnumFacing.field_82609_l).flatMap(enumFacing -> {
            TileEntity t = w.func_175625_s(pos.func_177972_a(enumFacing));
            return INJECTORS.stream().filter(i -> t != null).flatMap(i -> i.getInjector(is, t, (EnumFacing)enumFacing));
        }).collect(Collectors.toList());
        ItemStack inserted = is.func_77946_l();
        for (IInjector injector : injectors) {
            inserted = injector.inject(inserted, w, pos);
            if (!VersionUtil.isEmpty(inserted)) continue;
            return VersionUtil.empty();
        }
        return inserted;
    }

    public static Option<IItemHandler> findItemHander(World world, BlockPos pos, EnumFacing from) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity == null) {
            return Option.empty();
        }
        return Option.apply((Object)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, from));
    }

    public static boolean isDebugItem(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (VersionUtil.nonEmpty(stack)) {
            Item item = stack.func_77973_b();
            return item == quarrydebug || item == ic2_meter || item == ic2_wrench || item == ic2_electric_wrench;
        }
        return false;
    }

    public static IBlockState getStateFromItem(ItemBlock itemBlock, int meta) {
        Block block = itemBlock.func_179223_d();
        return block.func_176203_a(meta);
    }

    public static boolean hasSmelting(ItemStack stack) {
        return cofh_smelting != DummyEnchantment.DUMMY_ENCHANTMENT && EnchantmentHelper.func_77506_a((Enchantment)cofh_smelting, (ItemStack)stack) > 0 || endercore_smelting != DummyEnchantment.DUMMY_ENCHANTMENT && EnchantmentHelper.func_77506_a((Enchantment)endercore_smelting, (ItemStack)stack) > 0;
    }

    static {
        ArrayList<IInjector> injectors = new ArrayList<IInjector>();
        if (ModAPIManager.INSTANCE.hasAPI("BuildCraftAPI|transport")) {
            try {
                injectors.add((IInjector)Class.forName("com.yogpc.qp.compat.BCInjector").getMethod("init", new Class[0]).invoke(null, new Object[0]));
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        }
        if (Loader.isModLoaded((String)"mekanism")) {
            try {
                injectors.add((IInjector)Class.forName("com.yogpc.qp.compat.MekanismInjector").getMethod("init", new Class[0]).invoke(null, new Object[0]));
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        }
        injectors.add(new ForgeInjector(EmptyHandler.INSTANCE));
        INJECTORS = Collections.unmodifiableList(injectors);
        ic2_meter = new Item();
        ic2_wrench = new Item();
        ic2_electric_wrench = new Item();
        quarrydebug = new Item();
        cofh_smelting = DummyEnchantment.DUMMY_ENCHANTMENT;
        endercore_smelting = DummyEnchantment.DUMMY_ENCHANTMENT;
    }

    private static final class DummyEnchantment
    extends Enchantment {
        private static final DummyEnchantment DUMMY_ENCHANTMENT = new DummyEnchantment();

        protected DummyEnchantment() {
            super(Enchantment.Rarity.COMMON, EnumEnchantmentType.ALL, new EntityEquipmentSlot[0]);
        }
    }

    private static class ForgeInjector
    implements IInjector {
        private final IItemHandler handler;

        private ForgeInjector(IItemHandler handler) {
            this.handler = handler;
        }

        @Override
        public Stream<? extends IInjector> getInjector(ItemStack stack, TileEntity entity, EnumFacing facing) {
            IItemHandler handler = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            if (VersionUtil.getCount(stack) != VersionUtil.getCount(ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)true))) {
                return Stream.of(new ForgeInjector(handler));
            }
            return Stream.empty();
        }

        @Override
        public ItemStack inject(ItemStack stack, World world, BlockPos fromPos) {
            return ItemHandlerHelper.insertItem((IItemHandler)this.handler, (ItemStack)stack, (boolean)false);
        }
    }
}

