/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.compat;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTBuilder {
    public static <K, V> NBTTagList fromMap(Map<? extends K, ? extends V> map, String keyName, String valueName, Function<? super K, ? extends NBTBase> keyFunction, Function<? super V, ? extends NBTBase> valueFunction) {
        NBTTagList list = new NBTTagList();
        map.forEach((key, value) -> {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a(keyName, (NBTBase)keyFunction.apply((Object)key));
            compound.func_74782_a(valueName, (NBTBase)valueFunction.apply((Object)value));
            list.func_74742_a((NBTBase)compound);
        });
        return list;
    }

    public static <K, V> Map<K, V> fromList(NBTTagList list, Function<? super NBTTagCompound, ? extends K> keyFunction, Function<? super NBTTagCompound, ? extends V> valueFunction, Predicate<? super K> keyFilter, Predicate<? super V> valuePredicate) {
        HashMap<K, V> map = new HashMap<K, V>(list.func_74745_c());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound at = list.func_150305_b(i);
            K key = keyFunction.apply((NBTTagCompound)at);
            V value = valueFunction.apply((NBTTagCompound)at);
            if (!keyFilter.test(key) || !valuePredicate.test(value)) continue;
            map.put(key, value);
        }
        return map;
    }
}

