/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.container;

import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.container.LoopList;
import com.yogpc.qp.container.SlotMover;
import com.yogpc.qp.item.IEnchantableItem;
import com.yogpc.qp.version.VersionUtil;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class ContainerMover
extends Container {
    public final IInventory craftMatrix = new InventoryBasic("Matrix", false, 2){

        public void func_70296_d() {
            super.func_70296_d();
            ContainerMover.this.func_75142_b();
        }
    };
    private final World worldObj;
    private final BlockPos pos;
    private final LoopList<Tuple> list = new LoopList();
    private int avail = 0;

    public ContainerMover(IInventory player, World w, int x, int y, int z) {
        int col;
        this.worldObj = w;
        this.pos = new BlockPos(x, y, z);
        for (col = 0; col < 2; ++col) {
            this.func_75146_a(new SlotMover(this.craftMatrix, col, 8 + col * 144, 35));
        }
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot(player, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot(player, col, 8 + col * 18, 142));
        }
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!this.worldObj.field_72995_K) {
            for (int var2 = 0; var2 < 2; ++var2) {
                ItemStack var3 = this.craftMatrix.func_70304_b(var2);
                if (!VersionUtil.nonEmpty(var3)) continue;
                playerIn.func_71019_a(var3, false);
            }
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.worldObj.func_180495_p(this.pos).func_177230_c() == QuarryPlusI.blockMover() && playerIn.func_174831_c(this.pos) <= 64.0;
    }

    public void func_75142_b() {
        super.func_75142_b();
        ItemStack pickaxe = this.craftMatrix.func_70301_a(0);
        Map enchantments = pickaxe == null ? Collections.emptyMap() : EnchantmentHelper.func_82781_a((ItemStack)pickaxe);
        ItemStack enchTile = this.craftMatrix.func_70301_a(1);
        if (enchantments.isEmpty() || VersionUtil.isEmpty(enchTile)) {
            this.avail = 0;
            this.list.setList(Collections.emptyList());
        } else {
            int previousSize = this.list.size();
            if (VersionUtil.nonEmpty(enchTile) && enchTile.func_77973_b() instanceof IEnchantableItem) {
                IEnchantableItem item = (IEnchantableItem)enchTile.func_77973_b();
                this.list.setList(enchantments.entrySet().stream().map(Tuple::new).filter(tuple -> item.canMove(enchTile, tuple.enchantment) && EnchantmentHelper.func_77506_a((Enchantment)tuple.enchantment, (ItemStack)enchTile) < tuple.enchantment.func_77325_b()).collect(Collectors.toCollection(LinkedList::new)));
            } else {
                this.list.setList(enchantments.entrySet().stream().map(Tuple::new).collect(Collectors.toCollection(LinkedList::new)));
            }
            if (this.avail % (previousSize == 0 ? 1 : previousSize) > this.list.size()) {
                this.avail = 0;
            }
        }
        for (IContainerListener listener : this.field_75149_d) {
            VersionUtil.sendWindowProperty(listener, this, 0, this.avail);
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        VersionUtil.sendWindowProperty(listener, this, 0, this.avail);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int i, int data) {
        this.avail = data;
    }

    public void setAvail(D d) {
        this.avail += d.offset;
        if (!this.worldObj.field_72995_K) {
            for (IContainerListener listener : this.field_75149_d) {
                VersionUtil.sendWindowProperty(listener, this, 0, this.avail);
            }
        }
    }

    public Optional<Enchantment> getEnchantment() {
        return this.list.getOptional(this.avail).map(tuple -> tuple.enchantment);
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack src = VersionUtil.empty();
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack remain = slot.func_75211_c();
            src = remain.func_77946_l();
            if (index < 2) {
                if (!this.func_75135_a(remain, 2, 38, true)) {
                    return VersionUtil.empty();
                }
            } else {
                ItemStack put = ItemHandlerHelper.copyStackWithSize((ItemStack)remain, (int)1);
                boolean changed = false;
                Slot toslot = (Slot)this.field_75151_b.get(0);
                if (toslot.func_75214_a(remain) && VersionUtil.isEmpty(toslot.func_75211_c())) {
                    toslot.func_75215_d(put);
                    VersionUtil.shrink(remain, 1);
                    changed = true;
                }
                toslot = (Slot)this.field_75151_b.get(1);
                if (!changed && toslot.func_75214_a(remain) && VersionUtil.isEmpty(toslot.func_75211_c())) {
                    toslot.func_75215_d(put);
                    VersionUtil.shrink(remain, 1);
                    changed = true;
                }
                if (!changed) {
                    return VersionUtil.empty();
                }
            }
            if (VersionUtil.isEmpty(remain)) {
                slot.func_75215_d(VersionUtil.empty());
            } else {
                slot.func_75218_e();
            }
            if (VersionUtil.getCount(remain) == VersionUtil.getCount(src)) {
                return VersionUtil.empty();
            }
            VersionUtil.onTake(slot, playerIn, remain);
        }
        return src;
    }

    public void moveEnchant() {
        Tuple tuple = this.list.get(this.avail);
        ItemStack tileItem = this.craftMatrix.func_70301_a(1);
        if (tuple == null || VersionUtil.isEmpty(tileItem) || !((IEnchantableItem)tileItem.func_77973_b()).canMove(tileItem, tuple.enchantment)) {
            return;
        }
        NBTTagList list = tileItem.func_77986_q();
        if (EnchantmentHelper.func_77506_a((Enchantment)tuple.enchantment, (ItemStack)tileItem) == 0) {
            tileItem.func_77966_a(tuple.enchantment, 1);
            if (tuple.level == 1) {
                this.list.remove(this.avail);
            } else {
                this.list.set(this.avail, tuple.leveldown());
            }
            ContainerMover.downLevel(tuple.enchantment, this.craftMatrix.func_70301_a(0));
        } else {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbt = list.func_150305_b(i);
                if (Enchantment.func_185262_c((int)nbt.func_74765_d("id")) != tuple.enchantment) continue;
                short l = nbt.func_74765_d("lvl");
                if (l < tuple.enchantment.func_77325_b()) {
                    nbt.func_74777_a("lvl", (short)(l + 1));
                    if (tuple.level == 1) {
                        this.list.remove(this.avail);
                    } else {
                        this.list.set(this.avail, tuple.leveldown());
                    }
                    ContainerMover.downLevel(tuple.enchantment, this.craftMatrix.func_70301_a(0));
                }
                return;
            }
        }
    }

    private static void downLevel(Enchantment enchantment, ItemStack stack) {
        NBTTagCompound compound;
        NBTTagList list = stack.func_77986_q();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            if (Enchantment.func_185262_c((int)nbt.func_74765_d("id")) != enchantment) continue;
            short l = nbt.func_74765_d("lvl");
            if (l == 1) {
                list.func_74744_a(i);
                break;
            }
            nbt.func_74777_a("lvl", (short)(l - 1));
            break;
        }
        if (list.func_82582_d() && (compound = stack.func_77978_p()) != null) {
            compound.func_82580_o("ench");
            if (compound.func_82582_d()) {
                stack.func_77982_d(null);
            }
        }
    }

    private static class Tuple {
        final Enchantment enchantment;
        final int level;

        public Tuple(Enchantment enchantment, int level) {
            this.enchantment = enchantment;
            this.level = level;
        }

        public Tuple(Map.Entry<Enchantment, Integer> entry) {
            this(entry.getKey(), entry.getValue());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Tuple) {
                Tuple tuple = (Tuple)obj;
                return tuple.enchantment == this.enchantment && tuple.level == this.level;
            }
            return false;
        }

        public int hashCode() {
            return this.enchantment.hashCode() ^ this.level;
        }

        public Tuple leveldown() {
            return this.cloneWithLevel(this.level - 1);
        }

        public Tuple cloneWithLevel(int newLevel) {
            return new Tuple(this.enchantment, newLevel);
        }
    }

    public static enum D {
        UP(-1),
        DOUN(1);

        public final int offset;

        private D(int offset) {
            this.offset = offset;
        }
    }
}

