/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.enchantment;

import com.yogpc.qp.BlockData;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.container.ContainerEnchList;
import com.yogpc.qp.packet.IMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DiffMessage
implements IMessage {
    int containerId;
    List<BlockData> fortuneList;
    List<BlockData> silkList;

    public static DiffMessage create(Container container, List<BlockData> fortuneList, List<BlockData> silkList) {
        DiffMessage message = new DiffMessage();
        message.containerId = container.field_75152_c;
        message.fortuneList = fortuneList;
        message.silkList = silkList;
        return message;
    }

    @Override
    public void fromBytes(PacketBuffer buffer) throws IOException {
        int i;
        this.containerId = buffer.readInt();
        int fS = buffer.readInt();
        int sS = buffer.readInt();
        this.fortuneList = new ArrayList<BlockData>(fS);
        this.silkList = new ArrayList<BlockData>(sS);
        for (i = 0; i < fS; ++i) {
            this.fortuneList.add(BlockData.readFromNBT(buffer.func_150793_b()));
        }
        for (i = 0; i < sS; ++i) {
            this.silkList.add(BlockData.readFromNBT(buffer.func_150793_b()));
        }
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.writeInt(this.containerId);
        buffer.writeInt(this.fortuneList.size()).writeInt(this.silkList.size());
        this.fortuneList.stream().map(data -> data.writeToNBT(new NBTTagCompound())).forEach(arg_0 -> ((PacketBuffer)buffer).func_150786_a(arg_0));
        this.silkList.stream().map(data -> data.writeToNBT(new NBTTagCompound())).forEach(arg_0 -> ((PacketBuffer)buffer).func_150786_a(arg_0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IMessage onRecieve(IMessage message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            Container container = QuarryPlus.proxy.getPacketPlayer((INetHandler)ctx.netHandler).field_71070_bA;
            if (this.containerId == container.field_75152_c && container instanceof ContainerEnchList) {
                ContainerEnchList enchList = (ContainerEnchList)container;
                enchList.tile.fortuneList.clear();
                enchList.tile.fortuneList.addAll((Collection<BlockData>)this.fortuneList);
                enchList.tile.silktouchList.clear();
                enchList.tile.silktouchList.addAll((Collection<BlockData>)this.silkList);
            }
        });
        return null;
    }
}

