/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.quarry;

import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.tile.TileQuarry;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MoveHead
implements IMessage {
    int dim;
    BlockPos pos;
    double headPosX;
    double headPosY;
    double headPosZ;

    public static MoveHead create(TileQuarry quarry) {
        MoveHead message = new MoveHead();
        message.dim = quarry.func_145831_w().field_73011_w.getDimension();
        message.pos = quarry.func_174877_v();
        message.headPosX = quarry.headPosX;
        message.headPosY = quarry.headPosY;
        message.headPosZ = quarry.headPosZ;
        return message;
    }

    public static void send(TileQuarry quarry) {
        if (!Config.content().disableRendering()) {
            PacketHandler.sendToAround(MoveHead.create(quarry), quarry.func_145831_w(), quarry.func_174877_v());
        }
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.dim = buffer.readInt();
        this.headPosX = buffer.readDouble();
        this.headPosY = buffer.readDouble();
        this.headPosZ = buffer.readDouble();
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos).writeInt(this.dim);
        buffer.writeDouble(this.headPosX).writeDouble(this.headPosY).writeDouble(this.headPosZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IMessage onRecieve(IMessage message, MessageContext ctx) {
        TileEntity entity;
        World world = QuarryPlus.proxy.getPacketWorld(ctx.netHandler);
        if (world.field_73011_w.getDimension() == this.dim && (entity = world.func_175625_s(this.pos)) instanceof TileQuarry) {
            TileQuarry quarry = (TileQuarry)entity;
            quarry.headPosX = this.headPosX;
            quarry.headPosY = this.headPosY;
            quarry.headPosZ = this.headPosZ;
        }
        return null;
    }
}

