/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import com.yogpc.qp.NonNullList;
import com.yogpc.qp.version.VersionUtil;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ItemStackHelper {
    public static ItemStack getAndSplit(List<ItemStack> stacks, int index, int amount) {
        if (index >= 0 && index < stacks.size()) {
            ItemStack stack1 = stacks.get(index);
            if (VersionUtil.nonEmpty(stack1) && amount > 0) {
                ItemStack stack = stack1.func_77979_a(amount);
                if (VersionUtil.isEmpty(stack1)) {
                    stacks.set(index, VersionUtil.empty());
                }
                return stack;
            }
            return VersionUtil.empty();
        }
        return VersionUtil.empty();
    }

    public static ItemStack getAndRemove(List<ItemStack> stacks, int index) {
        return index >= 0 && index < stacks.size() ? stacks.set(index, VersionUtil.empty()) : VersionUtil.empty();
    }

    public static NBTTagCompound saveAllItems(NBTTagCompound tag, NonNullList<ItemStack> list) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < list.size(); ++i) {
            ItemStack itemstack = list.get(i);
            if (!VersionUtil.nonEmpty(itemstack)) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        if (!nbttaglist.func_82582_d()) {
            tag.func_74782_a("Items", (NBTBase)nbttaglist);
        }
        return tag;
    }

    public static void loadAllItems(NBTTagCompound tag, NonNullList<ItemStack> list) {
        NBTTagList nbttaglist = tag.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j >= list.size()) continue;
            list.set(j, VersionUtil.fromNBTTag(nbttagcompound));
        }
    }
}

