/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import cofh.api.tileentity.IInventoryConnection;
import com.yogpc.qp.BlockData;
import com.yogpc.qp.NonNullList;
import com.yogpc.qp.PowerManager;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.ReflectionHelper;
import com.yogpc.qp.compat.InvUtils;
import com.yogpc.qp.compat.NBTBuilder;
import com.yogpc.qp.tile.APowerTile;
import com.yogpc.qp.tile.EnergyUsage;
import com.yogpc.qp.tile.HasInv;
import com.yogpc.qp.tile.IEnchantableTile;
import com.yogpc.qp.tile.NoDuplicateList;
import com.yogpc.qp.tile.QuarryFakePlayer;
import com.yogpc.qp.tile.TileExpPump;
import com.yogpc.qp.tile.TilePump;
import com.yogpc.qp.version.VersionUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

@Optional.Interface(iface="cofh.api.tileentity.IInventoryConnection", modid="cofhapi|tileentity")
public abstract class TileBasic
extends APowerTile
implements IEnchantableTile,
HasInv,
IInventoryConnection {
    @Nullable
    protected EnumFacing pump = null;
    @Nullable
    protected EnumFacing exppump = null;
    public final NoDuplicateList<BlockData> fortuneList = NoDuplicateList.create(ArrayList::new);
    public final NoDuplicateList<BlockData> silktouchList = NoDuplicateList.create(ArrayList::new);
    public boolean fortuneInclude;
    public boolean silktouchInclude;
    protected byte unbreaking;
    protected byte fortune;
    protected boolean silktouch;
    protected byte efficiency;
    protected final LinkedList<ItemStack> cacheItems = new LinkedList();
    protected final IItemHandler handler = new InvWrapper(this){

        @Nullable
        public ItemStack insertItem(int slot, @Nullable ItemStack stack, boolean simulate) {
            return stack;
        }
    };
    protected Map<Integer, Integer> ench = new HashMap<Integer, Integer>();
    public static final Method createStackedBlock = ReflectionHelper.getMethod(Block.class, new String[]{"func_180643_i", "createStackedBlock"}, new Class[][]{{IBlockState.class}});

    public abstract void G_renew_powerConfigure();

    protected abstract void G_destroy();

    @Override
    public final void onChunkUnload() {
        this.G_destroy();
        super.onChunkUnload();
    }

    protected void S_pollItems() {
        ItemStack is;
        while (null != (is = this.cacheItems.poll())) {
            ItemStack stack = InvUtils.injectToNearTile(this.func_145831_w(), this.func_174877_v(), is);
            if (VersionUtil.getCount(stack) <= 0) continue;
            this.cacheItems.add(stack);
            break;
        }
    }

    protected boolean S_breakBlock(int x, int y, int z) {
        TileExpPump t;
        double expEnergy;
        TileEntity entity;
        LinkedList<ItemStack> dropped = new LinkedList<ItemStack>();
        Chunk loadedChunk = this.func_145831_w().func_72863_F().func_186026_b(x >> 4, z >> 4);
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState blockState = loadedChunk == null ? this.func_145831_w().func_180495_p(pos) : loadedChunk.func_186032_a(x & 0xF, y, z & 0xF);
        if (blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.func_145831_w(), pos)) {
            return true;
        }
        if (this.pump != null && TilePump.isLiquid(blockState)) {
            TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(this.pump));
            if (!(te instanceof TilePump)) {
                this.pump = null;
                this.G_renew_powerConfigure();
                return true;
            }
            return ((TilePump)te).S_removeLiquids(this, x, y, z);
        }
        BI bi = this.S_addDroppedItems(dropped, blockState, pos);
        if (!PowerManager.useEnergyBreak(this, blockState.func_185887_b(this.func_145831_w(), pos), bi.b, this.unbreaking)) {
            return false;
        }
        if (this.exppump != null && (entity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.exppump))) instanceof TileExpPump && this.useEnergy(expEnergy = (t = (TileExpPump)entity).getEnergyUse(bi.i), expEnergy, false, EnergyUsage.PUMP_EXP) == expEnergy) {
            this.useEnergy(expEnergy, expEnergy, true, EnergyUsage.PUMP_EXP);
            t.addXp(bi.i);
        }
        this.cacheItems.addAll(dropped);
        this.func_145831_w().func_175655_b(pos, false);
        return true;
    }

    boolean S_connectPump(EnumFacing facing) {
        TileEntity te;
        if (this.pump != null && (te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(this.pump))) instanceof TilePump && this.pump != facing) {
            return false;
        }
        this.pump = facing;
        this.G_renew_powerConfigure();
        return true;
    }

    boolean S_connectExppump(EnumFacing facing) {
        TileEntity entity;
        if (this.exppump != null && (entity = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(this.exppump))) instanceof TileExpPump && this.exppump != facing) {
            return false;
        }
        this.exppump = facing;
        this.G_renew_powerConfigure();
        return true;
    }

    private BI S_addDroppedItems(Collection<ItemStack> collection, IBlockState state, BlockPos pos) {
        int i;
        Block block = state.func_177230_c();
        int xp = 0;
        QuarryFakePlayer fakePlayer = QuarryFakePlayer.get((WorldServer)this.func_145831_w());
        fakePlayer.func_184611_a(EnumHand.MAIN_HAND, this.getEnchantedPickaxe());
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(this.field_145850_b, pos, state, (EntityPlayer)fakePlayer);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            HashSet<Object> rawItems;
            if (block.canSilkHarvest(this.func_145831_w(), pos, state, (EntityPlayer)fakePlayer) && this.silktouch && this.silktouchList.contains(new BlockData(block, state)) == this.silktouchInclude) {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>(1);
                list.add((ItemStack)ReflectionHelper.invoke(createStackedBlock, block, state));
                rawItems = new HashSet(list);
                ForgeEventFactory.fireBlockHarvesting(list, (World)this.field_145850_b, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)fakePlayer);
                collection.addAll(list);
                i = -1;
            } else {
                boolean b = this.fortuneList.contains(new BlockData(block, state)) == this.fortuneInclude;
                int fortuneLevel = b ? this.fortune : 0;
                NonNullList<ItemStack> list = NonNullList.create();
                TileBasic.getDrops(this.func_145831_w(), pos, state, block, fortuneLevel, list);
                rawItems = new HashSet<ItemStack>(list);
                ForgeEventFactory.fireBlockHarvesting(list, (World)this.field_145850_b, (BlockPos)pos, (IBlockState)state, (int)fortuneLevel, (float)1.0f, (boolean)false, (EntityPlayer)fakePlayer);
                collection.addAll(list);
                i = fortuneLevel;
            }
            if (this.exppump != null) {
                xp += event.getExpToDrop();
                if (InvUtils.hasSmelting(fakePlayer.func_184614_ca())) {
                    xp += TileBasic.getSmeltingXp(collection, rawItems);
                }
            }
        } else {
            i = -2;
        }
        fakePlayer.func_184611_a(EnumHand.MAIN_HAND, VersionUtil.empty());
        return new BI((byte)i, xp);
    }

    public static void getDrops(World world, BlockPos pos, IBlockState state, Block block, int fortuneLevel, NonNullList<ItemStack> list) {
        list.addAll(block.getDrops((IBlockAccess)world, pos, state, fortuneLevel));
    }

    public static int getSmeltingXp(Collection<ItemStack> stacks, Collection<ItemStack> raws) {
        return stacks.stream().filter(s -> !raws.contains(s)).mapToInt(stack -> TileBasic.floorFloat(FurnaceRecipes.func_77602_a().func_151398_b(stack) * (float)VersionUtil.getCount(stack))).sum();
    }

    static int floorFloat(float value) {
        int i = MathHelper.func_76141_d((float)value);
        return i + (Math.random() < (double)(value - (float)i) ? 1 : 0);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttc) {
        super.func_145839_a(nbttc);
        this.silktouch = nbttc.func_74767_n("silktouch");
        this.fortune = nbttc.func_74771_c("fortune");
        this.efficiency = nbttc.func_74771_c("efficiency");
        this.unbreaking = nbttc.func_74771_c("unbreaking");
        this.fortuneInclude = nbttc.func_74767_n("fortuneInclude");
        this.silktouchInclude = nbttc.func_74767_n("silktouchInclude");
        TileBasic.readLongCollection(nbttc.func_150295_c("fortuneList", 10), this.fortuneList);
        TileBasic.readLongCollection(nbttc.func_150295_c("silktouchList", 10), this.silktouchList);
        this.ench = NBTBuilder.fromList(nbttc.func_150295_c("enchList", 10), n -> n.func_74762_e("id"), n -> n.func_74762_e("value"), s -> Enchantment.func_185262_c((int)s) != null, s -> true);
    }

    private static void readLongCollection(NBTTagList nbttl, Collection<BlockData> target) {
        target.clear();
        for (int i = 0; i < nbttl.func_74745_c(); ++i) {
            NBTTagCompound c = nbttl.func_150305_b(i);
            target.add(new BlockData(c.func_74779_i(BlockData.Name_NBT()), c.func_74762_e(BlockData.Meta_NBT())));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttc) {
        nbttc.func_74757_a("silktouch", this.silktouch);
        nbttc.func_74774_a("fortune", this.fortune);
        nbttc.func_74774_a("efficiency", this.efficiency);
        nbttc.func_74774_a("unbreaking", this.unbreaking);
        nbttc.func_74757_a("fortuneInclude", this.fortuneInclude);
        nbttc.func_74757_a("silktouchInclude", this.silktouchInclude);
        nbttc.func_74782_a("fortuneList", (NBTBase)TileBasic.writeLongCollection(this.fortuneList));
        nbttc.func_74782_a("silktouchList", (NBTBase)TileBasic.writeLongCollection(this.silktouchList));
        Function<Integer, Short> function = Integer::shortValue;
        nbttc.func_74782_a("enchList", (NBTBase)NBTBuilder.fromMap(this.ench, "id", "value", function.andThen(NBTTagShort::new), function.andThen(NBTTagShort::new)));
        return super.func_189515_b(nbttc);
    }

    private static NBTTagList writeLongCollection(Collection<BlockData> target) {
        NBTTagList nbttl = new NBTTagList();
        for (BlockData l : target) {
            nbttl.func_74742_a((NBTBase)l.writeToNBT(new NBTTagCompound()).func_74775_l(BlockData.BlockData_NBT()));
        }
        return nbttl;
    }

    @Override
    public Map<Integer, Integer> getEnchantments() {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>(this.ench);
        if (this.efficiency > 0) {
            ret.put(EfficiencyID, Integer.valueOf(this.efficiency));
        }
        if (this.fortune > 0) {
            ret.put(FortuneID, Integer.valueOf(this.fortune));
        }
        if (this.unbreaking > 0) {
            ret.put(UnbreakingID, Integer.valueOf(this.unbreaking));
        }
        if (this.silktouch) {
            ret.put(SilktouchID, 1);
        }
        return ret;
    }

    @Override
    public void setEnchantent(short id, short val) {
        if (id == EfficiencyID) {
            this.efficiency = (byte)val;
        } else if (id == FortuneID) {
            this.fortune = (byte)val;
        } else if (id == UnbreakingID) {
            this.unbreaking = (byte)val;
        } else if (id == SilktouchID) {
            boolean bl = this.silktouch = val > 0;
        }
        if (val > 0) {
            this.ench.put(Integer.valueOf(id), Integer.valueOf(val));
        }
    }

    @Override
    public int func_70302_i_() {
        return Math.max(1, this.cacheItems.size());
    }

    @Override
    @Nullable
    public ItemStack func_70301_a(int i) {
        return i < 0 || i >= this.cacheItems.size() ? VersionUtil.empty() : this.cacheItems.get(i);
    }

    @Override
    @Nullable
    public ItemStack func_70298_a(int index, int count) {
        if (index < 0 || index >= this.cacheItems.size()) {
            return VersionUtil.empty();
        }
        ItemStack from = this.cacheItems.get(index);
        ItemStack res = new ItemStack(from.func_77973_b(), Math.min(count, VersionUtil.getCount(from)), from.func_77952_i());
        if (from.func_77942_o()) {
            res.func_77982_d(from.func_77978_p().func_74737_b());
        }
        VersionUtil.shrink(from, VersionUtil.getCount(res));
        if (VersionUtil.isEmpty(from)) {
            this.cacheItems.remove(index);
        }
        return res;
    }

    @Override
    @Nullable
    public ItemStack func_70304_b(int index) {
        return index < 0 || index >= this.cacheItems.size() ? VersionUtil.empty() : this.cacheItems.remove(index);
    }

    @Override
    public void func_70299_a(int index, @Nullable ItemStack stack) {
        if (VersionUtil.nonEmpty(stack)) {
            QuarryPlus.LOGGER.warn("QuarryPlus WARN: call setInventorySlotContents with non null ItemStack.");
        }
        this.func_70304_b(index);
    }

    public String func_70005_c_() {
        return "container.yog.basic";
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer player) {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.cacheItems.isEmpty();
    }

    @Override
    public void func_174888_l() {
        this.cacheItems.clear();
    }

    @Optional.Method(modid="cofhapi|tileentity")
    public final IInventoryConnection.ConnectionType canConnectInventory(EnumFacing arg0) {
        return IInventoryConnection.ConnectionType.FORCE;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.handler);
        }
        return super.getCapability(capability, facing);
    }

    private static class BI {
        final byte b;
        final int i;

        private BI(byte b, int i) {
            this.b = b;
            this.i = i;
        }
    }
}

