/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import com.yogpc.qp.PowerManager;
import com.yogpc.qp.tile.APowerTile;
import com.yogpc.qp.tile.IDebugSender;
import com.yogpc.qp.tile.IEnchantableTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scala.Symbol;

public class TileLaser
extends APowerTile
implements IEnchantableTile,
IDebugSender {
    public static final Symbol SYMBOL = Symbol.apply((String)"LaserPlus");
    private int ticks;
    public Vec3d[] lasers = new Vec3d[0];
    private final List<BlockPos> targets = new ArrayList<BlockPos>();
    protected byte unbreaking;
    protected byte fortune;
    protected byte efficiency;
    protected boolean silktouch;
    private final double[] tp = new double[100];
    public double pa;
    private int pi = 0;
    public static final ResourceLocation[] LASER_TEXTURES = new ResourceLocation[]{new ResourceLocation("quarryplus", "textures/entities/laser_1.png"), new ResourceLocation("quarryplus", "textures/entities/laser_2.png"), new ResourceLocation("quarryplus", "textures/entities/laser_3.png"), new ResourceLocation("quarryplus", "textures/entities/laser_4.png"), new ResourceLocation("quarryplus", "textures/entities/stripes.png")};

    public TileLaser() {
        PowerManager.configureLaser(this, this.efficiency, this.unbreaking);
        this.bcLoaded = Loader.isModLoaded((String)"buildcraftcore");
    }

    @Override
    protected Symbol getSymbol() {
        return SYMBOL;
    }

    @Override
    public void func_73660_a() {
    }

    protected void removeLaser() {
        if (this.lasers != null) {
            for (int i = 0; i < this.lasers.length; ++i) {
                this.lasers[i] = null;
            }
        }
    }

    private void pushPower(long received) {
        this.pa -= this.tp[this.pi];
        this.pa += (double)received;
        this.tp[this.pi] = received;
        ++this.pi;
        if (this.pi == this.tp.length) {
            this.pi = 0;
        }
    }

    public ResourceLocation getTexture() {
        double avg = this.getAvg();
        if (avg <= 1.0) {
            return LASER_TEXTURES[0];
        }
        if (avg <= 2.0) {
            return LASER_TEXTURES[1];
        }
        if (avg <= 3.0) {
            return LASER_TEXTURES[2];
        }
        return LASER_TEXTURES[3];
    }

    public double getAvg() {
        return this.pa / 100.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttc) {
        super.func_145839_a(nbttc);
        this.fortune = nbttc.func_74771_c("fortune");
        this.efficiency = nbttc.func_74771_c("efficiency");
        this.unbreaking = nbttc.func_74771_c("unbreaking");
        this.silktouch = nbttc.func_74767_n("silktouch");
        PowerManager.configureLaser(this, this.efficiency, this.unbreaking);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttc) {
        nbttc.func_74774_a("fortune", this.fortune);
        nbttc.func_74774_a("efficiency", this.efficiency);
        nbttc.func_74774_a("unbreaking", this.unbreaking);
        nbttc.func_74757_a("silktouch", this.silktouch);
        return super.func_189515_b(nbttc);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.removeLaser();
    }

    @Override
    protected boolean isWorking() {
        return !this.targets.isEmpty();
    }

    @Override
    public Map<Integer, Integer> getEnchantments() {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        if (this.efficiency > 0) {
            ret.put(EfficiencyID, Integer.valueOf(this.efficiency));
        }
        if (this.fortune > 0) {
            ret.put(FortuneID, Integer.valueOf(this.fortune));
        }
        if (this.unbreaking > 0) {
            ret.put(UnbreakingID, Integer.valueOf(this.unbreaking));
        }
        if (this.silktouch) {
            ret.put(SilktouchID, 1);
        }
        return ret;
    }

    @Override
    public void setEnchantent(short id, short val) {
        if (id == EfficiencyID) {
            this.efficiency = (byte)val;
        } else if (id == FortuneID) {
            this.fortune = (byte)val;
        } else if (id == UnbreakingID) {
            this.unbreaking = (byte)val;
        } else if (id == SilktouchID) {
            this.silktouch = val > 0;
        }
    }

    @Override
    public void G_reinit() {
        PowerManager.configureLaser(this, this.efficiency, this.unbreaking);
    }

    public List<ITextComponent> getDebugmessages() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)toComponentString.apply("Targets"));
        this.targets.stream().map(pos1 -> String.format("x=%d, y=%d, z=%d", pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p())).reduce(combiner).map(toComponentString).ifPresent(list::add);
        list.add((ITextComponent)toComponentString.apply("Lasers"));
        Stream.of(this.lasers).filter(nonNull).map(pos1 -> String.format("x=%s, y=%s, z=%s", pos1.field_72450_a, pos1.field_72448_b, pos1.field_72449_c)).reduce(combiner).map(toComponentString).ifPresent(list::add);
        return list;
    }

    @Override
    public String getDebugName() {
        return "tile.laserplus.name";
    }

    public boolean hasFastRenderer() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        double minX = this.func_174877_v().func_177958_n();
        double minY = this.func_174877_v().func_177956_o();
        double minZ = this.func_174877_v().func_177952_p();
        double maxX = this.func_174877_v().func_177958_n() + 1;
        double maxY = this.func_174877_v().func_177956_o() + 1;
        double maxZ = this.func_174877_v().func_177952_p() + 1;
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

