/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import com.yogpc.qp.Config;
import com.yogpc.qp.NonNullList;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.block.BlockMarker;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.marker.LinkReply;
import com.yogpc.qp.packet.marker.LinkRequest;
import com.yogpc.qp.packet.marker.LinkUpdate;
import com.yogpc.qp.packet.marker.RemoveLink;
import com.yogpc.qp.render.Box;
import com.yogpc.qp.tile.APacketTile;
import com.yogpc.qp.tile.IChunkLoadTile;
import com.yogpc.qp.tile.IDebugSender;
import com.yogpc.qp.tile.IndexOnlyList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scala.Symbol;

public class TileMarker
extends APacketTile
implements ITickable,
IChunkLoadTile,
IDebugSender {
    public static final List<Link> linkList = Collections.synchronizedList(new ArrayList());
    public static final List<Laser> laserList = Collections.synchronizedList(new ArrayList());
    public static final IndexOnlyList<Link> LINK_INDEX = new IndexOnlyList<Link>(linkList, linkList);
    public static final IndexOnlyList<Laser> LASER_INDEX = new IndexOnlyList<Laser>(laserList, laserList);
    private static final int MAX_SIZE = 256;
    public static final Symbol SYMBOL = Symbol.apply((String)"MarkerPlus");
    private final boolean bcLoaded = Loader.isModLoaded((String)"buildcraftcore");
    public Link link;
    public Laser laser;
    private ForgeChunkManager.Ticket chunkTicket;
    private boolean vlF;

    @Override
    protected Symbol getSymbol() {
        return SYMBOL;
    }

    public void func_73660_a() {
        if (this.vlF) {
            int i2;
            this.vlF = false;
            int i = LINK_INDEX.indexOf(this);
            if (i >= 0) {
                this.link = linkList.get(i);
            }
            if ((i2 = LASER_INDEX.indexOf(this)) >= 0) {
                this.laser = laserList.get(i2);
            }
            this.G_updateSignal();
            if (this.func_145831_w().field_72995_K) {
                PacketHandler.sendToServer(LinkRequest.create(this));
            }
        }
    }

    public BlockPos min() {
        return this.link == null ? this.func_174877_v() : this.link.minPos();
    }

    public BlockPos max() {
        return this.link == null ? this.func_174877_v() : this.link.maxPos();
    }

    public void removeFromWorld() {
        if (this.link == null) {
            QuarryPlusI.blockMarker().func_176226_b(this.func_145831_w(), this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), 0);
            this.func_145831_w().func_175698_g(this.func_174877_v());
            return;
        }
        ArrayList<ItemStack> al = this.link.removeConnection(true);
        for (ItemStack is : al) {
            InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (ItemStack)is);
        }
    }

    public List<ItemStack> removeFromWorldWithItem() {
        if (this.link != null) {
            return this.link.removeConnection(true);
        }
        LinkedList<ItemStack> ret = new LinkedList<ItemStack>();
        ret.addAll(QuarryPlusI.blockMarker().getDrops((IBlockAccess)this.func_145831_w(), this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), 0));
        this.func_145831_w().func_175698_g(this.func_174877_v());
        return ret;
    }

    private static void S_renewConnection(Link l, World w, int x, int y, int z) {
        Block b;
        int tx = 0;
        int ty = 0;
        int tz = 0;
        if (l.xMax == l.xMin) {
            for (tx = 1; tx <= 256; ++tx) {
                b = w.func_180495_p(new BlockPos(x + tx, y, z)).func_177230_c();
                if (b instanceof BlockMarker && !LINK_INDEX.contains(new BlockIndex(w, x + tx, y, z))) {
                    l.xMax = x + tx;
                    break;
                }
                b = w.func_180495_p(new BlockPos(x - tx, y, z)).func_177230_c();
                if (!(b instanceof BlockMarker) || LINK_INDEX.contains(new BlockIndex(w, x - tx, y, z))) continue;
                tx = -tx;
                l.xMin = x + tx;
                break;
            }
            if (l.xMax == l.xMin) {
                tx = 0;
            }
        }
        if (l.yMax == l.yMin) {
            for (ty = 1; ty <= 256; ++ty) {
                b = w.func_180495_p(new BlockPos(x, y + ty, z)).func_177230_c();
                if (b instanceof BlockMarker && !LINK_INDEX.contains(new BlockIndex(w, x, y + ty, z))) {
                    l.yMax = y + ty;
                    break;
                }
                b = w.func_180495_p(new BlockPos(x, y - ty, z)).func_177230_c();
                if (!(b instanceof BlockMarker) || LINK_INDEX.contains(new BlockIndex(w, x, y - ty, z))) continue;
                ty = -ty;
                l.yMin = y + ty;
                break;
            }
            if (l.yMax == l.yMin) {
                ty = 0;
            }
        }
        if (l.zMax == l.zMin) {
            for (tz = 1; tz <= 256; ++tz) {
                b = w.func_180495_p(new BlockPos(x, y, z + tz)).func_177230_c();
                if (b instanceof BlockMarker && !LINK_INDEX.contains(new BlockIndex(w, x, y, z + tz))) {
                    l.zMax = z + tz;
                    break;
                }
                b = w.func_180495_p(new BlockPos(x, y, z - tz)).func_177230_c();
                if (!(b instanceof BlockMarker) || LINK_INDEX.contains(new BlockIndex(w, x, y, z - tz))) continue;
                tz = -tz;
                l.zMin = z + tz;
                break;
            }
            if (l.zMax == l.zMin) {
                tz = 0;
            }
        }
        if (l.xMax == l.xMin && ty != 0) {
            TileMarker.S_renewConnection(l, w, x, y + ty, z);
        }
        if (l.xMax == l.xMin && tz != 0) {
            TileMarker.S_renewConnection(l, w, x, y, z + tz);
        }
        if (l.yMax == l.yMin && tx != 0) {
            TileMarker.S_renewConnection(l, w, x + tx, y, z);
        }
        if (l.yMax == l.yMin && tz != 0) {
            TileMarker.S_renewConnection(l, w, x, y, z + tz);
        }
        if (l.zMax == l.zMin && tx != 0) {
            TileMarker.S_renewConnection(l, w, x + tx, y, z);
        }
        if (l.zMax == l.zMin && ty != 0) {
            TileMarker.S_renewConnection(l, w, x, y + ty, z);
        }
    }

    public void G_updateSignal() {
        if (this.laser != null) {
            this.laser.destructor();
            this.laser = null;
        }
        if (!this.func_145831_w().field_72995_K) {
            if (this.func_145831_w().func_175640_z(this.func_174877_v()) && (this.link == null || this.link.xMin == this.link.xMax || this.link.yMin == this.link.yMax || this.link.zMin == this.link.zMax)) {
                this.laser = new Laser(this.func_145831_w(), this.func_174877_v(), this.link);
                PacketHandler.sendToAround(LinkUpdate.create(this, true), this.func_145831_w(), this.func_174877_v());
            } else {
                PacketHandler.sendToAround(LinkUpdate.create(this, false), this.func_145831_w(), this.func_174877_v());
            }
        }
    }

    public void S_tryConnection() {
        if (this.link != null) {
            this.link.removeConnection(false);
        }
        this.link = new Link(this.func_145831_w(), this.func_174877_v());
        TileMarker.S_renewConnection(this.link, this.func_145831_w(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        if (this.link.xMax == this.link.xMin && this.link.yMax == this.link.yMin && this.link.zMax == this.link.zMin) {
            this.link = null;
            return;
        }
        this.link.init();
        this.link.makeLaser();
        PacketHandler.sendToAround(LinkReply.create(this), this.func_145831_w(), this.func_174877_v());
        this.G_updateSignal();
    }

    void G_destroy() {
        if (this.link != null) {
            this.link.removeConnection(false);
        }
        if (this.laser != null) {
            this.laser.destructor();
        }
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
    }

    @Override
    public void requestTicket() {
        if (this.chunkTicket != null) {
            return;
        }
        this.chunkTicket = ForgeChunkManager.requestTicket((Object)QuarryPlus.INSTANCE, (World)this.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (this.chunkTicket == null) {
            return;
        }
        NBTTagCompound tag = this.chunkTicket.getModData();
        tag.func_74768_a("quarryX", this.func_174877_v().func_177958_n());
        tag.func_74768_a("quarryY", this.func_174877_v().func_177956_o());
        tag.func_74768_a("quarryZ", this.func_174877_v().func_177952_p());
        this.forceChunkLoading(this.chunkTicket);
    }

    @Override
    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        if (this.chunkTicket == null) {
            this.chunkTicket = ticket;
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(this.func_174877_v()));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        if (this.laser != null || this.link != null) {
            return 262144.0;
        }
        return super.func_145833_n();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)super.getCapability(capability, facing);
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.vlF = true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.func_145831_w().func_180495_p(this.func_174877_v()).func_177230_c() != QuarryPlusI.blockMarker()) {
            this.G_destroy();
        }
    }

    @Override
    public String getDebugName() {
        return "tile.markerplus.name";
    }

    @Override
    public List<? extends ITextComponent> getDebugmessages() {
        return Arrays.asList(new TextComponentString("Link : " + this.link), new TextComponentString("Laser : " + this.laser));
    }

    static {
        BiPredicate<Link, Object> p1 = (link1, r) -> {
            if (r instanceof BlockIndex) {
                BlockIndex bi = (BlockIndex)r;
                return !(bi.x != link1.xMin && bi.x != link1.xMax || bi.y != link1.yMin && bi.y != link1.yMax || bi.z != link1.zMin && bi.z != link1.zMax || link1.w != bi.w);
            }
            return false;
        };
        BiPredicate<Link, Object> p2 = (link1, r) -> {
            if (r instanceof TileEntity) {
                TileEntity te = (TileEntity)r;
                return (te.func_174877_v().equals((Object)link1.minPos()) || te.func_174877_v().equals((Object)link1.maxPos())) && link1.w == te.func_145831_w();
            }
            return false;
        };
        BiPredicate<Laser, Object> p3 = (laser1, r) -> {
            if (r instanceof BlockIndex) {
                BlockIndex bi = (BlockIndex)r;
                return bi.x == laser1.x && bi.y == laser1.y && bi.z == laser1.z && bi.w == laser1.w;
            }
            return false;
        };
        BiPredicate<Laser, Object> p4 = (laser1, r) -> {
            if (r instanceof TileEntity) {
                TileEntity te = (TileEntity)r;
                return te.func_174877_v().equals((Object)new BlockPos(laser1.x, laser1.y, laser1.z)) && laser1.w == te.func_145831_w();
            }
            return false;
        };
        LINK_INDEX.addPredicate(p1);
        LINK_INDEX.addPredicate(p2);
        LASER_INDEX.addPredicate(p3);
        LASER_INDEX.addPredicate(p4);
    }

    public static class Link {
        public int xMax;
        public int xMin;
        public int yMax;
        public int yMin;
        public int zMax;
        public int zMin;
        public final AxisAlignedBB[] lineBoxes = new AxisAlignedBB[12];
        public Box[] boxes;
        public final World w;

        Link(World world, BlockPos pos) {
            this(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }

        public Link(World world, BlockPos max, BlockPos min) {
            this(world, max.func_177958_n(), min.func_177958_n(), max.func_177956_o(), min.func_177956_o(), max.func_177952_p(), min.func_177952_p());
        }

        Link(World pw, int vx, int vy, int vz) {
            this.xMax = vx;
            this.xMin = vx;
            this.yMax = vy;
            this.yMin = vy;
            this.zMax = vz;
            this.zMin = vz;
            this.w = pw;
        }

        Link(World pw, int vxx, int vxn, int vyx, int vyn, int vzx, int vzn) {
            this.xMax = vxx;
            this.xMin = vxn;
            this.yMax = vyx;
            this.yMin = vyn;
            this.zMax = vzx;
            this.zMin = vzn;
            this.w = pw;
        }

        private void connect(TileEntity te) {
            if (te instanceof TileMarker) {
                TileMarker marker = (TileMarker)te;
                if (marker.link != null && marker.link != this) {
                    marker.link.removeConnection(false);
                }
                marker.link = this;
            }
        }

        private NonNullList<ItemStack> removeLink(int x, int y, int z, boolean bb) {
            NonNullList<ItemStack> ret = NonNullList.create();
            BlockPos pos = new BlockPos(x, y, z);
            TileEntity te = this.w.func_175625_s(pos);
            IBlockState state = this.w.func_180495_p(pos);
            if (state.func_177230_c() instanceof BlockMarker) {
                if (te instanceof TileMarker) {
                    ((TileMarker)te).link = null;
                }
                ret.addAll(state.func_177230_c().getDrops((IBlockAccess)this.w, pos, state, 0));
                if (bb) {
                    this.w.func_175698_g(pos);
                }
            }
            return ret;
        }

        public void init() {
            int i = linkList.indexOf(this);
            if (i >= 0) {
                linkList.get(i).removeConnection(false);
            }
            linkList.add(this);
            this.connect(this.w.func_175625_s(this.minPos()));
            this.connect(this.w.func_175625_s(new BlockPos(this.xMin, this.yMin, this.zMax)));
            this.connect(this.w.func_175625_s(new BlockPos(this.xMin, this.yMax, this.zMin)));
            this.connect(this.w.func_175625_s(new BlockPos(this.xMin, this.yMax, this.zMax)));
            this.connect(this.w.func_175625_s(new BlockPos(this.xMax, this.yMin, this.zMin)));
            this.connect(this.w.func_175625_s(new BlockPos(this.xMax, this.yMin, this.zMax)));
            this.connect(this.w.func_175625_s(new BlockPos(this.xMax, this.yMax, this.zMin)));
            this.connect(this.w.func_175625_s(this.maxPos()));
        }

        public ArrayList<ItemStack> removeConnection(boolean bb) {
            linkList.remove(this);
            if (!this.w.field_72995_K) {
                PacketHandler.sendToDimension(RemoveLink.create(this.minPos(), this.maxPos(), this.w.field_73011_w.getDimension()), this.w.field_73011_w.getDimension());
            }
            this.deleteLaser();
            ArrayList<ItemStack> i = new ArrayList<ItemStack>();
            i.addAll(this.removeLink(this.xMin, this.yMin, this.zMin, bb));
            i.addAll(this.removeLink(this.xMin, this.yMin, this.zMax, bb));
            i.addAll(this.removeLink(this.xMin, this.yMax, this.zMin, bb));
            i.addAll(this.removeLink(this.xMin, this.yMax, this.zMax, bb));
            i.addAll(this.removeLink(this.xMax, this.yMin, this.zMin, bb));
            i.addAll(this.removeLink(this.xMax, this.yMin, this.zMax, bb));
            i.addAll(this.removeLink(this.xMax, this.yMax, this.zMin, bb));
            i.addAll(this.removeLink(this.xMax, this.yMax, this.zMax, bb));
            return i;
        }

        public void makeLaser() {
            this.deleteLaser();
            byte flag = 0;
            double a = 0.5;
            double b = 0.625;
            double c = 0.375;
            if (this.xMin != this.xMax) {
                flag = (byte)(flag | 1);
            }
            if (this.yMin != this.yMax) {
                flag = (byte)(flag | 2);
            }
            if (this.zMin != this.zMax) {
                flag = (byte)(flag | 4);
            }
            if ((flag & 1) == 1) {
                this.lineBoxes[0] = new AxisAlignedBB((double)this.xMin + 0.625, (double)this.yMin + 0.5, (double)this.zMin + 0.5, (double)this.xMax + 0.375, (double)this.yMin + 0.5, (double)this.zMin + 0.5);
            }
            if ((flag & 2) == 2) {
                this.lineBoxes[4] = new AxisAlignedBB((double)this.xMin + 0.5, (double)this.yMin + 0.625, (double)this.zMin + 0.5, (double)this.xMin + 0.5, (double)this.yMax + 0.375, (double)this.zMin + 0.5);
            }
            if ((flag & 4) == 4) {
                this.lineBoxes[8] = new AxisAlignedBB((double)this.xMin + 0.5, (double)this.yMin + 0.5, (double)this.zMin + 0.625, (double)this.xMin + 0.5, (double)this.yMin + 0.5, (double)this.zMax + 0.375);
            }
            if ((flag & 3) == 3) {
                this.lineBoxes[2] = new AxisAlignedBB((double)this.xMin + 0.625, (double)this.yMax + 0.5, (double)this.zMin + 0.5, (double)this.xMax + 0.375, (double)this.yMax + 0.5, (double)this.zMin + 0.5);
                this.lineBoxes[6] = new AxisAlignedBB((double)this.xMax + 0.5, (double)this.yMin + 0.625, (double)this.zMin + 0.5, (double)this.xMax + 0.5, (double)this.yMax + 0.375, (double)this.zMin + 0.5);
            }
            if ((flag & 5) == 5) {
                this.lineBoxes[1] = new AxisAlignedBB((double)this.xMin + 0.625, (double)this.yMin + 0.5, (double)this.zMax + 0.5, (double)this.xMax + 0.375, (double)this.yMin + 0.5, (double)this.zMax + 0.5);
                this.lineBoxes[9] = new AxisAlignedBB((double)this.xMax + 0.5, (double)this.yMin + 0.5, (double)this.zMin + 0.625, (double)this.xMax + 0.5, (double)this.yMin + 0.5, (double)this.zMax + 0.375);
            }
            if ((flag & 6) == 6) {
                this.lineBoxes[5] = new AxisAlignedBB((double)this.xMin + 0.5, (double)this.yMin + 0.625, (double)this.zMax + 0.5, (double)this.xMin + 0.5, (double)this.yMax + 0.375, (double)this.zMax + 0.5);
                this.lineBoxes[10] = new AxisAlignedBB((double)this.xMin + 0.5, (double)this.yMax + 0.5, (double)this.zMin + 0.625, (double)this.xMin + 0.5, (double)this.yMax + 0.5, (double)this.zMax + 0.375);
            }
            if ((flag & 7) == 7) {
                this.lineBoxes[3] = new AxisAlignedBB((double)this.xMin + 0.625, (double)this.yMax + 0.5, (double)this.zMax + 0.5, (double)this.xMax + 0.375, (double)this.yMax + 0.5, (double)this.zMax + 0.5);
                this.lineBoxes[7] = new AxisAlignedBB((double)this.xMax + 0.5, (double)this.yMin + 0.625, (double)this.zMax + 0.5, (double)this.xMax + 0.5, (double)this.yMax + 0.375, (double)this.zMax + 0.5);
                this.lineBoxes[11] = new AxisAlignedBB((double)this.xMax + 0.5, (double)this.yMax + 0.5, (double)this.zMin + 0.625, (double)this.xMax + 0.5, (double)this.yMax + 0.5, (double)this.zMax + 0.375);
            }
            this.boxes = this.w.field_72995_K ? (Box[])Arrays.stream(this.lineBoxes).filter(APacketTile.nonNull).map(aabb -> Box.apply(aabb, 0.125, 0.125, 0.125, false, false)).toArray(Box[]::new) : null;
        }

        public void deleteLaser() {
        }

        public BlockPos minPos() {
            return new BlockPos(this.xMin, this.yMin, this.zMin);
        }

        public BlockPos maxPos() {
            return new BlockPos(this.xMax, this.yMax, this.zMax);
        }

        public String toString() {
            long i = Stream.of(this.lineBoxes).filter(APacketTile.nonNull).count();
            return this.minPos() + " to " + this.maxPos() + " Lasers : " + i;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Link)) {
                return false;
            }
            Link l = (Link)o;
            return l.xMin == this.xMin && l.xMax == this.xMax && l.yMin == this.yMin && l.yMax == this.yMax && l.zMin == this.zMin && l.zMax == this.zMax && l.w == this.w;
        }

        public int hashCode() {
            return (this.xMin << 10 + this.yMin << 5 + this.zMin) + (this.xMax << 10 + this.yMax << 5 + this.zMax);
        }
    }

    public static class Laser {
        public final World w;
        final int x;
        final int y;
        final int z;
        public final AxisAlignedBB[] lineBoxes = new AxisAlignedBB[6];
        public final Box[] boxes;

        public Laser(World w, BlockPos pos, Link link) {
            this(w, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), link);
        }

        private Laser(World pw, int px, int py, int pz, Link l) {
            this.x = px;
            this.y = py;
            this.z = pz;
            this.w = pw;
            double b = 0.625;
            double c = 0.375;
            if (l == null || l.xMin == l.xMax) {
                this.lineBoxes[0] = new AxisAlignedBB((double)px + b - 256.0, (double)py + 0.5, (double)pz + 0.5, (double)px + c, (double)py + 0.5, (double)pz + 0.5);
                this.lineBoxes[3] = new AxisAlignedBB((double)px + b, (double)py + 0.5, (double)pz + 0.5, (double)px + c + 256.0, (double)py + 0.5, (double)pz + 0.5);
            }
            if (l == null || l.yMin == l.yMax) {
                this.lineBoxes[1] = new AxisAlignedBB((double)px + 0.5, 0.0, (double)pz + 0.5, (double)px + 0.5, (double)py - 0.1, (double)pz + 0.5);
                this.lineBoxes[4] = new AxisAlignedBB((double)px + 0.5, (double)py + b, (double)pz + 0.5, (double)px + 0.5, 255.0, (double)pz + 0.5);
            }
            if (l == null || l.zMin == l.zMax) {
                this.lineBoxes[2] = new AxisAlignedBB((double)px + 0.5, (double)py + 0.5, (double)pz + b - 256.0, (double)px + 0.5, (double)py + 0.5, (double)pz + c);
                this.lineBoxes[5] = new AxisAlignedBB((double)px + 0.5, (double)py + 0.5, (double)pz + b, (double)px + 0.5, (double)py + 0.5, (double)pz + c + 256.0);
            }
            this.boxes = pw.field_72995_K && !Config.content().disableRendering() ? (Box[])Arrays.stream(this.lineBoxes).filter(APacketTile.nonNull).map(aabb -> Box.apply(aabb, 0.125, 0.125, 0.125, false, false)).toArray(Box[]::new) : null;
            this.destructor();
            laserList.add(this);
        }

        public void destructor() {
            laserList.remove(this);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Laser)) {
                return false;
            }
            Laser l = (Laser)o;
            return l.x == this.x && l.y == this.y && l.z == this.z && l.w == this.w;
        }

        public int hashCode() {
            return this.x << 21 ^ this.y << 11 ^ this.z;
        }

        public String toString() {
            long i = Stream.of(this.lineBoxes).filter(APacketTile.nonNull).count();
            return this.x + " " + this.y + " " + this.z + " Lasers : " + i;
        }
    }

    public static class BlockIndex {
        final World w;
        final int x;
        final int y;
        final int z;

        public BlockIndex(World pw, int px, int py, int pz) {
            this.w = pw;
            this.x = px;
            this.y = py;
            this.z = pz;
        }
    }
}

