/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import com.yogpc.qp.PowerManager;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.block.BlockMiningWell;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.TileMessage;
import com.yogpc.qp.tile.TileBasic;
import com.yogpc.qp.tile.TileExpPump;
import com.yogpc.qp.tile.TilePump;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import scala.Symbol;

public class TileMiningWell
extends TileBasic
implements ITickable {
    public static final Symbol SYMBOL = Symbol.apply((String)"MiningwellPlus");
    public boolean working;

    @Override
    public void G_renew_powerConfigure() {
        TileEntity entity;
        int pmp = 0;
        if (this.hasWorld() && this.pump != null) {
            TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(this.pump));
            if (te instanceof TilePump) {
                pmp = ((TilePump)te).unbreaking;
            } else {
                this.pump = null;
            }
        }
        if (this.hasWorld() && this.exppump != null && !((entity = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(this.exppump))) instanceof TileExpPump)) {
            this.exppump = null;
        }
        if (this.working) {
            PowerManager.configureMiningWell(this, this.efficiency, this.unbreaking, pmp);
        } else {
            PowerManager.configure0(this);
        }
    }

    @Override
    public String func_70005_c_() {
        return "tile.miningwellplus.name";
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K && !this.machineDisabled) {
            int depth = this.func_174877_v().func_177956_o() - 1;
            while (!this.S_checkTarget(depth)) {
                if (this.working) {
                    this.func_145831_w().func_175656_a(new BlockPos(this.func_174877_v().func_177958_n(), depth, this.func_174877_v().func_177952_p()), QuarryPlusI.blockPlainPipe().func_176223_P());
                }
                --depth;
            }
            if (this.working) {
                this.S_breakBlock(this.func_174877_v().func_177958_n(), depth, this.func_174877_v().func_177952_p());
            }
            this.S_pollItems();
        }
    }

    @Override
    protected boolean isWorking() {
        return this.working;
    }

    private boolean S_checkTarget(int depth) {
        if (depth < 1) {
            this.G_destroy();
            this.finishWork();
            return true;
        }
        BlockPos pos = new BlockPos(this.func_174877_v().func_177958_n(), depth, this.func_174877_v().func_177952_p());
        Chunk loadedChunk = this.func_145831_w().func_72863_F().func_186026_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        IBlockState b = loadedChunk != null ? loadedChunk.func_177435_g(pos) : this.func_145831_w().func_180495_p(pos);
        float h = b.func_185887_b(this.func_145831_w(), pos);
        if (h < 0.0f || b.func_177230_c() == QuarryPlusI.blockPlainPipe() || b.func_177230_c().isAir(b, (IBlockAccess)this.func_145831_w(), pos)) {
            return false;
        }
        if (this.pump == null && b.func_185904_a().func_76224_d()) {
            return false;
        }
        if (!this.working) {
            this.G_reinit();
        }
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttc) {
        super.func_145839_a(nbttc);
        this.setWorking(nbttc.func_74767_n("working"));
        this.G_renew_powerConfigure();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttc) {
        nbttc.func_74757_a("working", this.working);
        return super.func_189515_b(nbttc);
    }

    @Override
    public void G_reinit() {
        this.setWorking(true);
        this.G_renew_powerConfigure();
        if (!this.func_145831_w().field_72995_K) {
            PacketHandler.sendToAround(TileMessage.create(this), this.func_145831_w(), this.func_174877_v());
        }
    }

    @Override
    protected void G_destroy() {
        if (!this.func_145831_w().field_72995_K) {
            this.working = false;
            this.G_renew_powerConfigure();
            PacketHandler.sendToAround(TileMessage.create(this), this.func_145831_w(), this.func_174877_v());
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.func_174877_v());
            for (int depth = this.func_174877_v().func_177956_o() - 1; depth > 0; --depth) {
                pos.func_185336_p(depth);
                if (this.func_145831_w().func_180495_p((BlockPos)pos).func_177230_c() != QuarryPlusI.blockPlainPipe()) break;
                this.func_145831_w().func_175698_g((BlockPos)pos);
            }
        }
    }

    public void setWorking(boolean working) {
        this.working = working;
        if (working) {
            this.startWork();
        }
        if (this.hasWorld()) {
            IBlockState old = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145829_t();
            this.func_145831_w().func_175656_a(this.func_174877_v(), old.func_177226_a((IProperty)BlockMiningWell.ACTING, (Comparable)Boolean.valueOf(working)));
            this.func_145829_t();
            this.func_145831_w().func_175690_a(this.func_174877_v(), (TileEntity)this);
        }
    }

    @Override
    protected Symbol getSymbol() {
        return SYMBOL;
    }
}

