/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import com.yogpc.qp.PowerManager;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.block.BlockFrame;
import com.yogpc.qp.block.BlockQuarry;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.TileMessage;
import com.yogpc.qp.packet.quarry.ModeMessage;
import com.yogpc.qp.packet.quarry.MoveHead;
import com.yogpc.qp.tile.EnergyUsage;
import com.yogpc.qp.tile.IChunkLoadTile;
import com.yogpc.qp.tile.IDebugSender;
import com.yogpc.qp.tile.TileBasic;
import com.yogpc.qp.tile.TileExpPump;
import com.yogpc.qp.tile.TileMarker;
import com.yogpc.qp.tile.TilePump;
import com.yogpc.qp.version.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scala.Symbol;

public class TileQuarry
extends TileBasic
implements IDebugSender,
IChunkLoadTile {
    public static final Symbol SYMBOL = Symbol.apply((String)"QuarryPlus");
    private int targetX;
    private int targetY;
    private int targetZ;
    public int xMin;
    public int xMax;
    public int yMin;
    public int yMax = Integer.MIN_VALUE;
    public int zMin;
    public int zMax;
    public boolean filler;
    @Nullable
    private Object areaProvider = null;
    private boolean addX = true;
    private boolean addZ = true;
    private boolean digged = true;
    private boolean changeZ = false;
    private ForgeChunkManager.Ticket chunkTicket;
    public double headPosX;
    public double headPosY;
    public double headPosZ;
    private boolean initialized = true;
    private Mode now = Mode.NONE;

    @Override
    protected Symbol getSymbol() {
        return SYMBOL;
    }

    protected void S_updateEntity() {
        if (this.machineDisabled) {
            return;
        }
        if (this.areaProvider != null) {
            if (this.areaProvider instanceof TileMarker) {
                this.cacheItems.addAll(((TileMarker)this.areaProvider).removeFromWorldWithItem());
            }
            this.areaProvider = null;
        }
        switch (this.now) {
            case MAKEFRAME: {
                if (!this.S_makeFrame()) break;
                while (!this.S_checkTarget()) {
                    this.S_setNextTarget();
                }
                break;
            }
            case MOVEHEAD: {
                boolean done = this.S_moveHead();
                MoveHead.send(this);
                if (!done) break;
                this.setNow(Mode.BREAKBLOCK);
            }
            case NOTNEEDBREAK: 
            case BREAKBLOCK: {
                if (!this.S_breakBlock()) break;
                while (!this.S_checkTarget()) {
                    this.S_setNextTarget();
                }
                break;
            }
        }
        this.S_pollItems();
    }

    private boolean S_checkTarget() {
        if (this.targetY > this.yMax) {
            this.targetY = this.yMax;
        }
        BlockPos target = new BlockPos(this.targetX, this.targetY, this.targetZ);
        Chunk loadedChunk = this.func_145831_w().func_72863_F().func_186026_b(this.targetX >> 4, this.targetZ >> 4);
        IBlockState b = loadedChunk != null ? loadedChunk.func_177435_g(target) : this.func_145831_w().func_180495_p(target);
        float blockHardness = b.func_185887_b(this.func_145831_w(), target);
        switch (this.now) {
            case MOVEHEAD: 
            case BREAKBLOCK: {
                if (this.targetY < 1) {
                    this.G_destroy();
                    PacketHandler.sendToAround(ModeMessage.create(this), this.func_145831_w(), this.func_174877_v());
                    return true;
                }
                return blockHardness >= 0.0f && !b.func_177230_c().isAir(b, (IBlockAccess)this.func_145831_w(), target) && (this.pump != null || !TilePump.isLiquid(b));
            }
            case NOTNEEDBREAK: {
                if (this.targetY < this.yMin) {
                    if (this.filler) {
                        this.G_destroy();
                        return true;
                    }
                    this.setNow(Mode.MAKEFRAME);
                    this.G_renew_powerConfigure();
                    this.targetX = this.xMin;
                    this.targetY = this.yMax;
                    this.targetZ = this.zMin;
                    this.digged = true;
                    this.addZ = true;
                    this.addX = true;
                    this.changeZ = false;
                    return this.S_checkTarget();
                }
                if (blockHardness < 0.0f || b.func_177230_c().isAir(b, (IBlockAccess)this.func_145831_w(), target)) {
                    return false;
                }
                if (this.pump == null && TilePump.isLiquid(b)) {
                    return false;
                }
                if (b.func_177230_c() == QuarryPlusI.blockFrame() && !((Boolean)b.func_177229_b((IProperty)BlockFrame.DAMMING)).booleanValue()) {
                    int flag = 0;
                    if (this.targetX == this.xMin || this.targetX == this.xMax) {
                        flag = (byte)(flag + 1);
                    }
                    if (this.targetY == this.yMin || this.targetY == this.yMax) {
                        flag = (byte)(flag + 1);
                    }
                    if (this.targetZ == this.zMin || this.targetZ == this.zMax) {
                        flag = (byte)(flag + 1);
                    }
                    return flag <= 1;
                }
                return true;
            }
            case MAKEFRAME: {
                if (this.targetY < this.yMin) {
                    this.setNow(Mode.MOVEHEAD);
                    this.G_renew_powerConfigure();
                    this.targetX = this.xMin + 1;
                    this.targetY = this.yMin;
                    this.targetZ = this.zMin + 1;
                    this.digged = true;
                    this.addZ = true;
                    this.addX = true;
                    this.changeZ = false;
                    return this.S_checkTarget();
                }
                if (b.func_185904_a().func_76220_a() && (b.func_177230_c() != QuarryPlusI.blockFrame() || ((Boolean)b.func_177229_b((IProperty)BlockFrame.DAMMING)).booleanValue())) {
                    this.setNow(Mode.NOTNEEDBREAK);
                    this.G_renew_powerConfigure();
                    this.targetX = this.xMin;
                    this.targetZ = this.zMin;
                    this.targetY = this.yMax;
                    this.digged = true;
                    this.addZ = true;
                    this.addX = true;
                    this.changeZ = false;
                    return this.S_checkTarget();
                }
                int flag = 0;
                if (this.targetX == this.xMin || this.targetX == this.xMax) {
                    flag = (byte)(flag + 1);
                }
                if (this.targetY == this.yMin || this.targetY == this.yMax) {
                    flag = (byte)(flag + 1);
                }
                if (this.targetZ == this.zMin || this.targetZ == this.zMax) {
                    flag = (byte)(flag + 1);
                }
                return flag > 1 && (b.func_177230_c() != QuarryPlusI.blockFrame() || (Boolean)b.func_177229_b((IProperty)BlockFrame.DAMMING) != false);
            }
        }
        return true;
    }

    private void S_setNextTarget() {
        if (this.now == Mode.MAKEFRAME) {
            if (this.changeZ) {
                this.targetZ = this.addZ ? ++this.targetZ : --this.targetZ;
            } else {
                this.targetX = this.addX ? ++this.targetX : --this.targetX;
            }
            if (this.targetX < this.xMin || this.xMax < this.targetX) {
                this.addX = !this.addX;
                this.changeZ = true;
                this.targetX = Math.max(this.xMin, Math.min(this.xMax, this.targetX));
            }
            if (this.targetZ < this.zMin || this.zMax < this.targetZ) {
                this.addZ = !this.addZ;
                this.changeZ = false;
                this.targetZ = Math.max(this.zMin, Math.min(this.zMax, this.targetZ));
            }
            if (this.xMin == this.targetX && this.zMin == this.targetZ) {
                if (this.digged) {
                    this.digged = false;
                } else {
                    --this.targetY;
                }
            }
        } else {
            int out;
            this.targetX = this.addX ? ++this.targetX : --this.targetX;
            int n = out = this.now == Mode.NOTNEEDBREAK ? 0 : 1;
            if (this.targetX < this.xMin + out || this.xMax - out < this.targetX) {
                this.addX = !this.addX;
                this.targetX = Math.max(this.xMin + out, Math.min(this.targetX, this.xMax - out));
                this.targetZ = this.addZ ? ++this.targetZ : --this.targetZ;
                if (this.targetZ < this.zMin + out || this.zMax - out < this.targetZ) {
                    this.addZ = !this.addZ;
                    this.targetZ = Math.max(this.zMin + out, Math.min(this.targetZ, this.zMax - out));
                    if (this.digged) {
                        this.digged = false;
                    } else {
                        double dd;
                        double da;
                        double ad;
                        --this.targetY;
                        double aa = this.S_getDistance(this.xMin + 1, this.targetY, this.zMin + out);
                        double res = Math.min(aa, Math.min(ad = this.S_getDistance(this.xMin + 1, this.targetY, this.zMax - out), Math.min(da = this.S_getDistance(this.xMax - 1, this.targetY, this.zMin + out), dd = this.S_getDistance(this.xMax - 1, this.targetY, this.zMax - out))));
                        if (res == aa) {
                            this.addX = true;
                            this.addZ = true;
                            this.targetX = this.xMin + out;
                            this.targetZ = this.zMin + out;
                        } else if (res == ad) {
                            this.addX = true;
                            this.addZ = false;
                            this.targetX = this.xMin + out;
                            this.targetZ = this.zMax - out;
                        } else if (res == da) {
                            this.addX = false;
                            this.addZ = true;
                            this.targetX = this.xMax - out;
                            this.targetZ = this.zMin + out;
                        } else if (res == dd) {
                            this.addX = false;
                            this.addZ = false;
                            this.targetX = this.xMax - out;
                            this.targetZ = this.zMax - out;
                        }
                    }
                }
            }
        }
    }

    private double S_getDistance(int x, int y, int z) {
        return Math.sqrt(Math.pow((double)x - this.headPosX, 2.0) + Math.pow((double)(y + 1) - this.headPosY, 2.0) + Math.pow((double)z - this.headPosZ, 2.0));
    }

    private boolean S_makeFrame() {
        this.digged = true;
        if (!PowerManager.useEnergyFrameBuild(this, this.unbreaking)) {
            return false;
        }
        this.func_145831_w().func_175656_a(new BlockPos(this.targetX, this.targetY, this.targetZ), QuarryPlusI.blockFrame().func_176223_P());
        this.S_setNextTarget();
        return true;
    }

    private boolean S_breakBlock() {
        this.digged = true;
        if (this.S_breakBlock(this.targetX, this.targetY, this.targetZ)) {
            this.S_checkDropItem();
            if (this.now == Mode.BREAKBLOCK) {
                this.setNow(Mode.MOVEHEAD);
            }
            this.S_setNextTarget();
            return true;
        }
        return false;
    }

    private void S_checkDropItem() {
        AxisAlignedBB axis = new AxisAlignedBB((double)(this.targetX - 4), (double)(this.targetY - 4), (double)(this.targetZ - 4), (double)(this.targetX + 5), (double)(this.targetY + 3), (double)(this.targetZ + 5));
        List result = this.func_145831_w().func_72872_a(EntityItem.class, axis);
        for (EntityItem entityItem : result) {
            ItemStack drop;
            if (entityItem.field_70128_L || !VersionUtil.nonEmpty(drop = entityItem.func_92059_d())) continue;
            QuarryPlus.proxy.removeEntity((Entity)entityItem);
            this.cacheItems.add(drop);
        }
        if (this.exppump != null) {
            List xpOrbs = this.func_145831_w().func_72872_a(EntityXPOrb.class, axis);
            for (EntityXPOrb xpOrb : xpOrbs) {
                TileExpPump t;
                double min;
                TileEntity tileEntity;
                if (xpOrb.field_70128_L || !((tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.exppump))) instanceof TileExpPump) || this.useEnergy(min = (t = (TileExpPump)tileEntity).getEnergyUse(xpOrb.field_70530_e), min, false, EnergyUsage.PUMP_EXP) != min) continue;
                this.useEnergy(min, min, true, EnergyUsage.PUMP_EXP);
                t.addXp(xpOrb.field_70530_e);
                QuarryPlus.proxy.removeEntity((Entity)xpOrb);
            }
        }
    }

    private void S_createBox() {
        if (this.yMax != Integer.MIN_VALUE) {
            return;
        }
        EnumFacing facing = ((EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockQuarry.FACING)).func_176734_d();
        Optional<TileMarker> marker = Stream.of(this.getNeighbors(facing)).map(arg_0 -> ((World)this.func_145831_w()).func_175625_s(arg_0)).filter(t -> t instanceof TileMarker).map(t -> (TileMarker)t).findFirst();
        if (marker.isPresent()) {
            TileMarker tileMarker = marker.get();
            if (tileMarker.link == null) {
                this.setDefaultRange(this.func_174877_v(), facing);
            } else {
                this.xMin = tileMarker.min().func_177958_n();
                this.yMin = tileMarker.min().func_177956_o();
                this.zMin = tileMarker.min().func_177952_p();
                this.xMax = tileMarker.max().func_177958_n();
                this.yMax = tileMarker.max().func_177956_o();
                this.zMax = tileMarker.max().func_177952_p();
                if (this.func_174877_v().func_177958_n() >= this.xMin && this.func_174877_v().func_177958_n() <= this.xMax && this.func_174877_v().func_177956_o() >= this.yMin && this.func_174877_v().func_177956_o() <= this.yMax && this.func_174877_v().func_177952_p() >= this.zMin && this.func_174877_v().func_177952_p() <= this.zMax) {
                    this.yMax = Integer.MIN_VALUE;
                    this.setDefaultRange(this.func_174877_v(), facing);
                    return;
                }
                if (this.xMax - this.xMin < 2 || this.zMax - this.zMin < 2) {
                    this.yMax = Integer.MIN_VALUE;
                    this.setDefaultRange(this.func_174877_v(), facing);
                    return;
                }
                if (this.yMax - this.yMin < 2) {
                    this.yMax = this.yMin + 3;
                }
                this.areaProvider = tileMarker;
            }
        } else {
            this.setDefaultRange(this.func_174877_v(), facing);
        }
    }

    public void setDefaultRange(BlockPos pos, EnumFacing facing) {
        int x = 11;
        int y = (x - 1) / 2;
        pos = pos.func_177972_a(facing);
        BlockPos pos1 = pos.func_177972_a(facing);
        BlockPos pos2 = pos.func_177967_a(facing, x);
        BlockPos pos3 = pos.func_177967_a(facing.func_176746_e(), y);
        BlockPos pos4 = pos.func_177967_a(facing.func_176735_f(), y);
        if (facing.func_176740_k() == EnumFacing.Axis.X) {
            this.xMin = Math.min(pos1.func_177958_n(), pos2.func_177958_n());
            this.xMax = Math.max(pos1.func_177958_n(), pos2.func_177958_n());
            this.zMin = Math.min(pos3.func_177952_p(), pos4.func_177952_p());
            this.zMax = Math.max(pos3.func_177952_p(), pos4.func_177952_p());
        } else if (facing.func_176740_k() == EnumFacing.Axis.Z) {
            this.xMin = Math.min(pos3.func_177958_n(), pos4.func_177958_n());
            this.xMax = Math.max(pos3.func_177958_n(), pos4.func_177958_n());
            this.zMin = Math.min(pos1.func_177952_p(), pos2.func_177952_p());
            this.zMax = Math.max(pos1.func_177952_p(), pos2.func_177952_p());
        }
        this.yMin = this.func_174877_v().func_177956_o();
        this.yMax = this.func_174877_v().func_177956_o() + 3;
    }

    private void S_setFirstPos() {
        this.targetX = this.xMin;
        this.targetZ = this.zMin;
        this.targetY = this.yMax;
        this.headPosX = this.xMin + this.xMax + 1 >> 1;
        this.headPosZ = this.zMin + this.zMax + 1 >> 1;
        this.headPosY = this.yMax - 1;
    }

    private boolean S_moveHead() {
        double x = (double)this.targetX - this.headPosX;
        double y = (double)(this.targetY + 1) - this.headPosY;
        double z = (double)this.targetZ - this.headPosZ;
        double distance = Math.sqrt(x * x + y * y + z * z);
        double blocks = PowerManager.useEnergyQuarryHead(this, distance, this.unbreaking);
        if (blocks * 2.0 >= distance) {
            this.headPosX = this.targetX;
            this.headPosY = this.targetY + 1;
            this.headPosZ = this.targetZ;
            return true;
        }
        if (blocks > 0.0) {
            this.headPosX += x * blocks / distance;
            this.headPosY += y * blocks / distance;
            this.headPosZ += z * blocks / distance;
        }
        return false;
    }

    public Mode G_getNow() {
        return this.now;
    }

    public void setNow(Mode now) {
        this.now = now;
        if (!this.func_145831_w().field_72995_K) {
            PacketHandler.sendToAround(ModeMessage.create(this), this.func_145831_w(), this.func_174877_v());
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            if (((Boolean)state.func_177229_b((IProperty)BlockQuarry.ACTING)).booleanValue()) {
                if (now == Mode.NONE) {
                    this.func_145829_t();
                    this.func_145831_w().func_175656_a(this.func_174877_v(), state.func_177226_a((IProperty)BlockQuarry.ACTING, (Comparable)Boolean.valueOf(false)));
                    this.func_145829_t();
                    this.func_145831_w().func_175690_a(this.func_174877_v(), (TileEntity)this);
                    this.finishWork();
                }
            } else if (now != Mode.NONE) {
                this.func_145829_t();
                this.func_145831_w().func_175656_a(this.func_174877_v(), state.func_177226_a((IProperty)BlockQuarry.ACTING, (Comparable)Boolean.valueOf(true)));
                this.func_145829_t();
                this.func_145831_w().func_175690_a(this.func_174877_v(), (TileEntity)this);
                this.startWork();
            }
        }
    }

    public BlockPos getMinPos() {
        return new BlockPos(this.xMin, this.yMin, this.zMin);
    }

    public BlockPos getMaxPos() {
        return new BlockPos(this.xMax, this.yMax, this.zMax);
    }

    @Override
    protected void G_destroy() {
        this.setNow(Mode.NONE);
        this.G_renew_powerConfigure();
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
    }

    @Override
    public void G_reinit() {
        if (this.yMax == Integer.MIN_VALUE && !this.func_145831_w().field_72995_K) {
            this.S_createBox();
        }
        this.setNow(Mode.NOTNEEDBREAK);
        this.G_renew_powerConfigure();
        if (!this.func_145831_w().field_72995_K) {
            this.S_setFirstPos();
            PacketHandler.sendToAround(TileMessage.create(this), this.func_145831_w(), this.func_174877_v());
        }
    }

    @Override
    public void requestTicket() {
        if (this.chunkTicket != null) {
            return;
        }
        this.chunkTicket = ForgeChunkManager.requestTicket((Object)QuarryPlus.INSTANCE, (World)this.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (this.chunkTicket == null) {
            return;
        }
        NBTTagCompound tag = this.chunkTicket.getModData();
        tag.func_74768_a("quarryX", this.func_174877_v().func_177958_n());
        tag.func_74768_a("quarryY", this.func_174877_v().func_177956_o());
        tag.func_74768_a("quarryZ", this.func_174877_v().func_177952_p());
        this.forceChunkLoading(this.chunkTicket);
    }

    @Override
    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        if (this.chunkTicket == null) {
            this.chunkTicket = ticket;
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(this.func_174877_v()));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.initialized) {
            this.G_renew_powerConfigure();
            this.initialized = true;
        }
        if (!this.func_145831_w().field_72995_K) {
            this.S_updateEntity();
        }
    }

    @Override
    protected boolean isWorking() {
        return this.now != Mode.NONE;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttc) {
        super.func_145839_a(nbttc);
        this.xMin = nbttc.func_74762_e("xMin");
        this.xMax = nbttc.func_74762_e("xMax");
        this.yMin = nbttc.func_74762_e("yMin");
        this.zMin = nbttc.func_74762_e("zMin");
        this.zMax = nbttc.func_74762_e("zMax");
        this.yMax = nbttc.func_74762_e("yMax");
        this.targetX = nbttc.func_74762_e("targetX");
        this.targetY = nbttc.func_74762_e("targetY");
        this.targetZ = nbttc.func_74762_e("targetZ");
        this.addZ = nbttc.func_74767_n("addZ");
        this.addX = nbttc.func_74767_n("addX");
        this.digged = nbttc.func_74767_n("digged");
        this.changeZ = nbttc.func_74767_n("changeZ");
        this.now = Mode.values()[nbttc.func_74771_c("now")];
        this.headPosX = nbttc.func_74769_h("headPosX");
        this.headPosY = nbttc.func_74769_h("headPosY");
        this.headPosZ = nbttc.func_74769_h("headPosZ");
        this.filler = nbttc.func_74767_n("filler");
        this.initialized = false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttc) {
        nbttc.func_74768_a("xMin", this.xMin);
        nbttc.func_74768_a("xMax", this.xMax);
        nbttc.func_74768_a("yMin", this.yMin);
        nbttc.func_74768_a("yMax", this.yMax);
        nbttc.func_74768_a("zMin", this.zMin);
        nbttc.func_74768_a("zMax", this.zMax);
        nbttc.func_74768_a("targetX", this.targetX);
        nbttc.func_74768_a("targetY", this.targetY);
        nbttc.func_74768_a("targetZ", this.targetZ);
        nbttc.func_74757_a("addZ", this.addZ);
        nbttc.func_74757_a("addX", this.addX);
        nbttc.func_74757_a("digged", this.digged);
        nbttc.func_74757_a("changeZ", this.changeZ);
        nbttc.func_74774_a("now", (byte)this.now.ordinal());
        nbttc.func_74780_a("headPosX", this.headPosX);
        nbttc.func_74780_a("headPosY", this.headPosY);
        nbttc.func_74780_a("headPosZ", this.headPosZ);
        nbttc.func_74757_a("filler", this.filler);
        return super.func_189515_b(nbttc);
    }

    @Override
    public String getDebugName() {
        return "tile.quarryplus.name";
    }

    @Override
    public String func_70005_c_() {
        return this.getDebugName();
    }

    @Override
    public void G_renew_powerConfigure() {
        TileEntity entity;
        int pmp = 0;
        if (this.hasWorld() && this.pump != null) {
            TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(this.pump));
            if (te instanceof TilePump) {
                pmp = ((TilePump)te).unbreaking;
            } else {
                this.pump = null;
            }
        }
        if (this.hasWorld() && this.exppump != null && !((entity = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(this.exppump))) instanceof TileExpPump)) {
            this.exppump = null;
        }
        if (this.now == Mode.NONE) {
            PowerManager.configure0(this);
        } else if (this.now == Mode.MAKEFRAME) {
            PowerManager.configureFrameBuild(this, this.efficiency, this.unbreaking, pmp);
        } else {
            PowerManager.configureQuarryWork(this, this.efficiency, this.unbreaking, pmp);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.yMax == Integer.MIN_VALUE) {
            return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), Double.NEGATIVE_INFINITY, (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
        }
        double xn = (double)this.xMin + 0.46875;
        double xx = (double)this.xMax + 0.53125;
        double yx = (double)this.yMax + 0.75;
        double zn = (double)this.zMin + 0.46875;
        double zx = (double)this.zMax + 0.53125;
        double x1 = xn < (double)this.func_174877_v().func_177958_n() ? xn : (double)this.func_174877_v().func_177958_n();
        double x2 = xx > (double)(this.func_174877_v().func_177958_n() + 1) ? xx : (double)(this.func_174877_v().func_177958_n() + 1);
        double y2 = (double)(this.func_174877_v().func_177956_o() + 1) < yx ? yx : (double)(this.func_174877_v().func_177956_o() + 1);
        double z1 = zn < (double)this.func_174877_v().func_177952_p() ? zn : (double)this.func_174877_v().func_177952_p();
        double z2 = zx > (double)(this.func_174877_v().func_177952_p() + 1) ? zx : (double)(this.func_174877_v().func_177952_p() + 1);
        return new AxisAlignedBB(x1, Double.NEGATIVE_INFINITY, z1, x2, y2, z2);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        if ((this.now == Mode.NOTNEEDBREAK || this.now == Mode.MAKEFRAME) && this.yMax != Integer.MIN_VALUE) {
            return (this.xMax - this.xMin) * (this.xMax - this.xMin) + 25 + (this.zMax - this.zMin) * (this.zMax - this.zMin);
        }
        if (this.now == Mode.BREAKBLOCK || this.now == Mode.MOVEHEAD) {
            return (this.xMax - this.xMin) * (this.xMax - this.xMin) + this.yMax * this.yMax + (this.zMax - this.zMin) * (this.zMax - this.zMin);
        }
        return super.func_145833_n();
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public List<ITextComponent> getDebugmessages() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new TextComponentTranslation("chat.currentmode", new Object[]{this.G_getNow()}));
        list.add((ITextComponent)new TextComponentString(String.format("Next target : (%d, %d, %d)", this.targetX, this.targetY, this.targetZ)));
        list.add((ITextComponent)new TextComponentString(String.format("Head Pos : (%s, %s, %s)", this.headPosX, this.headPosY, this.headPosZ)));
        list.add((ITextComponent)new TextComponentString("X : " + this.xMin + " to " + this.xMax));
        list.add((ITextComponent)new TextComponentString("Z : " + this.zMin + " to " + this.zMax));
        list.add((ITextComponent)new TextComponentTranslation(this.filler ? "chat.fillermode" : "chat.quarrymode", new Object[0]));
        return list;
    }

    public static enum Mode {
        NONE,
        NOTNEEDBREAK,
        MAKEFRAME,
        MOVEHEAD,
        BREAKBLOCK;

    }
}

