/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import com.yogpc.qp.Config;
import com.yogpc.qp.PowerManager;
import com.yogpc.qp.compat.INBTWritable;
import com.yogpc.qp.item.ItemQuarryDebug;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.TileMessage;
import com.yogpc.qp.packet.distiller.AnimatonMessage;
import com.yogpc.qp.tile.APowerTile;
import com.yogpc.qp.tile.IEnchantableTile;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scala.Symbol;

public class TileRefinery
extends APowerTile
implements IEnchantableTile {
    public static final Symbol SYMBOL = Symbol.apply((String)"RefineryPlus");
    public final DistillerTank horizontalsTank = new DistillerTank("horizontalsTank");
    public final DistillerTank upTank = new DistillerTank("upTank");
    public final DistillerTank downTank = new DistillerTank("downTank");
    private final List<DistillerTank> tanks = Arrays.asList(this.horizontalsTank, this.upTank, this.downTank);
    private final IFluidHandler fluidHandler = () -> {
        IFluidTankProperties[] iFluidTankPropertiesArray;
        IFluidTankProperties[] array = (IFluidTankProperties[])this.tanks.stream().flatMap(distillerTank -> Stream.of(distillerTank.getTankProperties())).toArray(IFluidTankProperties[]::new);
        if (array.length == 0) {
            IFluidTankProperties[] iFluidTankPropertiesArray2 = new IFluidTankProperties[1];
            iFluidTankPropertiesArray = iFluidTankPropertiesArray2;
            iFluidTankPropertiesArray2[0] = new FluidTankProperties(null, this.horizontalsTank.getCapacity(), false, false);
        } else {
            iFluidTankPropertiesArray = array;
        }
        return iFluidTankPropertiesArray;
    };
    public long rem_energy;
    public FluidStack cacheIn;
    public FluidStack cachedGas;
    public FluidStack cachedLiqud;
    public long cacheEnergy;
    private DEnch ench = DEnch.access$000();
    public float animationSpeed = 1.0f;
    private int animationStage = 0;

    public TileRefinery() {
        this.horizontalsTank.setCanDrain(false);
        if (this.machineDisabled) {
            this.horizontalsTank.predicate = fluidStack -> false;
        }
        this.upTank.setCanFill(false);
        this.downTank.setCanFill(false);
    }

    @Override
    protected Symbol getSymbol() {
        return SYMBOL;
    }

    @Override
    public void G_reinit() {
        PowerManager.configureRefinery(this, this.ench.efficiency, this.ench.unbreaking);
        this.tanks.forEach(distillerTank -> distillerTank.setCapacity(this.ench.getCapacity()));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttc) {
        super.func_145839_a(nbttc);
        this.ench = DEnch.readFromNBT(nbttc);
        this.horizontalsTank.readFromNBT(nbttc);
        this.upTank.readFromNBT(nbttc);
        this.downTank.readFromNBT(nbttc);
        this.updateRecipe();
        this.rem_energy = nbttc.func_74763_f("rem_energy");
        this.animationSpeed = nbttc.func_74760_g("animationSpeed");
        this.animationStage = nbttc.func_74762_e("animationStage");
        PowerManager.configureRefinery(this, this.ench.efficiency, this.ench.unbreaking);
        this.tanks.forEach(distillerTank -> distillerTank.setCapacity(this.ench.getCapacity()));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttc) {
        this.ench.writeToNBT(nbttc);
        this.horizontalsTank.writeToNBT(nbttc);
        this.upTank.writeToNBT(nbttc);
        this.downTank.writeToNBT(nbttc);
        nbttc.func_74772_a("rem_energy", this.rem_energy);
        nbttc.func_74776_a("animationSpeed", this.animationSpeed);
        nbttc.func_74768_a("animationStage", this.animationStage);
        return super.func_189515_b(nbttc);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.bcLoaded || this.machineDisabled) {
            return;
        }
        if (this.func_145831_w().field_72995_K) {
            this.simpleAnimationIterate();
            return;
        }
        if (this.func_145831_w().func_82737_E() % 20L == 7L) {
            PacketHandler.sendToAround(TileMessage.create(this), this.func_145831_w(), this.func_174877_v());
        }
        if (this.cachedGas == null || this.cachedLiqud == null) {
            this.decreaseAnimation();
            return;
        }
        double v = 0.0;
        if (this.cacheIn == null || !Config.content().noEnergy() && this.getStoredEnergy() < v || !PowerManager.useEnergyRefinery(this, v, this.ench.unbreaking, this.ench.efficiency)) {
            this.decreaseAnimation();
        } else {
            this.increaseAnimation();
            FluidStack inStack = this.horizontalsTank.drainInternal(this.cacheIn.amount, false);
            int gas = this.upTank.fillInternal(this.cachedGas, false);
            int liquid = this.downTank.fillInternal(this.cachedLiqud, false);
            if (inStack != null && inStack.amount > 0 && gas > 0 && liquid > 0) {
                this.horizontalsTank.drainInternal(this.cacheIn.amount, true);
                this.upTank.fillInternal(this.cachedGas, true);
                this.downTank.fillInternal(this.cachedLiqud, true);
                this.cacheIn = null;
                this.cachedGas = null;
                this.cachedLiqud = null;
                this.cacheEnergy = 0L;
                this.updateRecipe();
            }
            this.decreaseAnimation();
        }
    }

    @Override
    protected boolean isWorking() {
        return this.cacheEnergy > 0L;
    }

    private void updateRecipe() {
    }

    public int getAnimationStage() {
        return this.animationStage;
    }

    private void simpleAnimationIterate() {
        if (this.animationSpeed > 1.0f) {
            this.animationStage = (int)((float)this.animationStage + this.animationSpeed);
            if (this.animationStage > 300) {
                this.animationStage = 100;
            }
        } else if (this.animationStage > 0) {
            --this.animationStage;
        }
    }

    private void sendNowPacket() {
        PacketHandler.sendToAround(AnimatonMessage.create(this), this.func_145831_w(), this.func_174877_v());
    }

    private void increaseAnimation() {
        float prev = this.animationSpeed;
        if (this.animationSpeed < 2.0f) {
            this.animationSpeed = 2.0f;
        } else if (this.animationSpeed <= 5.0f) {
            this.animationSpeed = (float)((double)this.animationSpeed + 0.1);
        }
        this.animationStage = (int)((float)this.animationStage + this.animationSpeed);
        if (this.animationStage > 300) {
            this.animationStage = 100;
        }
        if (this.animationSpeed != prev) {
            this.sendNowPacket();
        }
    }

    private void decreaseAnimation() {
        float prev = this.animationSpeed;
        if (this.animationSpeed >= 1.0f) {
            this.animationSpeed = (float)((double)this.animationSpeed - 0.1);
            this.animationStage = (int)((float)this.animationStage + this.animationSpeed);
            if (this.animationStage > 300) {
                this.animationStage = 100;
            }
        } else if (this.animationStage > 0) {
            --this.animationStage;
        }
        if (this.animationSpeed != prev) {
            this.sendNowPacket();
        }
    }

    @Override
    public Map<Integer, Integer> getEnchantments() {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        if (this.ench.efficiency > 0) {
            ret.put(EfficiencyID, Integer.valueOf(this.ench.efficiency));
        }
        if (this.ench.fortune > 0) {
            ret.put(FortuneID, Integer.valueOf(this.ench.fortune));
        }
        if (this.ench.unbreaking > 0) {
            ret.put(UnbreakingID, Integer.valueOf(this.ench.unbreaking));
        }
        if (this.ench.silktouch) {
            ret.put(SilktouchID, 1);
        }
        return ret;
    }

    @Override
    public void setEnchantent(short id, short val) {
        this.ench = this.ench.copy(id, val);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            Object handler = facing == null ? this.fluidHandler : (facing == EnumFacing.DOWN ? this.downTank : (facing == EnumFacing.UP ? this.upTank : this.horizontalsTank));
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast(handler);
        }
        return super.getCapability(capability, facing);
    }

    public boolean hasFastRenderer() {
        return true;
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add(this.getClass().getName());
        left.add(ItemQuarryDebug.tileposToString(this).func_150265_g());
        left.add(ItemQuarryDebug.energyToString(this).func_150265_g());
        if (this.cacheIn != null) {
            left.add("InputRecipe : " + this.cacheIn.getFluid().getName());
        }
        if (this.cachedGas != null) {
            left.add("OutGas : " + this.cachedGas.getFluid().getName());
        }
        if (this.cachedLiqud != null) {
            left.add("OutLiquid : " + this.cachedLiqud.getFluid().getName());
        }
    }

    public void getClientDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        right.add("AnimationStage : " + this.animationStage);
        right.add("AnimationSpeed : " + this.animationSpeed);
    }

    @SideOnly(value=Side.CLIENT)
    public Runnable receiveMessage(int stage, float speed) {
        return () -> {
            this.animationStage = stage;
            this.animationSpeed = speed;
        };
    }

    private static class DEnch
    implements INBTWritable {
        private static final String NBT_DEnch = "dench";
        private static final DEnch defaultEnch = new DEnch(0, 0, 0, false);
        private static final int[] CAPACITIES = new int[]{4000, 5200, 6760, 8788};
        private final byte efficiency;
        private final byte unbreaking;
        private final byte fortune;
        private final boolean silktouch;

        public DEnch(int efficiency, int unbreaking, int fortune, boolean silktouch) {
            this.efficiency = (byte)efficiency;
            this.unbreaking = (byte)unbreaking;
            this.fortune = (byte)fortune;
            this.silktouch = silktouch;
        }

        public int getCapacity() {
            if (this.fortune >= 3) {
                return CAPACITIES[3];
            }
            return CAPACITIES[this.fortune];
        }

        public DEnch copy(short id, short val) {
            if (id == IEnchantableTile.EfficiencyID) {
                return new DEnch(val, this.unbreaking, this.fortune, this.silktouch);
            }
            if (id == IEnchantableTile.FortuneID) {
                return new DEnch(this.efficiency, this.unbreaking, val, this.silktouch);
            }
            if (id == IEnchantableTile.UnbreakingID) {
                return new DEnch(this.efficiency, val, this.fortune, this.silktouch);
            }
            if (id == IEnchantableTile.SilktouchID) {
                return new DEnch(this.efficiency, this.unbreaking, this.fortune, val > 0);
            }
            return this;
        }

        @Override
        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            NBTTagCompound t = new NBTTagCompound();
            t.func_74774_a("efficiency", this.efficiency);
            t.func_74774_a("unbreaking", this.unbreaking);
            t.func_74774_a("fortune", this.fortune);
            t.func_74757_a("silktouch", this.silktouch);
            nbt.func_74782_a(NBT_DEnch, (NBTBase)t);
            return null;
        }

        public static DEnch readFromNBT(NBTTagCompound compound) {
            if (compound.func_74764_b(NBT_DEnch)) {
                NBTTagCompound t = compound.func_74775_l(NBT_DEnch);
                return new DEnch(t.func_74771_c("efficiency"), t.func_74771_c("unbreaking"), t.func_74771_c("fortune"), t.func_74767_n("silktouch"));
            }
            return defaultEnch;
        }

        public String toString() {
            return String.format("DEnch %d, %d, %d, %s", this.efficiency, this.unbreaking, this.fortune, this.silktouch);
        }

        static /* synthetic */ DEnch access$000() {
            return defaultEnch;
        }
    }

    public class DistillerTank
    extends FluidTank {
        private final String name;
        private Predicate<FluidStack> predicate;

        public DistillerTank(String name) {
            super(4000);
            this.predicate = fluidStack -> false;
            this.name = name;
        }

        public int fillInternal(FluidStack resource, boolean doFill) {
            int i = super.fillInternal(resource, doFill);
            if (doFill) {
                TileRefinery.this.updateRecipe();
            }
            return i;
        }

        @Nullable
        public FluidStack drainInternal(int maxDrain, boolean doDrain) {
            FluidStack stack = super.drainInternal(maxDrain, doDrain);
            if (doDrain) {
                TileRefinery.this.updateRecipe();
            }
            return stack;
        }

        public DistillerTank readFromNBT(NBTTagCompound nbt) {
            super.readFromNBT(nbt.func_74775_l(this.name));
            return this;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            NBTTagCompound compound = new NBTTagCompound();
            super.writeToNBT(compound);
            nbt.func_74782_a(this.name, (NBTBase)compound);
            return nbt;
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return this.predicate.test(fluid) && super.canFillFluidType(fluid);
        }

        public String toString() {
            return this.name + " " + Optional.ofNullable(this.fluid).map(s -> s.getFluid().getName() + " : " + s.amount).orElse("None");
        }

        public double getAA(double d) {
            if (this.fluid == null) {
                return 0.0;
            }
            int i = this.fluid.getFluid().isGaseous() ? -1 : 1;
            return (double)this.getFluidAmount() / (double)this.getCapacity() * d * (double)i;
        }
    }
}

