/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import com.yogpc.qp.Config;
import com.yogpc.qp.block.BlockSolidQuarry;
import com.yogpc.qp.tile.TileQuarry;
import com.yogpc.qp.version.VersionUtil;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import scala.Symbol;

public class TileSolidQuarry
extends TileQuarry {
    private static final double fuelEfficiency = 4.0;
    @Nullable
    private ItemStack fuel = VersionUtil.empty();
    private int fuelCount = 0;

    @Override
    public boolean canReceive() {
        return false;
    }

    @Override
    protected void S_updateEntity() {
        if (this.machineDisabled) {
            return;
        }
        if (this.fuelCount > 0) {
            --this.fuelCount;
            this.getEnergy(4.0, true);
        } else {
            int burn = TileEntityFurnace.func_145952_a((ItemStack)this.fuel) / 5;
            if (burn > 0) {
                this.fuelCount += burn;
                this.func_70298_a(0, 1);
            }
        }
        super.S_updateEntity();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttc) {
        super.func_145839_a(nbttc);
        this.fuelCount = nbttc.func_74762_e("fuelCount");
        this.fuel = VersionUtil.fromNBTTag(nbttc.func_74775_l("fuel"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttc) {
        nbttc.func_74768_a("fuelCount", this.fuelCount);
        nbttc.func_74782_a("fuel", (NBTBase)Optional.ofNullable(this.fuel).map(ItemStack::serializeNBT).orElse(new NBTTagCompound()));
        return super.func_189515_b(nbttc);
    }

    @Override
    protected Symbol getSymbol() {
        return BlockSolidQuarry.SYMBOL;
    }

    @Override
    public String getDebugName() {
        return "tile.solidquarry.name";
    }

    @Override
    public String func_70005_c_() {
        return "tile.solidquarry.name";
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this;
    }

    @Override
    public int func_70302_i_() {
        return 2;
    }

    @Override
    public ItemStack func_70301_a(int i) {
        if (i == 0) {
            return this.fuel;
        }
        return super.func_70301_a(i - 1);
    }

    @Override
    public ItemStack func_70304_b(int index) {
        if (index == 0) {
            ItemStack temp = this.fuel;
            this.fuel = VersionUtil.empty();
            return temp;
        }
        return super.func_70304_b(index - 1);
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        if (index == 0) {
            this.fuel = stack;
        } else {
            super.func_70299_a(index - 1, stack);
        }
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        if (index == 0) {
            if (VersionUtil.getCount(this.fuel) <= count) {
                return this.func_70304_b(0);
            }
            return Optional.ofNullable(this.fuel).map(s -> s.func_77979_a(count)).orElse(VersionUtil.empty());
        }
        return super.func_70298_a(index - 1, count);
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && TileEntityFurnace.func_145954_b((ItemStack)stack);
    }

    @Override
    public void func_174888_l() {
        this.fuel = VersionUtil.empty();
        super.func_174888_l();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && VersionUtil.isEmpty(this.fuel);
    }

    @Override
    protected boolean isWorking() {
        return super.isWorking() && (this.fuelCount > 0 || VersionUtil.nonEmpty(this.fuel) || Config.content().noEnergy());
    }

    @Override
    public List<ITextComponent> getDebugmessages() {
        List<ITextComponent> list = super.getDebugmessages();
        list.add((ITextComponent)new TextComponentString("FuelCount : " + this.fuelCount));
        return list;
    }
}

