/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.block;

import cofh.api.block.IDismantleable;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.block.QPBlock;
import com.yogpc.qp.tile.IEnchantableTile;
import ic2.api.tile.IWrenchable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import scala.Function1;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.block.IDismantleable", modid="cofhapi|block"), @Optional.Interface(iface="ic2.api.tile.IWrenchable", modid="ic2")})
public abstract class ADismCBlock
extends QPBlock
implements IDismantleable,
IWrenchable {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyBool ACTING = PropertyBool.func_177716_a((String)"acting");

    protected ADismCBlock(Material material, String name, Function<QPBlock, ? extends ItemBlock> generator) {
        super(material, name, generator);
    }

    protected ADismCBlock(Material material, String name, Function1<QPBlock, ? extends ItemBlock> generator, boolean dummy) {
        super(material, name, generator, dummy);
    }

    @Optional.Method(modid="cofhapi|block")
    public ArrayList<ItemStack> dismantleBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player, boolean returnDrops) {
        return ADismCBlock.dismantle(world, pos, state, returnDrops);
    }

    @Optional.Method(modid="cofhapi|block")
    public boolean canDismantle(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return this != QuarryPlusI.blockChunkdestroyer();
    }

    public static ArrayList<ItemStack> dismantle(World world, BlockPos pos, IBlockState state, boolean returnDrops) {
        List drops = state.func_177230_c().getDrops((IBlockAccess)world, pos, state, 0);
        world.func_175698_g(pos);
        if (!returnDrops) {
            for (ItemStack drop : drops) {
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)drop);
            }
        }
        return new ArrayList<ItemStack>(drops);
    }

    protected abstract boolean canRotate();

    @Optional.Method(modid="ic2")
    public EnumFacing getFacing(World world, BlockPos pos) {
        if (this.canRotate()) {
            return (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        }
        return EnumFacing.UP;
    }

    @Optional.Method(modid="ic2")
    public boolean setFacing(World world, BlockPos pos, EnumFacing newDirection, EntityPlayer player) {
        if (this.canRotate()) {
            TileEntity entity = world.func_175625_s(pos);
            IBlockState state = world.func_180495_p(pos);
            if (entity != null) {
                entity.func_145829_t();
                world.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)newDirection));
                entity.func_145829_t();
                world.func_175690_a(pos, entity);
            } else {
                world.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)newDirection));
            }
            return true;
        }
        return false;
    }

    @Optional.Method(modid="ic2")
    public boolean wrenchCanRemove(World world, BlockPos pos, EntityPlayer player) {
        return !this.canRotate();
    }

    @Optional.Method(modid="ic2")
    public List<ItemStack> getWrenchDrops(World world, BlockPos pos, IBlockState state, TileEntity te, EntityPlayer player, int fortune) {
        Block block = state.func_177230_c();
        if (te instanceof IEnchantableTile) {
            IEnchantableTile tile = (IEnchantableTile)te;
            ItemStack stack = new ItemStack(block);
            IEnchantableTile.Util.enchantmentToIS(tile, stack);
            if (world.func_180495_p(pos) == state) {
                world.func_175698_g(pos);
            }
            return Collections.singletonList(stack);
        }
        NonNullList list = NonNullList.func_191196_a();
        list.addAll((Collection)state.func_177230_c().getDrops((IBlockAccess)world, pos, state, fortune));
        return list;
    }
}

