/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.block;

import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.block.ADismCBlock;
import com.yogpc.qp.compat.BuildcraftHelper;
import com.yogpc.qp.compat.InvUtils;
import com.yogpc.qp.item.ItemBlockAdvPump;
import com.yogpc.qp.tile.IEnchantableTile;
import com.yogpc.qp.tile.TileAdvPump;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAdvPump
extends ADismCBlock {
    public BlockAdvPump() {
        super(Material.field_151573_f, "standalonepump", ItemBlockAdvPump::new);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)ACTING, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (InvUtils.isDebugItem(playerIn, hand)) {
            return true;
        }
        if (BuildcraftHelper.isWrench(playerIn, hand, stack, new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), facing, pos))) {
            if (!worldIn.field_72995_K) {
                Optional.ofNullable((TileAdvPump)worldIn.func_175625_s(pos)).ifPresent(TileAdvPump::G_reinit);
            }
            return true;
        }
        if (Config.content().debug() && stack.func_77973_b() == Items.field_151055_y) {
            Optional.ofNullable((TileAdvPump)worldIn.func_175625_s(pos)).ifPresent(TileAdvPump::toggleDelete);
            return true;
        }
        if (stack.func_77973_b() == QuarryPlusI.itemTool() && stack.func_77952_i() == 0) {
            if (!worldIn.field_72995_K) {
                Optional.ofNullable((IEnchantableTile)worldIn.func_175625_s(pos)).ifPresent(t -> t.sendEnchantMassage(playerIn));
            }
            return true;
        }
        if (!playerIn.func_70093_af()) {
            playerIn.openGui((Object)QuarryPlus.instance(), QuarryPlusI.guiIdAdvPump(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        NonNullList drops = NonNullList.func_191196_a();
        this.getDrops((NonNullList<ItemStack>)drops, world, pos, state, fortune);
        return drops;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof TileAdvPump) {
            TileAdvPump quarry = (TileAdvPump)entity;
            ItemStack stack = new ItemStack((Block)QuarryPlusI.blockStandalonePump(), 1, 0);
            IEnchantableTile.Util.enchantmentToIS(quarry, stack);
            drops.add((Object)stack);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            Consumer<TileAdvPump> consumer = pump2 -> IEnchantableTile.Util.init(pump2, stack.func_77986_q());
            Optional.ofNullable((TileAdvPump)worldIn.func_175625_s(pos)).ifPresent(consumer.andThen(TileAdvPump.requestTicket));
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileAdvPump();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTING});
    }

    public int func_176201_c(IBlockState state) {
        boolean powered = (Boolean)state.func_177229_b((IProperty)ACTING);
        return powered ? 8 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ACTING, (Comparable)Boolean.valueOf((meta & 8) == 8));
    }

    @Override
    protected boolean canRotate() {
        return false;
    }
}

