/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.block;

import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.block.ADismCBlock;
import com.yogpc.qp.compat.BuildcraftHelper;
import com.yogpc.qp.compat.InvUtils;
import com.yogpc.qp.item.ItemBlockEnchantable;
import com.yogpc.qp.tile.IEnchantableTile;
import com.yogpc.qp.tile.TileAdvQuarry;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAdvQuarry
extends ADismCBlock {
    public BlockAdvQuarry() {
        super(Material.field_151573_f, "chunkdestroyer", ItemBlockEnchantable::new);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTING, (Comparable)Boolean.valueOf(false)));
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        NonNullList list = NonNullList.func_191196_a();
        this.getDrops((NonNullList<ItemStack>)list, world, pos, state, fortune);
        return list;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof TileAdvQuarry) {
            TileAdvQuarry quarry = (TileAdvQuarry)entity;
            ItemStack stack = new ItemStack((Block)QuarryPlusI.blockChunkdestroyer(), 1, 0);
            IEnchantableTile.Util.enchantmentToIS(quarry, stack);
            drops.add((Object)stack);
        }
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (InvUtils.isDebugItem(playerIn, hand)) {
            return true;
        }
        if (BuildcraftHelper.isWrench(playerIn, hand, stack, new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), facing, pos))) {
            TileAdvQuarry quarry;
            if (!worldIn.field_72995_K && (quarry = (TileAdvQuarry)worldIn.func_175625_s(pos)) != null) {
                quarry.G_reinit();
                if (Config.content().noEnergy()) {
                    quarry.stickActivated(playerIn);
                }
            }
            return true;
        }
        if (stack.func_77973_b() == QuarryPlusI.itemTool()) {
            switch (stack.func_77952_i()) {
                case 0: {
                    if (worldIn.field_72995_K) break;
                    Optional.ofNullable((IEnchantableTile)worldIn.func_175625_s(pos)).ifPresent(t -> t.sendEnchantMassage(playerIn));
                    break;
                }
                case 2: {
                    QuarryPlus.proxy.openAdvQuarryPumpGui(worldIn, playerIn, (TileAdvQuarry)worldIn.func_175625_s(pos), facing);
                }
            }
            return true;
        }
        if (stack.func_77973_b() == Items.field_151055_y) {
            if (!worldIn.field_72995_K) {
                Optional.ofNullable((TileAdvQuarry)worldIn.func_175625_s(pos)).ifPresent(tileAdvQuarry -> {
                    if (Config.content().noEnergy()) {
                        tileAdvQuarry.stickActivated(playerIn);
                    }
                    tileAdvQuarry.startFillMode();
                });
            }
            return true;
        }
        if (!playerIn.func_70093_af()) {
            playerIn.openGui((Object)QuarryPlus.instance(), QuarryPlusI.guiIdAdvQuarry(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            EnumFacing facing = placer.func_174811_aO().func_176734_d();
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)facing), 2);
            Consumer<TileAdvQuarry> consumer = quarry -> IEnchantableTile.Util.init(quarry, stack.func_77986_q());
            Optional.ofNullable((TileAdvQuarry)worldIn.func_175625_s(pos)).ifPresent(consumer.andThen(TileAdvQuarry.requestTicket));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTING});
    }

    public int func_176201_c(IBlockState state) {
        boolean powered = (Boolean)state.func_177229_b((IProperty)ACTING);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return facing.func_176745_a() | (powered ? 8 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)ACTING, (Comparable)Boolean.valueOf((meta & 8) == 8));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (!worldIn.field_72995_K) {
            Optional.ofNullable((TileAdvQuarry)worldIn.func_175625_s(pos)).ifPresent(TileAdvQuarry::energyConfigure);
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileAdvQuarry();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!Config.content().disableMapJ().get(TileAdvQuarry.SYMBOL()).booleanValue()) {
            super.func_149666_a(itemIn, tab, list);
        }
    }

    @Override
    protected boolean canRotate() {
        return true;
    }
}

