/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.block;

import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.ReflectionHelper;
import com.yogpc.qp.block.ADismCBlock;
import com.yogpc.qp.compat.BuildcraftHelper;
import com.yogpc.qp.compat.InvUtils;
import com.yogpc.qp.item.ItemBlockBreaker;
import com.yogpc.qp.tile.IEnchantableTile;
import com.yogpc.qp.tile.TileBasic;
import com.yogpc.qp.tile.TileBreaker;
import com.yogpc.qp.version.VersionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import scala.Symbol;

public class BlockBreaker
extends ADismCBlock {
    public static final Symbol SYMBOL = Symbol.apply((String)"BreakerPlus");
    private final ArrayList<ItemStack> drops = new ArrayList();

    public BlockBreaker() {
        super(Material.field_151576_e, "breakerplus", ItemBlockBreaker::new);
        this.func_149711_c(3.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        if (!worldIn.field_72995_K && !Config.content().disableMapJ().get(SYMBOL).booleanValue()) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            BlockPos pos1 = pos.func_177972_a(facing);
            if (pos1.func_177956_o() < 1) {
                return;
            }
            IBlockState blockState = worldIn.func_180495_p(pos1);
            if (!BlockBreaker.isBlockBreakable(state, worldIn, pos1)) {
                return;
            }
            FakePlayer player = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)worldIn));
            blockState.func_177230_c().func_176208_a(worldIn, pos1, blockState, (EntityPlayer)player);
            SoundType type = blockState.func_177230_c().getSoundType(state, worldIn, pos1, (Entity)player);
            if (!blockState.func_177230_c().removedByPlayer(blockState, worldIn, pos1, (EntityPlayer)player, true)) {
                return;
            }
            blockState.func_177230_c().func_176206_d(worldIn, pos1, blockState);
            worldIn.func_184133_a((EntityPlayer)player, pos1, type.func_185845_c(), SoundCategory.BLOCKS, (type.func_185843_a() + 1.0f) / 2.0f, type.func_185847_b() * 0.8f);
            TileBreaker tile = (TileBreaker)worldIn.func_175625_s(pos);
            if (tile != null) {
                List<ItemStack> stackList = tile.silktouch() && blockState.func_177230_c().canSilkHarvest(worldIn, pos1, blockState, (EntityPlayer)player) ? Collections.singletonList((ItemStack)ReflectionHelper.invoke(TileBasic.createStackedBlock, blockState.func_177230_c(), blockState)) : blockState.func_177230_c().getDrops((IBlockAccess)worldIn, pos1, blockState, (int)tile.fortune());
                for (ItemStack is : stackList) {
                    ItemStack inserted = InvUtils.injectToNearTile(worldIn, pos, is);
                    if (!VersionUtil.nonEmpty(inserted)) continue;
                    InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)inserted);
                }
            }
        }
    }

    private static boolean isBlockBreakable(IBlockState state, World world, BlockPos pos) {
        if (state.func_177230_c().isAir(state, (IBlockAccess)world, pos)) {
            return false;
        }
        float hardness = state.func_185887_b(world, pos);
        return hardness != -1.0f || Config.content().removeBedrock();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            Optional.ofNullable((IEnchantableTile)worldIn.func_175625_s(pos)).ifPresent(t -> IEnchantableTile.Util.init(t, stack.func_77986_q()));
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return base_state.func_177229_b((IProperty)FACING) != side;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        boolean flag = worldIn.func_175640_z(pos);
        if (flag != (Boolean)state.func_177229_b((IProperty)POWERED)) {
            TileEntity entity;
            state = state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(flag));
            if (flag) {
                this.func_180650_b(worldIn, pos, state, worldIn.field_73012_v);
            }
            if ((entity = worldIn.func_175625_s(pos)) != null) {
                entity.func_145829_t();
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
                entity.func_145829_t();
                worldIn.func_175690_a(pos, entity);
            }
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return this.drops;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        this.drops.clear();
        Optional.ofNullable((TileBreaker)worldIn.func_175625_s(pos)).ifPresent(tile -> {
            int count = this.quantityDropped(state, 0, worldIn.field_73012_v);
            Item id1 = this.func_180660_a(state, worldIn.field_73012_v, 0);
            for (int i = 0; i < count; ++i) {
                ItemStack is = new ItemStack(id1, 1, this.func_180651_a(state));
                IEnchantableTile.Util.enchantmentToIS(tile, is);
                this.drops.add(is);
            }
        });
        super.func_180663_b(worldIn, pos, state);
    }

    public TileBreaker createNewTileEntity(World worldIn, int meta) {
        return new TileBreaker();
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151055_y || BuildcraftHelper.isWrench(playerIn, hand, stack, new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), facing, pos))) {
            TileEntity entity = worldIn.func_175625_s(pos);
            if (entity != null) {
                entity.func_145829_t();
                worldIn.func_180501_a(pos, state.func_177231_a((IProperty)FACING), 3);
                entity.func_145829_t();
                worldIn.func_175690_a(pos, entity);
            }
            return true;
        }
        if (stack.func_77973_b() == QuarryPlusI.itemTool() && stack.func_77952_i() == 0) {
            if (!worldIn.field_72995_K) {
                Optional.ofNullable((IEnchantableTile)worldIn.func_175625_s(pos)).ifPresent(t -> t.sendEnchantMassage(playerIn));
            }
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public int func_176201_c(IBlockState state) {
        boolean powered = (Boolean)state.func_177229_b((IProperty)POWERED);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return facing.func_176745_a() | (powered ? 8 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) == 8));
    }

    @Override
    protected boolean canRotate() {
        return true;
    }
}

