/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.block;

import com.yogpc.qp.block.ADismCBlock;
import com.yogpc.qp.block.BlockPump;
import com.yogpc.qp.item.ItemBlockPump;
import com.yogpc.qp.tile.IEnchantableTile;
import com.yogpc.qp.tile.TileExpPump;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import scala.Symbol;

public class BlockExpPump
extends ADismCBlock {
    public static final Symbol SYMBOL = Symbol.apply((String)"ExpPump");

    public BlockExpPump() {
        super(Material.field_151573_f, "exppump", ItemBlockPump::new);
        this.func_149711_c(5.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)ACTING, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockPump.CONNECTED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!playerIn.func_70093_af()) {
            TileEntity tileEntity;
            if (!worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileExpPump) {
                TileExpPump expPump = (TileExpPump)tileEntity;
                expPump.onActivated(worldIn, pos, playerIn);
            }
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity entity = worldIn.func_175625_s(pos);
        if (entity instanceof IEnchantableTile) {
            IEnchantableTile.Util.init((IEnchantableTile)entity, stack.func_77986_q());
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        Optional.ofNullable((TileExpPump)worldIn.func_175625_s(pos)).ifPresent(TileExpPump::G_reinit);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTING, BlockPump.CONNECTED});
    }

    public int func_176201_c(IBlockState state) {
        boolean work = (Boolean)state.func_177229_b((IProperty)ACTING);
        boolean connected = (Boolean)state.func_177229_b((IProperty)BlockPump.CONNECTED);
        return (work ? 1 : 0) | (connected ? 2 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ACTING, (Comparable)Boolean.valueOf((meta & 1) == 1)).func_177226_a((IProperty)BlockPump.CONNECTED, (Comparable)Boolean.valueOf((meta & 2) == 2));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileExpPump();
    }

    @Override
    protected boolean canRotate() {
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        NonNullList drops = NonNullList.func_191196_a();
        this.getDrops((NonNullList<ItemStack>)drops, world, pos, state, fortune);
        return drops;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof TileExpPump) {
            TileExpPump pump2 = (TileExpPump)entity;
            ItemStack stack = new ItemStack((Block)this);
            IEnchantableTile.Util.enchantmentToIS(pump2, stack);
            drops.add((Object)stack);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity entity;
        if (!worldIn.field_72995_K && (entity = worldIn.func_175625_s(pos)) instanceof TileExpPump) {
            TileExpPump pump2 = (TileExpPump)entity;
            pump2.onBreak(worldIn);
        }
        super.func_180663_b(worldIn, pos, state);
    }
}

