/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.block;

import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.tile.TilePump;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEmptyDrops;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFrame
extends BlockEmptyDrops {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool TOP = PropertyBool.func_177716_a((String)"top");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool DAMMING = PropertyBool.func_177716_a((String)"damming");
    public static final AxisAlignedBB BOX_AABB = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
    public static final AxisAlignedBB North_AABB = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.25);
    public static final AxisAlignedBB South_AABB = new AxisAlignedBB(0.25, 0.25, 0.75, 0.75, 0.75, 1.0);
    public static final AxisAlignedBB West_AABB = new AxisAlignedBB(0.0, 0.25, 0.25, 0.25, 0.75, 0.75);
    public static final AxisAlignedBB East_AABB = new AxisAlignedBB(0.75, 0.25, 0.25, 1.0, 0.75, 0.75);
    public static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.25, 0.75, 0.25, 0.75, 1.0, 0.75);
    public static final AxisAlignedBB Down_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.25, 0.75);
    private static final BiPredicate<World, BlockPos> HASNEIGHBOURLIQUID = (world, pos) -> Stream.of(EnumFacing.field_82609_l).map(arg_0 -> ((BlockPos)pos).func_177972_a(arg_0)).map(arg_0 -> ((World)world).func_180495_p(arg_0)).anyMatch(state -> !state.func_185917_h() && TilePump.isLiquid(state));
    public final ItemBlock itemBlock;
    private boolean breaking = false;

    public BlockFrame() {
        super(Material.field_151592_s);
        this.func_149711_c(0.5f);
        this.func_149647_a(QuarryPlusI.creativeTab());
        this.func_149663_c("quarryframe");
        this.setRegistryName("quarryplus", "quarryframe");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DAMMING, (Comparable)Boolean.valueOf(false)));
        this.itemBlock = new ItemBlock((Block)this);
        this.itemBlock.setRegistryName("quarryplus", "quarryframe");
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177978_c()))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177974_f()))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177968_d()))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177976_e()))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177977_b()))).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177984_a())));
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!Config.content().disableFrameChainBreak()) {
            boolean firstBreak;
            if (this.breaking) {
                firstBreak = false;
            } else {
                firstBreak = true;
                this.breaking = true;
            }
            if (firstBreak) {
                if (!HASNEIGHBOURLIQUID.test(world, pos)) {
                    this.breakChain(world, pos);
                }
                this.breaking = false;
            }
        }
    }

    private void breakChain(World world, BlockPos first) {
        if (!world.field_72995_K) {
            HashSet<BlockPos> set = new HashSet<BlockPos>();
            set.add(first);
            ArrayList<BlockPos> nextCheck = new ArrayList<BlockPos>();
            nextCheck.add(first);
            while (!nextCheck.isEmpty()) {
                List list = (List)nextCheck.clone();
                nextCheck.clear();
                for (BlockPos pos : list) {
                    for (EnumFacing dir : EnumFacing.field_82609_l) {
                        BlockPos nPos = pos.func_177972_a(dir);
                        IBlockState nBlock = world.func_180495_p(nPos);
                        if (nBlock.func_177230_c() != this || HASNEIGHBOURLIQUID.test(world, nPos) || !set.add(nPos)) continue;
                        nextCheck.add(nPos);
                    }
                }
            }
            set.forEach(arg_0 -> ((World)world).func_175698_g(arg_0));
        }
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)DAMMING) != false ? 1 : 0;
    }

    private boolean canConnectTo(IBlockAccess worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c() == this;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, WEST, SOUTH, TOP, DOWN, DAMMING});
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a((IProperty)DAMMING, (Comparable)Boolean.valueOf(meta == 1));
    }

    public IBlockState getDammingState() {
        return this.func_176223_P().func_177226_a((IProperty)DAMMING, (Comparable)Boolean.valueOf(true));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        AxisAlignedBB aabb = BOX_AABB;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            aabb = aabb.func_111270_a(North_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            aabb = aabb.func_111270_a(South_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            aabb = aabb.func_111270_a(West_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            aabb = aabb.func_111270_a(East_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            aabb = aabb.func_111270_a(UP_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            aabb = aabb.func_111270_a(Down_AABB);
        }
        return aabb;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        state = state.func_185899_b((IBlockAccess)worldIn, pos);
        BlockFrame.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOX_AABB);
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            BlockFrame.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)North_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            BlockFrame.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)South_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            BlockFrame.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)West_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            BlockFrame.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)East_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            BlockFrame.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)UP_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            BlockFrame.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)Down_AABB);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (!Config.content().disableFrameChainBreak() && ((Boolean)state.func_177229_b((IProperty)DAMMING)).booleanValue()) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)DAMMING, (Comparable)Boolean.valueOf(HASNEIGHBOURLIQUID.test(worldIn, pos))), 2);
        }
    }
}

