/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.gui;

import com.yogpc.qp.container.ContainerWorkbench;
import com.yogpc.qp.tile.TileWorkbench;
import com.yogpc.qp.version.VersionUtil;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiWorkbench
extends GuiContainer {
    private static final RenderItem myitem = new MyRenderItem(Minecraft.func_71410_x().func_110434_K(), Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a(), Minecraft.func_71410_x().getItemColors());
    private static final ResourceLocation gui = new ResourceLocation("quarryplus", "textures/gui/workbench.png");
    private final TileWorkbench tile;
    private static final Field item;
    @Nullable
    private RenderItem nitem;
    @Nullable
    private RenderItem pitem;

    public GuiWorkbench(EntityPlayer player, TileWorkbench tw) {
        super((Container)new ContainerWorkbench(player, tw));
        this.field_146999_f = 176;
        this.field_147000_g = 222;
        this.tile = tw;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"tile.workbenchplus.name", (Object[])new Object[0]), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(gui);
        int xf = this.field_146294_l - this.field_146999_f >> 1;
        int yf = this.field_146295_m - this.field_147000_g >> 1;
        this.func_73729_b(xf, yf, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tile.isWorking()) {
            this.func_73729_b(xf + 8, yf + 78, 0, this.field_147000_g, this.tile.getProgressScaled(160), 4);
            int cur_recipe = 27 + this.tile.getRecipeIndex();
            int i = this.tile.workcontinue ? 16 : 0;
            this.func_73729_b(xf + 8 + cur_recipe % 9 * 18, yf + 90 + (cur_recipe / 9 - 3) * 18, this.field_146999_f + i, 0, 16, 16);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.handlePre();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.handlePost();
    }

    public void handlePre() {
        if (item != null) {
            try {
                this.nitem = (RenderItem)item.get(null);
                item.set(null, myitem);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.pitem = this.field_146296_j;
        this.field_146296_j = myitem;
    }

    public void handlePost() {
        if (this.pitem != null) {
            this.field_146296_j = this.pitem;
            this.pitem = null;
        }
        if (this.nitem != null) {
            try {
                item.set(null, this.nitem);
                this.nitem = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        Field field = null;
        try {
            Class<?> clazz = Class.forName("codechicken.nei.guihook.GuiContainerManager");
            field = clazz.getDeclaredField("drawItems");
            field.setAccessible(true);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        item = field;
    }

    private static final class MyRenderItem
    extends RenderItem {
        private static final MyFontRenderer myfont = new MyFontRenderer();
        boolean t = true;

        public MyRenderItem(TextureManager textureManager, ModelManager modelManager, ItemColors itemColors) {
            super(textureManager, modelManager, itemColors);
        }

        public void func_184391_a(@Nullable EntityLivingBase livingBase, ItemStack stack, int xPosition, int yPosition) {
            if (this.t) {
                Minecraft.func_71410_x().func_175599_af().func_184391_a(livingBase, stack, xPosition, yPosition);
            } else {
                super.func_184391_a(livingBase, stack, xPosition, yPosition);
            }
        }

        public void func_180453_a(FontRenderer fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text) {
            if (VersionUtil.getCount(stack) > 64) {
                super.func_180453_a(myfont.setParent(fr), stack, xPosition, yPosition, text);
            } else {
                Minecraft.func_71410_x().func_175599_af().func_180453_a(fr, stack, xPosition, yPosition, text);
            }
        }
    }

    private static final class MyFontRenderer
    extends FontRenderer {
        private FontRenderer p;

        public MyFontRenderer() {
            super(Minecraft.func_71410_x().field_71474_y, new ResourceLocation("textures/font/ascii.png"), Minecraft.func_71410_x().field_71446_o, false);
        }

        public int func_175063_a(String text, float x, float y, int color) {
            int l = this.p.func_78256_a(text);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y, (float)0.0f);
            if (l > 16) {
                float f = 16.0f / (float)l;
                GL11.glTranslatef((float)(l - 16), (float)((float)this.p.field_78288_b * (1.0f - f)), (float)0.0f);
                GL11.glScalef((float)f, (float)f, (float)1.0f);
            }
            l = this.p.func_175063_a(text, 0.0f, 0.0f, color);
            GL11.glPopMatrix();
            return l;
        }

        public int func_78256_a(String s) {
            return this.p.func_78256_a(s);
        }

        FontRenderer setParent(FontRenderer r) {
            this.p = r;
            return this;
        }
    }
}

