/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.item;

import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.version.VersionUtil;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.end.DragonFightManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMirror
extends ItemFood {
    public static final int Dimension_Meta = 1;
    public static final int Overworld_Meta = 2;
    private static final Method UPDATE_PLAYERS = ReflectionHelper.findMethod(DragonFightManager.class, (String)"updateplayers", (String)"func_186100_j", (Class[])new Class[0]);

    public ItemMirror() {
        super(0, 0.0f, false);
        this.func_77627_a(true);
        this.func_77655_b("magicmirror");
        this.setRegistryName("quarryplus", "magicmirror");
        this.func_77637_a(QuarryPlusI.creativeTab());
        this.func_77848_i();
    }

    protected void func_77849_c(ItemStack stack, World worldIn, EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            playerMP.func_184210_p();
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (stack.func_77952_i() == 2) {
                if (playerMP.field_71093_bK != 0) {
                    ItemMirror.changeDimension(playerMP, server, 0);
                }
            } else if (!playerMP.func_71121_q().field_73011_w.func_76567_e()) {
                if (stack.func_77952_i() == 1) {
                    ItemMirror.changeDimension(playerMP, server, playerMP.func_71121_q().field_73011_w.getRespawnDimension(playerMP));
                } else {
                    return;
                }
            }
            BlockPos c = this.getBedLocation(playerMP, playerMP.field_71093_bK);
            playerMP.func_71121_q().func_72863_F().func_186025_d(c.func_177958_n() >> 4, c.func_177952_p() >> 4);
            playerMP.func_70634_a((double)c.func_177958_n() + 0.5, (double)c.func_177956_o() + 0.1, (double)c.func_177952_p() + 0.5);
        }
    }

    private static void changeDimension(EntityPlayerMP playerMP, MinecraftServer server, int dimensionIn) {
        int preDim = playerMP.field_71093_bK;
        server.func_184103_al().transferPlayerToDimension(playerMP, dimensionIn, (Teleporter)new DummyTeleporter(playerMP));
        if (server.func_71218_a((int)preDim).field_73011_w instanceof WorldProviderEnd) {
            WorldProviderEnd providerEnd = (WorldProviderEnd)server.func_71218_a((int)preDim).field_73011_w;
            Optional.ofNullable(providerEnd.func_186063_s()).ifPresent(dragonFightManager -> {
                try {
                    UPDATE_PLAYERS.invoke(dragonFightManager, new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    @Nonnull
    private BlockPos getBedLocation(EntityPlayerMP playerMP, int dim) {
        return Optional.ofNullable(playerMP.getBedLocation(dim)).map(p -> EntityPlayerMP.func_180467_a((World)playerMP.func_71121_q(), (BlockPos)p, (boolean)playerMP.isSpawnForced(dim))).orElseGet(() -> playerMP.func_71121_q().field_73011_w.getRandomizedSpawnPoint());
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        ItemStack itemStack = super.func_77654_b(stack, worldIn, entityLiving);
        VersionUtil.setCountForce(itemStack, VersionUtil.getCount(itemStack) + 1);
        return itemStack;
    }

    public int func_77626_a(ItemStack i) {
        return 100;
    }

    public EnumAction func_77661_b(ItemStack i) {
        return EnumAction.EAT;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.func_184598_c(handIn);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public String func_77667_c(ItemStack is) {
        switch (is.func_77952_i()) {
            case 2: {
                return "item.overworldmirror";
            }
            case 1: {
                return "item.dimensionmirror";
            }
        }
        return super.func_77667_c(is);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Item)this, 1, 0));
        items.add((Object)new ItemStack((Item)this, 1, 1));
        items.add((Object)new ItemStack((Item)this, 1, 2));
    }

    private static class DummyTeleporter
    extends Teleporter {
        public DummyTeleporter(EntityPlayerMP playerMP) {
            super(playerMP.func_71121_q());
        }

        public void func_180266_a(Entity entityIn, float rotationYaw) {
            int i = MathHelper.func_76128_c((double)entityIn.field_70165_t);
            int j = MathHelper.func_76128_c((double)entityIn.field_70163_u) - 1;
            int k = MathHelper.func_76128_c((double)entityIn.field_70161_v);
            entityIn.func_70012_b((double)i, (double)j, (double)k, entityIn.field_70177_z, 0.0f);
            entityIn.field_70159_w = 0.0;
            entityIn.field_70181_x = 0.0;
            entityIn.field_70179_y = 0.0;
        }

        public boolean func_180620_b(Entity entityIn, float rotationYaw) {
            return false;
        }

        public boolean func_85188_a(Entity entityIn) {
            return true;
        }

        public void func_85189_a(long worldTime) {
        }
    }
}

