/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.advquarry;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.tile.TileAdvQuarry;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AdvModeMessage
implements IMessage {
    int dim;
    BlockPos pos;
    NBTTagCompound modeNBT;

    public static AdvModeMessage create(TileAdvQuarry quarry) {
        AdvModeMessage message = new AdvModeMessage();
        message.dim = quarry.func_145831_w().field_73011_w.getDimension();
        message.pos = quarry.func_174877_v();
        TileAdvQuarry.Mode mode = quarry.mode();
        TileAdvQuarry.DigRange digRange = quarry.digRange();
        NBTTagCompound nbt = new NBTTagCompound();
        message.modeNBT = digRange.writeToNBT(mode.writeToNBT(nbt));
        return message;
    }

    @Override
    public void fromBytes(PacketBuffer buffer) throws IOException {
        this.pos = buffer.func_179259_c();
        this.dim = buffer.readInt();
        this.modeNBT = buffer.func_150793_b();
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos).writeInt(this.dim);
        buffer.func_150786_a(this.modeNBT);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IMessage onRecieve(IMessage message, MessageContext ctx) {
        TileEntity entity;
        World world = QuarryPlus.proxy.getPacketWorld(ctx.netHandler);
        if (world.field_73011_w.getDimension() == this.dim && (entity = world.func_175625_s(this.pos)) instanceof TileAdvQuarry) {
            TileAdvQuarry quarry = (TileAdvQuarry)entity;
            Minecraft.func_71410_x().func_152344_a(quarry.recieveModeMessage(this.modeNBT));
        }
        return null;
    }
}

