/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.laser;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.tile.TileLaser;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LaserMessage
implements IMessage {
    BlockPos pos;
    Vec3d[] vec3ds;

    public static LaserMessage create(TileLaser laser) {
        LaserMessage message = new LaserMessage();
        message.pos = laser.func_174877_v();
        message.vec3ds = laser.lasers;
        return message;
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.vec3ds = new Vec3d[buffer.readInt()];
        for (int i = 0; i < this.vec3ds.length; ++i) {
            this.vec3ds[i] = new Vec3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.writeInt((int)Stream.of(this.vec3ds).filter(TileLaser.nonNull).count());
        Stream.of(this.vec3ds).filter(TileLaser.nonNull).forEach(vec3d -> buffer.writeDouble(vec3d.field_72450_a).writeDouble(vec3d.field_72448_b).writeDouble(vec3d.field_72449_c));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IMessage onRecieve(IMessage message, MessageContext ctx) {
        World world = QuarryPlus.proxy.getPacketWorld(ctx.netHandler);
        TileLaser laser = (TileLaser)world.func_175625_s(this.pos);
        if (laser != null) {
            Minecraft.func_71410_x().func_152343_a(() -> {
                laser.lasers = this.vec3ds;
                return this.vec3ds;
            });
        }
        return null;
    }
}

