/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.quarry;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.tile.TileQuarry;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModeMessage
implements IMessage {
    int dim;
    BlockPos pos;
    BlockPos minPos;
    BlockPos maxPos;
    TileQuarry.Mode mode;

    public static ModeMessage create(TileQuarry quarry) {
        ModeMessage message = new ModeMessage();
        message.dim = quarry.func_145831_w().field_73011_w.getDimension();
        message.pos = quarry.func_174877_v();
        message.mode = quarry.G_getNow();
        message.minPos = quarry.getMinPos();
        message.maxPos = quarry.getMaxPos();
        return message;
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.minPos = buffer.func_179259_c();
        this.maxPos = buffer.func_179259_c();
        this.mode = (TileQuarry.Mode)buffer.func_179257_a(TileQuarry.Mode.class);
        this.dim = buffer.readInt();
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos).func_179255_a(this.minPos).func_179255_a(this.maxPos).func_179249_a((Enum)this.mode).writeInt(this.dim);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IMessage onRecieve(IMessage message, MessageContext ctx) {
        TileEntity entity;
        World world = QuarryPlus.proxy.getPacketWorld(ctx.netHandler);
        if (world.field_73011_w.getDimension() == this.dim && (entity = world.func_175625_s(this.pos)) instanceof TileQuarry) {
            TileQuarry quarry = (TileQuarry)entity;
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                quarry.setNow(this.mode);
                quarry.xMin = this.minPos.func_177958_n();
                quarry.yMin = this.minPos.func_177956_o();
                quarry.zMin = this.minPos.func_177952_p();
                quarry.xMax = this.maxPos.func_177958_n();
                quarry.yMax = this.maxPos.func_177956_o();
                quarry.zMax = this.maxPos.func_177952_p();
            });
        }
        return null;
    }
}

